/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.soft.ajlib.swing.widget;

import com.fathzer.soft.ajlib.swing.widget.TextWidget;
import com.fathzer.soft.ajlib.utilities.NullUtils;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigInteger;

public class IntegerWidget
extends TextWidget {
    private static final long serialVersionUID = 1L;
    private static final boolean DEBUG = false;
    public static final String VALUE_PROPERTY = "VALUE_PROPERTY";
    public static final BigInteger INTEGER_MAX_VALUE = BigInteger.valueOf(Integer.MAX_VALUE);
    private BigInteger value;
    private BigInteger maxValue;
    private BigInteger minValue;

    public IntegerWidget() {
        this(null, null);
    }

    public IntegerWidget(BigInteger minValue, BigInteger maxValue) {
        if (minValue != null && maxValue != null && minValue.compareTo(maxValue) > 0) {
            throw new IllegalArgumentException();
        }
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                char car;
                if (IntegerWidget.this.getSelectionEnd() < IntegerWidget.this.getText().length() && IntegerWidget.this.getText().substring(IntegerWidget.this.getSelectionEnd()).indexOf(45) >= 0) {
                    e.consume();
                }
                if ((car = e.getKeyChar()) == '-') {
                    if (IntegerWidget.this.minValue == null || IntegerWidget.this.minValue.compareTo(BigInteger.ZERO) < 0) {
                        if (IntegerWidget.this.getSelectionStart() != 0) {
                            e.consume();
                        }
                    } else {
                        e.consume();
                    }
                } else if (!Character.isDigit(car)) {
                    e.consume();
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 38) {
                    if (IntegerWidget.this.value != null && (IntegerWidget.this.maxValue == null || IntegerWidget.this.value.compareTo(IntegerWidget.this.maxValue) < 0)) {
                        IntegerWidget.this.setValue(IntegerWidget.this.value.add(BigInteger.ONE));
                    }
                } else if (e.getKeyCode() == 40 && IntegerWidget.this.value != null && (IntegerWidget.this.minValue == null || IntegerWidget.this.value.compareTo(IntegerWidget.this.minValue) > 0)) {
                    IntegerWidget.this.setValue(IntegerWidget.this.value.subtract(BigInteger.ONE));
                }
            }
        });
        this.addPropertyChangeListener("text", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                IntegerWidget.this.updateValue();
            }
        });
    }

    private void updateValue() {
        BigInteger old = this.value;
        String text = this.getText().trim();
        try {
            this.value = new BigInteger(text);
            if (this.maxValue != null && this.value.compareTo(this.maxValue) > 0 || this.minValue != null && this.value.compareTo(this.minValue) < 0) {
                this.value = null;
            }
        }
        catch (NumberFormatException e) {
            this.value = null;
        }
        if (!NullUtils.areEquals(this.value, old)) {
            this.firePropertyChange(VALUE_PROPERTY, old, this.value);
        }
    }

    @Override
    public void setText(String t) {
        super.setText(t);
        this.updateValue();
    }

    public BigInteger getValue() {
        return this.value == null ? null : this.value;
    }

    public void setValue(BigInteger value) {
        if (!NullUtils.areEquals(value, this.value)) {
            this.setText(value == null ? "" : value.toString());
        }
    }

    public void setValue(Integer value) {
        this.setValue(value == null ? (BigInteger)null : BigInteger.valueOf(value.intValue()));
    }

    public void setMinValue(BigInteger min) {
        if (min != null && this.maxValue != null && min.compareTo(this.maxValue) > 0) {
            throw new IllegalArgumentException();
        }
        this.minValue = min;
        if (this.value != null && min != null && this.value.compareTo(min) < 0) {
            this.setValue((BigInteger)null);
        }
    }

    public void setMaxValue(BigInteger max) {
        if (max != null && this.minValue != null && max.compareTo(this.minValue) < 0) {
            throw new IllegalArgumentException();
        }
        this.maxValue = max;
        if (this.value != null && max != null && this.value.compareTo(max) > 0) {
            this.setValue((BigInteger)null);
        }
    }

    public void setRange(BigInteger min, BigInteger max) {
        if (min != null && max != null && min.compareTo(max) > 0) {
            throw new IllegalArgumentException();
        }
        this.minValue = min;
        this.maxValue = max;
        if (this.value != null && (min != null && this.value.compareTo(min) < 0 || max != null && this.value.compareTo(max) > 0)) {
            this.setValue((BigInteger)null);
        }
    }
}

