/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.soft.ajlib.swing.widget;

import com.fathzer.soft.ajlib.swing.widget.TextWidget;
import com.fathzer.soft.ajlib.utilities.NullUtils;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;

public class NumberWidget
extends TextWidget {
    private static final long serialVersionUID = 1L;
    private static final boolean DEBUG = false;
    private static final char NON_BREAKING_SPACE = '\u00a0';
    private static final char SPACE = ' ';
    public static final String VALUE_PROPERTY = "value";
    public static final String CONTENT_VALID_PROPERTY = "contentValid";
    private Number value;
    private DecimalFormat format;
    private boolean isEmptyAllowed = false;
    private Number minValue = Double.NEGATIVE_INFINITY;
    private Number maxValue = Double.POSITIVE_INFINITY;
    private boolean valid;

    public NumberWidget() {
        this(Locale.getDefault());
    }

    public NumberWidget(Locale locale) {
        this.format = this.buildFormat(locale);
        this.addPropertyChangeListener("text", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                NumberWidget.this.updateValue();
            }
        });
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!e.isTemporary()) {
                    NumberWidget.this.refreshText(NumberWidget.this.value);
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
    }

    protected DecimalFormat patchJavaBug4510618(DecimalFormat format) {
        DecimalFormatSymbols decimalFormatSymbols = format.getDecimalFormatSymbols();
        if (decimalFormatSymbols.getGroupingSeparator() == '\u00a0') {
            decimalFormatSymbols.setGroupingSeparator(' ');
        }
        if (decimalFormatSymbols.getDecimalSeparator() == '\u00a0') {
            decimalFormatSymbols.setDecimalSeparator(' ');
        }
        format.setDecimalFormatSymbols(decimalFormatSymbols);
        format.setPositiveSuffix(format.getPositiveSuffix().replace('\u00a0', ' '));
        format.setNegativeSuffix(format.getNegativeSuffix().replace('\u00a0', ' '));
        format.setPositivePrefix(format.getPositivePrefix().replace('\u00a0', ' '));
        format.setNegativePrefix(format.getNegativePrefix().replace('\u00a0', ' '));
        return format;
    }

    protected DecimalFormat buildFormat(Locale locale) {
        return this.patchJavaBug4510618((DecimalFormat)NumberFormat.getNumberInstance(locale));
    }

    protected void setFormat(DecimalFormat format) {
        this.format = format;
    }

    protected DecimalFormat getFormat() {
        return this.format;
    }

    protected void refreshText() {
        this.refreshText(this.value);
    }

    private void refreshText(Number value) {
        this.setText(value == null ? "" : this.format.format(value));
    }

    private void updateValue() {
        boolean oldValid = this.valid;
        Number changed = null;
        String text = this.getText().trim();
        this.valid = text.length() == 0 ? this.isEmptyAllowed : (changed = this.parseValue(text.replace('\u00a0', ' '))) != null && changed.doubleValue() >= this.minValue.doubleValue() && changed.doubleValue() <= this.maxValue.doubleValue();
        this.internalSetValue(changed == null ? null : Double.valueOf(changed.doubleValue()));
        if (this.valid != oldValid) {
            this.firePropertyChange(CONTENT_VALID_PROPERTY, oldValid, this.valid);
        }
    }

    protected Number parseValue(String text) {
        return NumberWidget.safeParse(this.format, text);
    }

    public static Number safeParse(NumberFormat format, String text) {
        ParsePosition pos = new ParsePosition(0);
        Number candidate = format.parse(text, pos);
        if (pos.getIndex() == text.length()) {
            return candidate;
        }
        return null;
    }

    public boolean isEmptyAllowed() {
        return this.isEmptyAllowed;
    }

    public void setEmptyAllowed(boolean isEmptyAllowed) {
        this.isEmptyAllowed = isEmptyAllowed;
        if (this.getText().trim().length() == 0) {
            this.updateValue();
        }
    }

    public Double getMinValue() {
        return this.minValue.doubleValue();
    }

    public void setMinValue(Double minValue) {
        this.minValue = minValue;
    }

    public Double getMaxValue() {
        return this.maxValue.doubleValue();
    }

    public void setMaxValue(Double maxValue) {
        this.maxValue = maxValue;
    }

    public Double getValue() {
        this.updateValue();
        return this.value == null ? null : new Double(this.value.doubleValue());
    }

    public void setValue(Double value) {
        this.refreshText(value);
    }

    @Override
    public void setText(String t) {
        super.setText(t);
        this.updateValue();
    }

    private boolean internalSetValue(Double value) {
        if (NullUtils.areEquals(value, this.value)) {
            return false;
        }
        Number old = this.value;
        this.value = value;
        this.firePropertyChange(VALUE_PROPERTY, old, value);
        return true;
    }

    public boolean isContentValid() {
        return this.valid;
    }
}

