/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.soft.ajlib.swing.widget;

import javax.swing.JPasswordField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class PasswordWidget
extends JPasswordField {
    private static final long serialVersionUID = 1L;
    public static final String TEXT_PROPERTY = "text";

    public PasswordWidget() {
        this(0);
    }

    public PasswordWidget(int nbColumns) {
        super("", nbColumns);
        this.setDocument(new MyDocument());
    }

    private class MyDocument
    extends PlainDocument {
        private boolean ignoreEvents = false;

        private MyDocument() {
        }

        @Override
        public void replace(int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            String oldValue = new String(PasswordWidget.this.getPassword());
            this.ignoreEvents = true;
            super.replace(offset, length, text, attrs);
            this.ignoreEvents = false;
            String newValue = new String(PasswordWidget.this.getPassword());
            if (!oldValue.equals(newValue)) {
                PasswordWidget.this.firePropertyChange(PasswordWidget.TEXT_PROPERTY, oldValue, newValue);
            }
        }

        @Override
        public void remove(int offs, int len) throws BadLocationException {
            String oldValue = new String(PasswordWidget.this.getPassword());
            super.remove(offs, len);
            String newValue = new String(PasswordWidget.this.getPassword());
            if (!this.ignoreEvents && !oldValue.equals(newValue)) {
                PasswordWidget.this.firePropertyChange(PasswordWidget.TEXT_PROPERTY, oldValue, newValue);
            }
        }
    }
}

