/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.soft.ajlib.swing.widget;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import javax.swing.JLabel;

public class RotatingLabel
extends JLabel {
    private static final long serialVersionUID = 1L;
    private int angle = 0;
    private boolean drawing;

    public void setRotation(int angleDegrees) {
        if ((angleDegrees %= 360) < 0) {
            angleDegrees = 360 + angleDegrees;
        }
        if (angleDegrees % 90 != 0) {
            throw new UnsupportedOperationException();
        }
        this.angle = angleDegrees;
        this.revalidate();
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension preferredSize = super.getPreferredSize();
        double rad = Math.toRadians(this.angle);
        int w = (int)(Math.abs((double)preferredSize.width * Math.cos(rad)) + Math.abs((double)preferredSize.height * Math.sin(rad)));
        int h = (int)(Math.abs((double)preferredSize.width * Math.sin(rad)) + Math.abs((double)preferredSize.height * Math.cos(rad)));
        Dimension result = new Dimension(w, h);
        return result;
    }

    @Override
    public Dimension getSize() {
        Dimension size = super.getSize();
        if (!this.drawing) {
            return size;
        }
        double rad = Math.toRadians(this.angle);
        int w = (int)(Math.abs((double)size.width * Math.cos(rad)) + Math.abs((double)size.height * Math.sin(rad)));
        int h = (int)(Math.abs((double)size.width * Math.sin(rad)) + Math.abs((double)size.height * Math.cos(rad)));
        return new Dimension(w, h);
    }

    @Override
    public int getHeight() {
        return this.getSize().height;
    }

    @Override
    public int getWidth() {
        return this.getSize().width;
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D gr = (Graphics2D)g.create();
        if (this.angle == 90) {
            gr.transform(AffineTransform.getQuadrantRotateInstance(1));
            gr.translate(0.0, -this.getSize().getWidth());
        } else if (this.angle == 270) {
            gr.translate(0.0, this.getSize().getHeight());
            gr.transform(AffineTransform.getQuadrantRotateInstance(3));
        } else if (this.angle == 180) {
            gr.transform(AffineTransform.getQuadrantRotateInstance(2, (double)this.getWidth() / 2.0, (double)this.getHeight() / 2.0));
        } else if (this.angle != 0) {
            gr.transform(AffineTransform.getRotateInstance(Math.toRadians(this.angle), (double)this.getWidth() / 2.0, (double)this.getHeight() / 2.0));
        }
        this.drawing = true;
        super.paintComponent(gr);
        this.drawing = false;
    }
}

