/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.soft.ajlib.swing.widget;

import com.fathzer.soft.ajlib.utilities.NullUtils;
import com.fathzer.soft.ajlib.utilities.TextMatcher;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.TreeSet;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.AbstractBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class TextWidget
extends JTextField {
    private static final long serialVersionUID = 1L;
    public static final String TEXT_PROPERTY = "text";
    public static final String PREDEFINED_VALUE = "PREDEFINED_VALUE";
    private JPopupMenu popup;
    private JList list;
    private String predefined = null;
    private String lastText = "";
    private int unsortedMax;
    private String[] proposals;

    public TextWidget() {
        this.setDocument(new MyDocument());
    }

    private void installPopup() {
        if (this.popup == null) {
            this.unsortedMax = Integer.MAX_VALUE;
            this.popup = new JPopupMenu();
            this.list = new JList(new PopupListModel());
            this.list.setAutoscrolls(true);
            this.list.setCellRenderer(new MyRenderer());
            this.popup.add(new JScrollPane(this.list));
            this.popup.setFocusable(false);
            this.addFocusListener(new FocusListener(){

                @Override
                public void focusLost(FocusEvent e) {
                    if (TextWidget.this.popup.isVisible() && !e.isTemporary() && !TextWidget.this.list.equals(e.getOppositeComponent())) {
                        TextWidget.this.popup.setVisible(false);
                        if (e.getOppositeComponent() != null) {
                            e.getOppositeComponent().requestFocus();
                        }
                    }
                }

                @Override
                public void focusGained(FocusEvent e) {
                }
            });
            this.list.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getButton() == 1) {
                        TextWidget.this.setPredefined((String)TextWidget.this.list.getSelectedValue());
                        TextWidget.this.popup.setVisible(false);
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    TextWidget.this.requestFocus();
                }
            });
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 40) {
                        if (!TextWidget.this.popup.isVisible()) {
                            TextWidget.this.showPopup();
                        } else {
                            int index = TextWidget.this.list.getSelectedIndex();
                            if (index < TextWidget.this.list.getModel().getSize()) {
                                TextWidget.this.list.setSelectedIndex(++index);
                            }
                        }
                    } else if (e.getKeyCode() == 38) {
                        int index;
                        if (TextWidget.this.popup.isVisible() && (index = TextWidget.this.list.getSelectedIndex()) > 0) {
                            TextWidget.this.list.setSelectedIndex(--index);
                        }
                    } else if (e.getKeyCode() == 10 && TextWidget.this.popup.isVisible()) {
                        if (TextWidget.this.list.getSelectedIndex() >= 0) {
                            TextWidget.this.setPredefined((String)TextWidget.this.list.getSelectedValue());
                        }
                        TextWidget.this.popup.setVisible(false);
                        e.consume();
                    }
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    String text = TextWidget.this.getText();
                    if (!text.equals(TextWidget.this.lastText)) {
                        TextWidget.this.fillModel(text);
                        TextWidget.this.lastText = text;
                        TextWidget.this.setPredefined(null);
                        TextWidget.this.showPopup();
                    }
                }
            });
        }
    }

    public TextWidget(int columns) {
        this();
        this.setColumns(columns);
    }

    private void setPredefined(String value) {
        if (value != null) {
            this.lastText = value;
            this.setText(value);
        }
        if (!NullUtils.areEquals(this.predefined, value)) {
            String oldPredefined = this.predefined;
            this.predefined = value;
            this.firePropertyChange(PREDEFINED_VALUE, oldPredefined, this.predefined);
        }
    }

    public void setPredefined(String[] array) {
        this.setPredefined(array, Integer.MAX_VALUE);
    }

    public void setPredefined(String[] array, int unsortedMax) {
        this.installPopup();
        this.unsortedMax = unsortedMax;
        this.proposals = array == null ? null : (String[])array.clone();
        this.fillModel(this.getText());
    }

    private void showPopup() {
        if (this.list.getModel().getSize() != 0) {
            Dimension size = this.popup.getPreferredSize();
            if (this.getWidth() > size.width) {
                this.popup.setPreferredSize(new Dimension(this.getWidth(), size.height));
            }
            this.popup.show(this, 0, this.getHeight());
            this.requestFocus(false);
        } else {
            this.popup.setVisible(false);
        }
    }

    private void fillModel(String text) {
        TextMatcher matcher = new TextMatcher(TextMatcher.Kind.CONTAINS, text, false, false);
        ArrayList<String> okProbaSort = new ArrayList<String>();
        TreeSet<String> okAlphabeticSort = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (String value : this.proposals) {
            if (!matcher.matches(value)) continue;
            if (okProbaSort.size() <= this.unsortedMax) {
                okProbaSort.add(value);
                continue;
            }
            okAlphabeticSort.add(value);
        }
        okProbaSort.addAll(okAlphabeticSort);
        ((PopupListModel)this.list.getModel()).setValues(okProbaSort.toArray(new String[okProbaSort.size()]));
        if (0 != this.list.getSelectedIndex()) {
            this.list.setSelectedIndex(0);
        }
    }

    private class MyDocument
    extends PlainDocument {
        private static final long serialVersionUID = 1L;
        private boolean ignoreEvents = false;

        private MyDocument() {
        }

        @Override
        public void replace(int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            String oldValue = TextWidget.this.getText();
            this.ignoreEvents = true;
            super.replace(offset, length, text, attrs);
            this.ignoreEvents = false;
            String newValue = TextWidget.this.getText();
            if (!oldValue.equals(newValue)) {
                TextWidget.this.firePropertyChange(TextWidget.TEXT_PROPERTY, oldValue, newValue);
            }
        }

        @Override
        public void remove(int offs, int len) throws BadLocationException {
            String oldValue = TextWidget.this.getText();
            super.remove(offs, len);
            String newValue = TextWidget.this.getText();
            if (!this.ignoreEvents && !oldValue.equals(newValue)) {
                TextWidget.this.firePropertyChange(TextWidget.TEXT_PROPERTY, oldValue, newValue);
            }
        }
    }

    private static final class PopupListModel
    extends AbstractListModel {
        private static final long serialVersionUID = 1L;
        String[] values = new String[0];

        PopupListModel() {
        }

        @Override
        public int getSize() {
            return this.values.length;
        }

        @Override
        public Object getElementAt(int index) {
            return this.values[index];
        }

        public void setValues(String[] values) {
            int n = this.values.length;
            if (n > 0) {
                this.values = new String[0];
                this.fireIntervalRemoved(this, 0, n);
            }
            this.values = (String[])values.clone();
            this.fireIntervalAdded(this, 0, this.values.length);
        }
    }

    private class MyRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;

        private MyRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (((String)value).length() == 0) {
                value = " ";
            }
            JComponent label = (JComponent)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (TextWidget.this.unsortedMax > 0 && index == TextWidget.this.unsortedMax) {
                UpperLineBorder border = new UpperLineBorder(label.getForeground().brighter());
                label.setBorder(new CompoundBorder(border, label.getBorder()));
            }
            return label;
        }
    }

    private static class UpperLineBorder
    extends AbstractBorder {
        private static final long serialVersionUID = 1L;
        protected Color lineColor;

        public UpperLineBorder(Color color) {
            this.lineColor = color;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor(this.lineColor);
            g.drawLine(x + 1, y, x + width - 2, y);
        }
    }
}

