/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.soft.ajlib.swing.widget.date;

import com.fathzer.soft.ajlib.swing.widget.TextWidget;
import com.fathzer.soft.ajlib.utilities.CoolDateFormatter;
import com.fathzer.soft.ajlib.utilities.NullUtils;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;

public class DateField
extends TextWidget {
    private static final long serialVersionUID = 1L;
    public static final String DATE_PROPERTY = "date";
    public static final String CONTENT_VALID_PROPERTY = "contentValid";
    private CoolDateFormatter formatter;
    private Date date;
    private boolean valid;
    private Date emptyValue;
    private boolean isEmptyNullDateValid;

    public DateField() {
        this((Date)null);
    }

    public DateField(Date emptyDate) {
        this.setColumns(7);
        this.isEmptyNullDateValid = true;
        this.emptyValue = emptyDate;
        this.formatter = new CoolDateFormatter(this.getLocale());
        Calendar calendar = Calendar.getInstance(this.getLocale());
        CoolDateFormatter.eraseTime(calendar);
        this.setDate(calendar.getTime());
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                int increment = 0;
                if (e.getKeyCode() == 40) {
                    increment = -1;
                } else if (e.getKeyCode() == 38) {
                    increment = 1;
                }
                if (increment != 0 && DateField.this.getDate() != null) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(DateField.this.getDate());
                    calendar.add(5, increment);
                    DateField.this.setDate(calendar.getTime());
                }
            }
        });
        this.addPropertyChangeListener("text", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DateField.this.updateDate();
            }
        });
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!e.isTemporary()) {
                    DateField.super.setText(DateField.this.date == null ? "" : DateField.this.formatter.format(DateField.this.date));
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
    }

    @Override
    public void setLocale(Locale locale) {
        super.setLocale(locale);
        this.formatter = new CoolDateFormatter(locale);
        if (this.date != null) {
            this.setText(this.formatter.format(this.date));
        }
    }

    public void setEmptyDate(Date date) {
        this.emptyValue = date;
        if (this.getText().trim().length() == 0) {
            this.updateDate();
        }
    }

    public void setIsEmptyNullDateIsValid(boolean valid) {
        this.isEmptyNullDateValid = valid;
        if (this.getText().trim().isEmpty()) {
            this.updateDate();
        }
    }

    private static Date parseRelativeDate(CharSequence text) {
        char c;
        Date result = null;
        if (text.length() > 1 && ((c = text.charAt(0)) == '+' || c == '-')) {
            int count;
            for (count = 1; text.length() > count && text.charAt(count) == c; ++count) {
            }
            String num = text.toString().substring(count);
            if (count <= 3 && num.matches("\\d+")) {
                int nb = Integer.parseInt(num);
                GregorianCalendar cal = new GregorianCalendar();
                cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
                cal.add((new int[]{5, 2, 1})[count - 1], c == '+' ? nb : -nb);
                return cal.getTime();
            }
        }
        return result;
    }

    private void updateDate() {
        String text = this.getText().trim();
        if (text.isEmpty()) {
            this.internalSetDate(this.emptyValue, this.emptyValue != null || this.isEmptyNullDateValid);
        } else {
            Date changed = DateField.parseRelativeDate(text);
            if (changed == null) {
                try {
                    changed = this.formatter.parse(text);
                    int year = changed.getYear() + 1900;
                    if (year < 10) {
                        SimpleDateFormat simpleFormat = (SimpleDateFormat)SimpleDateFormat.getDateInstance(3);
                        Date formatterStartYear = simpleFormat.get2DigitYearStart();
                        changed.setYear((year += (formatterStartYear.getYear() + 1900) / 100 * 100) - 1900);
                        if (changed.getTime() - formatterStartYear.getTime() < 0L) {
                            changed.setYear(year - 1800);
                        }
                    }
                }
                catch (ParseException e) {
                    try {
                        int day = Integer.parseInt(text);
                        GregorianCalendar today = new GregorianCalendar();
                        if (day > 0 && day <= today.getActualMaximum(5)) {
                            changed = new GregorianCalendar(today.get(1), today.get(2), day).getTime();
                        }
                    }
                    catch (NumberFormatException e1) {
                        try {
                            text = text + "/" + new GregorianCalendar().get(1);
                            changed = this.formatter.parse(text + "/" + new GregorianCalendar().get(1));
                        }
                        catch (ParseException parseException) {
                            // empty catch block
                        }
                    }
                }
            }
            this.internalSetDate(changed, changed != null);
        }
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        super.setText(date == null ? "" : this.formatter.format(date));
        if (date == null) {
            date = this.emptyValue;
        }
        this.internalSetDate(date, date != null || this.isEmptyNullDateValid);
    }

    @Override
    public void setText(String t) {
        super.setText(t);
        this.updateDate();
    }

    private boolean internalSetDate(Date date, boolean isValid) {
        boolean changed;
        boolean bl = changed = !NullUtils.areEquals(date, this.date);
        if (changed) {
            Date old = this.date;
            this.date = date;
            this.firePropertyChange(DATE_PROPERTY, old, date);
        }
        if (isValid != this.valid) {
            this.valid = isValid;
            this.firePropertyChange(CONTENT_VALID_PROPERTY, !this.valid, this.valid);
        }
        return changed;
    }

    public boolean isContentValid() {
        return this.valid;
    }
}

