/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.soft.ajlib.swing.widget.date;

import com.fathzer.soft.ajlib.swing.Utils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MonthWidget
extends JPanel {
    private static final long serialVersionUID = 1L;
    static final String RES_PATH = "/com/fathzer/soft/ajlib/swing/widget/date/";
    public static final String DATE_PROPERTY = "MONTH";
    private JButton previousYear = null;
    private JButton previousMonth = null;
    private JLabel currentMonth = null;
    private JButton nextMonth = null;
    private JButton nextYear = null;
    private Calendar currentDate = Calendar.getInstance();
    private DateFormat formater;
    private JButton now = null;
    private JPanel buttonsPanel;

    public MonthWidget() {
        this.currentDate.set(this.currentDate.get(1), this.currentDate.get(2), 1, 0, 0, 0);
        this.currentDate.set(14, 0);
        this.formater = new SimpleDateFormat("MMMM yyyy");
        this.initialize();
    }

    @Override
    public void setLocale(Locale l) {
        super.setLocale(l);
        this.formater = new SimpleDateFormat("MMMM yyyy", l);
        this.currentMonth.setText(this.formater.format(this.currentDate.getTime()));
    }

    public void setMonth(Date date) {
        if (date.getYear() + 1900 != this.currentDate.get(1) || date.getMonth() != this.currentDate.get(2)) {
            Date old = this.currentDate.getTime();
            this.currentDate.set(date.getYear() + 1900, date.getMonth(), 1);
            this.currentMonth.setText(this.formater.format(date));
            this.firePropertyChange(DATE_PROPERTY, old, this.currentDate.getTime());
        }
    }

    public Date getMonth() {
        return this.currentDate.getTime();
    }

    public void add(int months) {
        Date old = this.currentDate.getTime();
        this.currentDate.add(2, months);
        Date newDate = this.currentDate.getTime();
        this.currentMonth.setText(this.formater.format(newDate));
        this.firePropertyChange(DATE_PROPERTY, old, newDate);
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.anchor = 10;
        gridBagConstraints2.insets = new Insets(5, 5, 5, 0);
        gridBagConstraints2.gridy = 0;
        this.currentMonth = new JLabel();
        this.currentMonth.setText(this.formater.format(this.currentDate.getTime()));
        this.currentMonth.setHorizontalTextPosition(0);
        this.currentMonth.setHorizontalAlignment(0);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbcButtonsPanel = new GridBagConstraints();
        gbcButtonsPanel.gridx = 0;
        gbcButtonsPanel.gridy = 1;
        this.add((Component)this.getButtonsPanel(), gbcButtonsPanel);
        this.add((Component)this.currentMonth, gridBagConstraints2);
    }

    private JButton getPreviousYear() {
        if (this.previousYear == null) {
            this.previousYear = new JButton();
            this.previousYear.setIcon(Utils.createIcon(this.getClass().getResource("/com/fathzer/soft/ajlib/swing/widget/date/fast-rewind.png"), 16 * this.getFont().getSize() / 12));
            this.previousYear.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MonthWidget.this.add(-12);
                }
            });
        }
        return this.previousYear;
    }

    private JButton getPreviousMonth() {
        if (this.previousMonth == null) {
            this.previousMonth = new JButton();
            this.previousMonth.setIcon(Utils.createIcon(this.getClass().getResource("/com/fathzer/soft/ajlib/swing/widget/date/rewind.png"), 16 * this.getFont().getSize() / 12));
            this.previousMonth.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MonthWidget.this.add(-1);
                }
            });
        }
        return this.previousMonth;
    }

    private JButton getNextMonth() {
        if (this.nextMonth == null) {
            this.nextMonth = new JButton();
            this.nextMonth.setIcon(Utils.createIcon(this.getClass().getResource("/com/fathzer/soft/ajlib/swing/widget/date/forward.png"), 16 * this.getFont().getSize() / 12));
            this.nextMonth.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MonthWidget.this.add(1);
                }
            });
        }
        return this.nextMonth;
    }

    private JButton getNextYear() {
        if (this.nextYear == null) {
            this.nextYear = new JButton();
            this.nextYear.setIcon(Utils.createIcon(this.getClass().getResource("/com/fathzer/soft/ajlib/swing/widget/date/fast-forward.png"), 16 * this.getFont().getSize() / 12));
            this.nextYear.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MonthWidget.this.add(12);
                }
            });
        }
        return this.nextYear;
    }

    public JButton getNow() {
        if (this.now == null) {
            this.now = new JButton();
            this.now.setIcon(Utils.createIcon(this.getClass().getResource("/com/fathzer/soft/ajlib/swing/widget/date/stop.png"), 16 * this.getFont().getSize() / 12));
            this.now.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MonthWidget.this.setMonth(new Date());
                }
            });
        }
        return this.now;
    }

    private JPanel getButtonsPanel() {
        if (this.buttonsPanel == null) {
            this.buttonsPanel = new JPanel();
            GridBagLayout gblButtonsPanel = new GridBagLayout();
            this.buttonsPanel.setLayout(gblButtonsPanel);
            GridBagConstraints gbcPreviousYear = new GridBagConstraints();
            gbcPreviousYear.insets = new Insets(0, 0, 0, 5);
            gbcPreviousYear.gridx = 0;
            gbcPreviousYear.gridy = 0;
            this.buttonsPanel.add((Component)this.getPreviousYear(), gbcPreviousYear);
            GridBagConstraints gbcPreviousMonth = new GridBagConstraints();
            gbcPreviousMonth.insets = new Insets(0, 0, 0, 5);
            gbcPreviousMonth.gridx = 1;
            gbcPreviousMonth.gridy = 0;
            this.buttonsPanel.add((Component)this.getPreviousMonth(), gbcPreviousMonth);
            GridBagConstraints gbcNow = new GridBagConstraints();
            gbcNow.fill = 2;
            gbcNow.insets = new Insets(0, 0, 0, 5);
            gbcNow.gridx = 2;
            gbcNow.gridy = 0;
            this.buttonsPanel.add((Component)this.getNow(), gbcNow);
            GridBagConstraints gbcNextMonth = new GridBagConstraints();
            gbcNextMonth.insets = new Insets(0, 0, 0, 5);
            gbcNextMonth.gridx = 3;
            gbcNextMonth.gridy = 0;
            this.buttonsPanel.add((Component)this.getNextMonth(), gbcNextMonth);
            GridBagConstraints gbcNextYear = new GridBagConstraints();
            gbcNextYear.anchor = 17;
            gbcNextYear.gridx = 4;
            gbcNextYear.gridy = 0;
            this.buttonsPanel.add((Component)this.getNextYear(), gbcNextYear);
        }
        return this.buttonsPanel;
    }
}

