/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.soft.ajlib.swing.worker;

import com.fathzer.soft.ajlib.swing.framework.Application;
import com.fathzer.soft.ajlib.swing.worker.WorkInProgressPanel;
import com.fathzer.soft.ajlib.swing.worker.Worker;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.SwingWorker;

public class DefaultWorkInProgressPanel
extends WorkInProgressPanel {
    private Worker<?, ?> worker;
    private JLabel message;
    private JProgressBar progressBar;
    private JButton btnCancel;
    private transient PropertyChangeListener workerListener;

    public DefaultWorkInProgressPanel() {
        this.buildContent();
    }

    private PropertyChangeListener getListener() {
        if (this.workerListener == null) {
            this.workerListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equals("state")) {
                        DefaultWorkInProgressPanel.this.getBtnCancel().setEnabled(evt.getNewValue().equals((Object)SwingWorker.StateValue.STARTED));
                        if (evt.getNewValue().equals((Object)SwingWorker.StateValue.DONE) && !DefaultWorkInProgressPanel.this.worker.isCancelled()) {
                            DefaultWorkInProgressPanel.this.getProgressBar().setIndeterminate(false);
                            DefaultWorkInProgressPanel.this.getProgressBar().setValue(DefaultWorkInProgressPanel.this.getProgressBar().getMaximum());
                        }
                    } else if (evt.getPropertyName().equals("progress")) {
                        long absoluteValue = (Integer)evt.getNewValue() * DefaultWorkInProgressPanel.this.worker.getPhaseLength() / 100;
                        DefaultWorkInProgressPanel.this.getProgressBar().setValue((int)absoluteValue);
                    } else if (evt.getPropertyName().equals("phase") || evt.getPropertyName().equals("length")) {
                        DefaultWorkInProgressPanel.this.initPhase();
                    }
                }
            };
        }
        return this.workerListener;
    }

    protected void buildContent() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gbcMessage = new GridBagConstraints();
        gbcMessage.insets = new Insets(5, 5, 5, 5);
        gbcMessage.anchor = 17;
        gbcMessage.gridwidth = 0;
        gbcMessage.gridx = 0;
        gbcMessage.gridy = 0;
        this.add((Component)this.getLabel(), gbcMessage);
        GridBagConstraints gbcProgressBar = new GridBagConstraints();
        gbcProgressBar.weightx = 1.0;
        gbcProgressBar.insets = new Insets(0, 5, 5, 5);
        gbcProgressBar.fill = 2;
        gbcProgressBar.gridwidth = 0;
        gbcProgressBar.gridx = 0;
        gbcProgressBar.gridy = 1;
        this.add((Component)this.getProgressBar(), gbcProgressBar);
        GridBagConstraints gbcBtnCancel = new GridBagConstraints();
        gbcBtnCancel.insets = new Insets(0, 5, 5, 5);
        gbcBtnCancel.gridx = 0;
        gbcBtnCancel.gridy = 2;
        this.add((Component)this.getBtnCancel(), gbcBtnCancel);
    }

    @Override
    public Worker<?, ?> getWorker() {
        return this.worker;
    }

    @Override
    public void setSwingWorker(Worker<?, ?> worker) {
        PropertyChangeListener listener = this.getListener();
        if (this.worker != null) {
            this.worker.removePropertyChangeListener(listener);
        }
        this.worker = worker;
        this.worker.addPropertyChangeListener(listener);
        this.initPhase();
    }

    public void setMessage(String message) {
        this.message.setText(message);
    }

    public void setIcon(Icon icon) {
        this.message.setIcon(icon);
    }

    protected void initPhase() {
        if (this.worker.getPhase() != null) {
            this.setMessage(this.worker.getPhase());
        }
        int phaseLength = this.worker.getPhaseLength();
        JProgressBar pBar = this.getProgressBar();
        pBar.setIndeterminate(phaseLength <= 0);
        pBar.setStringPainted(phaseLength > 0);
        if (phaseLength > 0) {
            pBar.setMaximum(phaseLength);
        } else {
            pBar.setValue(0);
        }
    }

    public JLabel getLabel() {
        if (this.message == null) {
            this.message = new JLabel(" ");
        }
        return this.message;
    }

    public JProgressBar getProgressBar() {
        if (this.progressBar == null) {
            this.progressBar = new JProgressBar();
        }
        return this.progressBar;
    }

    public JButton getBtnCancel() {
        if (this.btnCancel == null) {
            this.btnCancel = new JButton(Application.getString("GenericButton.cancel", this.getLocale()));
            this.btnCancel.setEnabled(false);
            this.getBtnCancel().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (DefaultWorkInProgressPanel.this.worker != null) {
                        DefaultWorkInProgressPanel.this.worker.cancel(false);
                    }
                }
            });
        }
        return this.btnCancel;
    }
}

