/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.soft.ajlib.utilities;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.channels.FileLock;
import java.text.MessageFormat;
import sun.awt.shell.ShellFolder;

public class FileUtils {
    private static final String ACCESS_DENIED_MESSAGE = "What's the right message ?";

    private FileUtils() {
    }

    public static File getCanonical(File file) throws IOException {
        if (!file.exists()) {
            return file;
        }
        try {
            Class<?> cl = Class.forName("sun.awt.shell.Win32ShellFolderManager2");
            Object windowsFolderManager = cl.newInstance();
            ShellFolder sf = (ShellFolder)cl.getMethod("createShellFolder", File.class).invoke(windowsFolderManager, file);
            if (sf.isLink()) {
                return sf.getLinkLocation();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
        return file.getCanonicalFile();
    }

    public static void move(File src, File dest) throws IOException {
        File parent = dest.getAbsoluteFile().getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        if (!src.renameTo(dest)) {
            if (src.canWrite()) {
                FileUtils.copy(src, dest, true);
                if (!src.delete()) {
                    dest.delete();
                    throw new SecurityException(ACCESS_DENIED_MESSAGE);
                }
            } else {
                throw new SecurityException(ACCESS_DENIED_MESSAGE);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File src, File dest, boolean overrideExisting) throws IOException {
        if (dest.exists() && !overrideExisting) {
            throw new IOException(MessageFormat.format("File {0} already exists", dest));
        }
        FileInputStream in = new FileInputStream(src);
        try {
            FileOutputStream out = new FileOutputStream(dest);
            try {
                int c;
                while ((c = in.read()) != -1) {
                    out.write(c);
                }
            }
            finally {
                out.close();
            }
        }
        finally {
            in.close();
        }
        dest.setLastModified(src.lastModified());
    }

    public static boolean deleteDirectory(File file) {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                FileUtils.deleteDirectory(files[i]);
            }
        }
        return file.delete();
    }

    public static boolean isIncluded(File file, File directory) {
        for (File parent = file.getParentFile(); parent != null; parent = parent.getParentFile()) {
            if (!parent.equals(directory)) continue;
            return true;
        }
        return false;
    }

    public static FileOutputStream getHiddenCompliantStream(File file) throws IOException {
        if (file.isHidden() && System.getProperty("os.name", "?").startsWith("Windows")) {
            try {
                Process process = Runtime.getRuntime().exec("attrib -H \"" + file.getAbsolutePath() + "\"");
                try {
                    int result = process.waitFor();
                    if (result == 0) {
                        return new HiddenFileOutputStream(file);
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return new FileOutputStream(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isWritable(File file) {
        if (!file.exists()) {
            File parentFile = file.getAbsoluteFile().getParentFile();
            if (parentFile == null) {
                return false;
            }
            boolean bl = FileUtils.isWritable(parentFile);
            return bl;
        }
        if (!file.canWrite()) {
            return false;
        }
        if (file.isDirectory()) {
            try {
                File f = File.createTempFile("ajlib", null, file);
                f.delete();
                return true;
            }
            catch (IOException e) {
                return false;
            }
            catch (SecurityException e) {
                return false;
            }
        }
        try {
            FileOutputStream x = new FileOutputStream(file, true);
            try {
                FileLock lock = null;
                lock = x.getChannel().tryLock();
                if (lock == null) {
                    boolean bl = false;
                    return bl;
                }
                lock.release();
                boolean bl = true;
                return bl;
            }
            finally {
                x.close();
            }
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isReadable(File file) {
        if (!file.canRead()) {
            return false;
        }
        if (file.isDirectory()) {
            return true;
        }
        try {
            FileInputStream x = new FileInputStream(file);
            x.close();
            return true;
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getExtension(File file) {
        String name = file.getName();
        int index = name.lastIndexOf(46);
        if (index < 0) {
            return null;
        }
        return name.substring(index);
    }

    public static String getRootName(File file) {
        String name = file.getName();
        int index = name.lastIndexOf(46);
        if (index < 0) {
            return name;
        }
        return name.substring(0, index);
    }

    private static class HiddenFileOutputStream
    extends FileOutputStream {
        private File file;

        HiddenFileOutputStream(File file) throws FileNotFoundException {
            super(file);
            this.file = file;
        }

        @Override
        public void close() throws IOException {
            super.close();
            Process process = Runtime.getRuntime().exec("attrib +H \"" + this.file.getAbsolutePath() + "\"");
            try {
                process.waitFor();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

