/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.currency;

import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Locale;
import java.util.TimeZone;
import net.yapbam.currency.AbstractCurrencyConverter;
import net.yapbam.currency.AbstractXMLCurrencyConverter;
import net.yapbam.currency.CurrencyHandler;
import net.yapbam.remote.Cache;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ECBCurrencyConverter
extends AbstractXMLCurrencyConverter {
    private static final String ECB_RATES_URL = "https://www.ecb.int/stats/eurofxref/eurofxref-daily.xml";

    public ECBCurrencyConverter(Proxy proxy, Cache cache) {
        super(proxy, cache);
    }

    @Override
    protected URL getSourceURL() {
        try {
            return new URL(ECB_RATES_URL);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected CurrencyHandler getXMLHandler() {
        return new ECBHandler();
    }

    private static final class ECBHandler
    extends CurrencyHandler {
        private ECBHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("Cube".equals(qName)) {
                String date = attributes.getValue("time");
                if (date != null) {
                    this.getData().setCurrencyRate("EUR", 10000L);
                    String[] ids = TimeZone.getAvailableIDs();
                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm z", Locale.US);
                    try {
                        this.getData().setReferenceDate(df.parse(date + " 13:15 GMT").getTime());
                    }
                    catch (ParseException e) {
                        throw new SAXException("Cannot parse reference date: " + date + ". Available time zones are: " + Arrays.asList(ids));
                    }
                }
                String currency = attributes.getValue("currency");
                String rate = attributes.getValue("rate");
                if (currency != null && rate != null) {
                    try {
                        this.getData().setCurrencyRate(currency, AbstractCurrencyConverter.stringToLong(rate));
                    }
                    catch (Exception e) {
                        throw new SAXException("Cannot parse exchange rate: " + rate + ". " + e.getMessage());
                    }
                }
            }
        }
    }
}

