/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.data;

import net.yapbam.data.GlobalData;

public class AlertThreshold {
    public static final AlertThreshold DEFAULT = new AlertThreshold(0.0, Double.POSITIVE_INFINITY);
    public static final AlertThreshold NO = new AlertThreshold(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    private double lessThreshold;
    private double moreThreshold;

    public AlertThreshold(double lessThreshold, double moreThreshold) {
        this.lessThreshold = lessThreshold;
        this.moreThreshold = moreThreshold;
    }

    public double getMoreThreshold() {
        return this.moreThreshold;
    }

    public double getLessThreshold() {
        return this.lessThreshold;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AlertThreshold) {
            AlertThreshold al = (AlertThreshold)obj;
            return GlobalData.AMOUNT_COMPARATOR.compare(al.lessThreshold, this.lessThreshold) == 0 && GlobalData.AMOUNT_COMPARATOR.compare(al.moreThreshold, this.moreThreshold) == 0;
        }
        return super.equals(obj);
    }

    public boolean isLifeless() {
        return this.lessThreshold == Double.NEGATIVE_INFINITY && this.moreThreshold == Double.POSITIVE_INFINITY;
    }

    public int getTrigger(double amount) {
        if (GlobalData.AMOUNT_COMPARATOR.compare(amount, this.lessThreshold) < 0) {
            return -1;
        }
        if (GlobalData.AMOUNT_COMPARATOR.compare(amount, this.moreThreshold) > 0) {
            return 1;
        }
        return 0;
    }

    public int hashCode() {
        if (this.isLifeless()) {
            return 1;
        }
        return (int)Math.min(this.lessThreshold, this.moreThreshold);
    }
}

