/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.data;

import java.util.Date;
import net.yapbam.data.BalanceHistory;
import net.yapbam.data.GlobalData;
import net.yapbam.data.Transaction;
import net.yapbam.data.event.DefaultListenable;
import net.yapbam.data.event.EverythingChangedEvent;
import net.yapbam.util.DateUtils;

public class BalanceData
extends DefaultListenable {
    private double finalBalance;
    private double checkedBalance;
    private double currentBalance;
    private BalanceHistory balanceHistory;
    private int currentBalanceDate;

    BalanceData() {
    }

    void clear(double initialBalance) {
        this.currentBalanceDate = DateUtils.dateToInteger(new Date());
        this.balanceHistory = new BalanceHistory(initialBalance);
        this.finalBalance = initialBalance;
        this.currentBalance = initialBalance;
        this.checkedBalance = initialBalance;
    }

    void enableEvents(boolean enabled) {
        super.setEventsEnabled(enabled);
        if (enabled) {
            this.fireEvent(new EverythingChangedEvent(this));
        }
    }

    void updateBalance(Transaction[] transactions, boolean add) {
        if (transactions.length == 0) {
            return;
        }
        for (Transaction transaction : transactions) {
            if (add) {
                this.balanceHistory.add(transaction);
            } else {
                this.balanceHistory.remove(transaction);
            }
            double amount = transaction.getAmount();
            if (GlobalData.AMOUNT_COMPARATOR.compare(amount, 0.0) == 0) continue;
            if (!add) {
                amount = -amount;
            }
            this.finalBalance += amount;
            if (transaction.isChecked()) {
                this.checkedBalance += amount;
            }
            if (transaction.getValueDateAsInteger() > this.currentBalanceDate) continue;
            this.currentBalance += amount;
        }
        this.fireEvent(new EverythingChangedEvent(this));
    }

    void updateBalance(double amount, boolean add) {
        if (amount == 0.0) {
            return;
        }
        if (!add) {
            amount = -amount;
        }
        this.finalBalance += amount;
        this.checkedBalance += amount;
        this.currentBalance += amount;
        this.balanceHistory.add(amount, null);
        this.fireEvent(new EverythingChangedEvent(this));
    }

    public double getCurrentBalance() {
        Date today = new Date();
        int now = DateUtils.dateToInteger(today);
        if (now != this.currentBalanceDate) {
            this.currentBalance = this.balanceHistory.getBalance(today);
            this.currentBalanceDate = now;
        }
        return this.currentBalance;
    }

    public double getFinalBalance() {
        return this.finalBalance;
    }

    public double getCheckedBalance() {
        return this.checkedBalance;
    }

    public BalanceHistory getBalanceHistory() {
        return this.balanceHistory;
    }
}

