/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Observable;
import java.util.Set;
import net.yapbam.data.AbstractTransaction;
import net.yapbam.data.Account;
import net.yapbam.data.Category;
import net.yapbam.data.GlobalData;
import net.yapbam.data.Mode;
import net.yapbam.data.PeriodicalTransaction;
import net.yapbam.data.SubTransaction;
import net.yapbam.data.Transaction;
import net.yapbam.util.NullUtils;
import net.yapbam.util.TextMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Filter
extends Observable {
    private static boolean DEBUG = false;
    public static final int CHECKED = 1;
    public static final int NOT_CHECKED = 2;
    public static final int EXPENSES = 4;
    public static final int RECEIPTS = 8;
    public static final int ALL = 15;
    private String name;
    private int filter;
    private Set<Account> validAccounts;
    private Set<String> validModes;
    private Set<Category> validCategories;
    private Date dateFrom;
    private Date dateTo;
    private Date valueDateFrom;
    private Date valueDateTo;
    private double minAmount;
    private double maxAmount;
    private TextMatcher descriptionMatcher;
    private TextMatcher commentMatcher;
    private TextMatcher numberMatcher;
    private TextMatcher statementMatcher;
    private boolean suspended;
    private static final Logger LOGGER = LoggerFactory.getLogger(Filter.class);

    public Filter() {
        this.init();
        this.suspended = false;
    }

    public boolean isOk(int property) {
        if (DEBUG) {
            LOGGER.trace("---------- isOK({}) ----------", (Object)Integer.toBinaryString(property));
            LOGGER.trace("filter: {}", (Object)Integer.toBinaryString(this.filter));
            LOGGER.trace("result: {}", (Object)Integer.toBinaryString(property & this.filter));
        }
        return (property & this.filter) != 0;
    }

    @Override
    protected void setChanged() {
        super.setChanged();
        if (!this.suspended) {
            this.notifyObservers();
        }
    }

    public void setSuspended(boolean suspended) {
        this.suspended = suspended;
        if (!this.suspended && this.hasChanged()) {
            this.notifyObservers();
        }
    }

    public List<Account> getValidAccounts() {
        if (this.validAccounts == null) {
            return null;
        }
        ArrayList<Account> result = new ArrayList<Account>(this.validAccounts.size());
        for (Account account : this.validAccounts) {
            result.add(account);
        }
        return result;
    }

    public boolean isOk(Account account) {
        return this.validAccounts == null || this.validAccounts.contains(account);
    }

    public void setValidAccounts(List<Account> accounts) {
        if (!Filter.testEquals(accounts, this.validAccounts)) {
            if (accounts == null) {
                this.validAccounts = null;
            } else {
                this.validAccounts = new HashSet<Account>(accounts.size());
                this.validAccounts.addAll(accounts);
            }
            this.setChanged();
        }
    }

    private static <T> boolean testEquals(Collection<T> c1, Collection<T> c2) {
        if (c1 == null && c2 == null) {
            return true;
        }
        if (c1 == null || c2 == null) {
            return false;
        }
        if (c1.size() != c2.size()) {
            return false;
        }
        for (T element : c1) {
            if (c2.contains(element)) continue;
            return false;
        }
        return true;
    }

    public List<String> getValidModes() {
        if (this.validModes == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>(this.validModes.size());
        for (String name : this.validModes) {
            result.add(name);
        }
        return result;
    }

    public boolean isOk(Mode mode) {
        if (this.validModes == null) {
            return true;
        }
        String name = mode.equals(Mode.UNDEFINED) ? "" : mode.getName();
        return this.validModes.contains(name);
    }

    public void setValidModes(List<String> validModes) {
        if (!Filter.testEquals(validModes, this.validModes)) {
            if (validModes == null) {
                this.validModes = null;
            } else {
                this.validModes = new HashSet<String>(validModes.size());
                this.validModes.addAll(validModes);
            }
            this.setChanged();
        }
    }

    public List<Category> getValidCategories() {
        if (this.validCategories == null) {
            return null;
        }
        ArrayList<Category> result = new ArrayList<Category>(this.validCategories.size());
        for (Category account : this.validCategories) {
            result.add(account);
        }
        return result;
    }

    public boolean isOk(Category category) {
        return this.validCategories == null || this.validCategories.contains(category);
    }

    public void setValidCategories(List<Category> validCategories) {
        if (!Filter.testEquals(validCategories, this.validCategories)) {
            if (validCategories == null) {
                this.validCategories = null;
            } else {
                this.validCategories = new HashSet<Category>(validCategories.size());
                this.validCategories.addAll(validCategories);
            }
            this.setChanged();
        }
    }

    public Date getDateFrom() {
        return this.dateFrom;
    }

    public Date getDateTo() {
        return this.dateTo;
    }

    public void setDateFilter(Date from, Date to) {
        if (!NullUtils.areEquals(from, this.dateFrom) || !NullUtils.areEquals(to, this.dateTo)) {
            this.dateFrom = from;
            this.dateTo = to;
            this.setChanged();
        }
    }

    public Date getValueDateFrom() {
        return this.valueDateFrom;
    }

    public Date getValueDateTo() {
        return this.valueDateTo;
    }

    public void setValueDateFilter(Date from, Date to) {
        if (!NullUtils.areEquals(from, this.valueDateFrom) || !NullUtils.areEquals(to, this.valueDateTo)) {
            this.valueDateFrom = from;
            this.valueDateTo = to;
            this.setChanged();
        }
    }

    public double getMinAmount() {
        return this.minAmount;
    }

    public double getMaxAmount() {
        return this.maxAmount;
    }

    public void setAmountFilter(int property, double minAmount, double maxAmount) {
        if (minAmount > maxAmount || minAmount < 0.0) {
            throw new IllegalArgumentException();
        }
        int mask = 12;
        if (GlobalData.AMOUNT_COMPARATOR.compare(minAmount, this.minAmount) != 0 || GlobalData.AMOUNT_COMPARATOR.compare(maxAmount, this.maxAmount) != 0 || (property & mask) != (this.filter & mask)) {
            this.minAmount = minAmount;
            this.maxAmount = maxAmount;
            this.filter = this.filter & ~mask | property & mask;
            if (DEBUG) {
                LOGGER.trace("-> filter: {}", (Object)this.filter);
            }
            this.setChanged();
        }
    }

    public boolean isAmountOk(double amount) {
        if (GlobalData.AMOUNT_COMPARATOR.compare(amount, 0.0) < 0 && !this.isOk(4)) {
            return false;
        }
        if (GlobalData.AMOUNT_COMPARATOR.compare(amount, 0.0) > 0 && !this.isOk(8)) {
            return false;
        }
        if (GlobalData.AMOUNT_COMPARATOR.compare(amount = Math.abs(amount), this.getMinAmount()) < 0) {
            return false;
        }
        return GlobalData.AMOUNT_COMPARATOR.compare(amount, this.getMaxAmount()) <= 0;
    }

    public TextMatcher getDescriptionMatcher() {
        return this.descriptionMatcher;
    }

    public boolean isDescriptionOk(String description) {
        return this.descriptionMatcher == null ? true : this.descriptionMatcher.matches(description);
    }

    public void setDescriptionMatcher(TextMatcher matcher) {
        if (!NullUtils.areEquals(matcher, this.descriptionMatcher)) {
            this.descriptionMatcher = matcher;
            this.setChanged();
        }
    }

    public TextMatcher getCommentMatcher() {
        return this.commentMatcher;
    }

    public boolean isCommentOk(String comment) {
        return this.commentMatcher == null ? true : this.commentMatcher.matches(comment);
    }

    public void setCommentMatcher(TextMatcher textMatcher) {
        if (!NullUtils.areEquals(textMatcher, this.commentMatcher)) {
            this.commentMatcher = textMatcher;
            this.setChanged();
        }
    }

    public TextMatcher getNumberMatcher() {
        return this.numberMatcher;
    }

    public boolean isNumberOk(String number) {
        return this.numberMatcher == null ? true : this.numberMatcher.matches(number);
    }

    public void setNumberMatcher(TextMatcher numberMatcher) {
        if (!NullUtils.areEquals(numberMatcher, this.numberMatcher)) {
            this.numberMatcher = numberMatcher;
            this.setChanged();
        }
    }

    public TextMatcher getStatementMatcher() {
        return this.statementMatcher;
    }

    public void setStatementFilter(int property, TextMatcher statementFilter) {
        if ((property & 1) == 0 && statementFilter != null) {
            throw new IllegalArgumentException();
        }
        int mask = 3;
        if (!NullUtils.areEquals(statementFilter, this.statementMatcher) || (property & mask) != (this.filter & mask)) {
            this.statementMatcher = statementFilter;
            this.filter = this.filter & ~mask | property & mask;
            if (DEBUG) {
                LOGGER.trace("-> filter: {}", (Object)this.filter);
            }
            this.setChanged();
        }
    }

    public boolean isStatementOk(String statement) {
        if (statement == null) {
            return this.isOk(2);
        }
        if (!this.isOk(1)) {
            return false;
        }
        if (this.statementMatcher == null) {
            return true;
        }
        return this.statementMatcher.matches(statement);
    }

    public void clear() {
        if (this.isActive()) {
            this.setSuspended(true);
            this.init();
            this.setSuspended(false);
        }
    }

    private void init() {
        this.name = null;
        this.setDateFilter(null, null);
        this.setValueDateFilter(null, null);
        this.setValidCategories(null);
        this.setValidModes(null);
        this.setAmountFilter(12, 0.0, Double.POSITIVE_INFINITY);
        this.setDescriptionMatcher(null);
        this.setCommentMatcher(null);
        this.setNumberMatcher(null);
        this.setStatementFilter(3, null);
        this.setValidAccounts(null);
    }

    public boolean isActive() {
        return this.filter != 15 || this.getDateFrom() != null || this.getDateTo() != null || this.getValueDateFrom() != null || this.getValueDateTo() != null || this.getValidCategories() != null || this.getValidModes() != null || this.getValidAccounts() != null || this.getMinAmount() != 0.0 || this.getMaxAmount() != Double.POSITIVE_INFINITY || this.getDescriptionMatcher() != null || this.getCommentMatcher() != null || this.getNumberMatcher() != null || this.getStatementMatcher() != null;
    }

    public boolean isOk(Transaction transaction) {
        if (!(this.isOk(transaction.getAccount()) && this.isOk(transaction.getMode()) && this.isStatementOk(transaction.getStatement()) && this.isNumberOk(transaction.getNumber()) && this.isCommentOk(transaction.getComment()))) {
            return false;
        }
        if (this.getDateFrom() != null && transaction.getDate().compareTo(this.getDateFrom()) < 0) {
            return false;
        }
        if (this.getDateTo() != null && transaction.getDate().compareTo(this.getDateTo()) > 0) {
            return false;
        }
        if (this.getValueDateFrom() != null && transaction.getValueDate().compareTo(this.getValueDateFrom()) < 0) {
            return false;
        }
        if (this.getValueDateTo() != null && transaction.getValueDate().compareTo(this.getValueDateTo()) > 0) {
            return false;
        }
        if (this.isOk(transaction.getCategory()) && this.isAmountOk(transaction.getAmount()) && this.isDescriptionOk(transaction.getDescription())) {
            return true;
        }
        for (int i = 0; i < transaction.getSubTransactionSize(); ++i) {
            if (!this.isOk(transaction.getSubTransaction(i))) continue;
            return true;
        }
        return this.isComplementOk(transaction);
    }

    public boolean isOk(PeriodicalTransaction transaction) {
        if (!(this.isOk(transaction.getAccount()) && this.isOk(transaction.getMode()) && this.isCommentOk(transaction.getComment()))) {
            return false;
        }
        if (this.isOk(transaction.getCategory()) && this.isAmountOk(transaction.getAmount()) && this.isDescriptionOk(transaction.getDescription())) {
            return true;
        }
        for (int i = 0; i < transaction.getSubTransactionSize(); ++i) {
            if (!this.isOk(transaction.getSubTransaction(i))) continue;
            return true;
        }
        return this.isComplementOk(transaction);
    }

    public boolean isOk(SubTransaction subtransaction) {
        return this.isOk(subtransaction.getCategory()) && this.isAmountOk(subtransaction.getAmount()) && this.isDescriptionOk(subtransaction.getDescription());
    }

    public boolean isComplementOk(AbstractTransaction transaction) {
        double amount = transaction.getComplement();
        if (transaction.getSubTransactionSize() != 0 && GlobalData.AMOUNT_COMPARATOR.compare(amount, 0.0) == 0) {
            return false;
        }
        return this.isOk(transaction.getCategory()) && this.isAmountOk(amount) && this.isDescriptionOk(transaction.getDescription()) && this.isCommentOk(transaction.getComment());
    }

    public void copy(Filter filter) {
        this.setSuspended(true);
        this.setAmountFilter(filter.filter, filter.minAmount, filter.maxAmount);
        this.setStatementFilter(filter.filter, filter.statementMatcher);
        this.setValidAccounts(filter.getValidAccounts());
        this.setValidModes(filter.getValidModes());
        this.setValidCategories(filter.getValidCategories());
        this.setDateFilter(filter.getDateFrom(), filter.getDateTo());
        this.setValueDateFilter(filter.getValueDateFrom(), filter.getValueDateTo());
        this.setDescriptionMatcher(filter.getDescriptionMatcher());
        this.setCommentMatcher(filter.getCommentMatcher());
        this.setNumberMatcher(filter.getNumberMatcher());
        this.setName(filter.getName());
        this.setSuspended(false);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (!NullUtils.areEquals(this.name, name)) {
            this.name = name;
            this.setChanged();
        }
    }
}

