/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import net.yapbam.data.Account;
import net.yapbam.data.BalanceData;
import net.yapbam.data.Category;
import net.yapbam.data.Filter;
import net.yapbam.data.GlobalData;
import net.yapbam.data.Transaction;
import net.yapbam.data.TransactionComparator;
import net.yapbam.data.event.AccountAddedEvent;
import net.yapbam.data.event.AccountPropertyChangedEvent;
import net.yapbam.data.event.AccountRemovedEvent;
import net.yapbam.data.event.CategoryAddedEvent;
import net.yapbam.data.event.CategoryPropertyChangedEvent;
import net.yapbam.data.event.CategoryRemovedEvent;
import net.yapbam.data.event.DataEvent;
import net.yapbam.data.event.DataListener;
import net.yapbam.data.event.DefaultListenable;
import net.yapbam.data.event.EverythingChangedEvent;
import net.yapbam.data.event.IsArchivedChangedEvent;
import net.yapbam.data.event.IsLockedChangedEvent;
import net.yapbam.data.event.ModePropertyChangedEvent;
import net.yapbam.data.event.ModeRemovedEvent;
import net.yapbam.data.event.NeedToBeSavedChangedEvent;
import net.yapbam.data.event.TransactionsAddedEvent;
import net.yapbam.data.event.TransactionsRemovedEvent;
import net.yapbam.util.NullUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilteredData
extends DefaultListenable {
    private GlobalData data;
    private List<Transaction> transactions;
    private Comparator<Transaction> comparator = TransactionComparator.INSTANCE;
    private BalanceData balanceData;
    private Filter filter;
    private Logger logger;

    public FilteredData(GlobalData data) {
        this.data = data;
        this.filter = new Filter();
        this.filter.addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                FilteredData.this.filter();
            }
        });
        this.data.addListener(new DataListener(){

            @Override
            public void processEvent(DataEvent event) {
                if (FilteredData.this.eventImplySorting(event)) {
                    Collections.sort(FilteredData.this.transactions, FilteredData.this.comparator);
                }
                if (event instanceof EverythingChangedEvent) {
                    FilteredData.this.filter.clear();
                    FilteredData.this.filter();
                } else if (event instanceof AccountRemovedEvent) {
                    Account account = ((AccountRemovedEvent)event).getRemoved();
                    List<Account> validAccounts = FilteredData.this.filter.getValidAccounts();
                    if (validAccounts == null || validAccounts.remove(account)) {
                        double initialBalance = account.getInitialBalance();
                        FilteredData.this.balanceData.updateBalance(initialBalance, false);
                        int index = validAccounts == null ? ((AccountRemovedEvent)event).getIndex() : FilteredData.this.filter.getValidAccounts().indexOf(account);
                        FilteredData.this.filter.setValidAccounts(validAccounts == null || validAccounts.isEmpty() ? null : validAccounts);
                        FilteredData.this.fireEvent(new AccountRemovedEvent(FilteredData.this, index, account));
                    }
                } else if (event instanceof CategoryRemovedEvent) {
                    Category category = ((CategoryRemovedEvent)event).getRemoved();
                    List<Category> validCategories = FilteredData.this.filter.getValidCategories();
                    if (validCategories == null || validCategories.remove(category)) {
                        int index = validCategories == null ? ((CategoryRemovedEvent)event).getIndex() : FilteredData.this.filter.getValidCategories().indexOf(category);
                        FilteredData.this.filter.setValidCategories(validCategories == null || validCategories.isEmpty() ? null : validCategories);
                        FilteredData.this.fireEvent(new CategoryRemovedEvent(FilteredData.this, index, category));
                    }
                } else if (event instanceof TransactionsAddedEvent) {
                    Transaction[] ts = ((TransactionsAddedEvent)event).getTransactions();
                    ArrayList<Transaction> accountOkTransactions = new ArrayList<Transaction>(ts.length);
                    ArrayList<Transaction> okTransactions = new ArrayList<Transaction>(ts.length);
                    double addedAmount = 0.0;
                    for (Transaction transaction : ts) {
                        if (!FilteredData.this.filter.isOk(transaction.getAccount())) continue;
                        Date valueDate = transaction.getValueDate();
                        if (NullUtils.compareTo(valueDate, FilteredData.this.filter.getValueDateFrom(), true) < 0) {
                            addedAmount += transaction.getAmount();
                            continue;
                        }
                        accountOkTransactions.add(transaction);
                        if (!FilteredData.this.filter.isOk(transaction)) continue;
                        okTransactions.add(transaction);
                        int index = -Collections.binarySearch(FilteredData.this.transactions, transaction, FilteredData.this.comparator) - 1;
                        FilteredData.this.transactions.add(index, transaction);
                    }
                    FilteredData.this.balanceData.updateBalance(addedAmount, true);
                    if (!accountOkTransactions.isEmpty()) {
                        FilteredData.this.balanceData.updateBalance(accountOkTransactions.toArray(new Transaction[accountOkTransactions.size()]), true);
                    }
                    if (!okTransactions.isEmpty()) {
                        FilteredData.this.fireEvent(new TransactionsAddedEvent(FilteredData.this, okTransactions.toArray(new Transaction[okTransactions.size()])));
                    }
                } else if (event instanceof TransactionsRemovedEvent) {
                    Transaction[] ts = ((TransactionsRemovedEvent)event).getTransactions();
                    ArrayList<Transaction> accountOkTransactions = new ArrayList<Transaction>(ts.length);
                    ArrayList<Transaction> okTransactions = new ArrayList<Transaction>(ts.length);
                    double addedAmount = 0.0;
                    for (Transaction transaction : ts) {
                        if (!FilteredData.this.filter.isOk(transaction.getAccount())) continue;
                        Date valueDate = transaction.getValueDate();
                        if (NullUtils.compareTo(valueDate, FilteredData.this.filter.getValueDateFrom(), true) < 0) {
                            addedAmount -= transaction.getAmount();
                            continue;
                        }
                        accountOkTransactions.add(transaction);
                        if (!FilteredData.this.filter.isOk(transaction)) continue;
                        okTransactions.add(transaction);
                        int index = Collections.binarySearch(FilteredData.this.transactions, transaction, FilteredData.this.comparator);
                        FilteredData.this.transactions.remove(index);
                    }
                    FilteredData.this.balanceData.updateBalance(addedAmount, true);
                    if (!accountOkTransactions.isEmpty()) {
                        FilteredData.this.balanceData.updateBalance(accountOkTransactions.toArray(new Transaction[accountOkTransactions.size()]), false);
                    }
                    if (!okTransactions.isEmpty()) {
                        FilteredData.this.fireEvent(new TransactionsRemovedEvent(FilteredData.this, okTransactions.toArray(new Transaction[okTransactions.size()])));
                    }
                } else if (event instanceof AccountAddedEvent) {
                    Account account = ((AccountAddedEvent)event).getAccount();
                    if (FilteredData.this.filter.isOk(account)) {
                        FilteredData.this.balanceData.updateBalance(account.getInitialBalance(), true);
                        if (FilteredData.this.filter.isOk(1)) {
                            FilteredData.this.fireEvent(new AccountAddedEvent(FilteredData.this, account));
                        }
                    }
                } else if (event instanceof CategoryAddedEvent) {
                    Category category = ((CategoryAddedEvent)event).getCategory();
                    if (FilteredData.this.filter.isOk(category)) {
                        FilteredData.this.fireEvent(new CategoryAddedEvent(FilteredData.this, category));
                    }
                } else if (event instanceof AccountPropertyChangedEvent) {
                    AccountPropertyChangedEvent evt = (AccountPropertyChangedEvent)event;
                    if (FilteredData.this.filter.isOk(evt.getAccount())) {
                        if (evt.getProperty().equals("initialBalance")) {
                            double amount = (Double)evt.getNewValue() - (Double)evt.getOldValue();
                            FilteredData.this.balanceData.updateBalance(amount, true);
                        }
                        FilteredData.this.fireEvent(event);
                    }
                } else if (event instanceof CategoryPropertyChangedEvent) {
                    CategoryPropertyChangedEvent evt = (CategoryPropertyChangedEvent)event;
                    if (FilteredData.this.filter.isOk(evt.getCategory())) {
                        FilteredData.this.fireEvent(event);
                    }
                } else if (event instanceof ModePropertyChangedEvent) {
                    ModePropertyChangedEvent evt = (ModePropertyChangedEvent)event;
                    FilteredData.this.data.updateFilter(evt, FilteredData.this.filter);
                    if (FilteredData.this.filter.isOk(evt.getNewMode())) {
                        FilteredData.this.fireEvent(event);
                    }
                } else if (event instanceof ModeRemovedEvent) {
                    ModeRemovedEvent evt = (ModeRemovedEvent)event;
                    List<String> validModes = FilteredData.this.filter.getValidModes();
                    String removedModeName = evt.getMode().getName();
                    if (validModes != null && validModes.remove(removedModeName) && !FilteredData.this.data.isUsedByFilteredAccounts(FilteredData.this.filter, evt.getMode())) {
                        FilteredData.this.filter.setValidModes(validModes.isEmpty() ? null : validModes);
                        FilteredData.this.fireEvent(event);
                    }
                } else if (event instanceof NeedToBeSavedChangedEvent || event instanceof IsLockedChangedEvent || event instanceof IsArchivedChangedEvent) {
                    FilteredData.this.fireEvent(event);
                } else {
                    FilteredData.this.getLogger().debug("Be aware {} is not propagated by the fileredData", (Object)event);
                }
            }
        });
        this.balanceData = new BalanceData();
        this.filter();
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = LoggerFactory.getLogger(this.getClass());
        }
        return this.logger;
    }

    public BalanceData getBalanceData() {
        return this.balanceData;
    }

    private boolean eventImplySorting(DataEvent event) {
        boolean accountRenamed = event instanceof AccountPropertyChangedEvent && ((AccountPropertyChangedEvent)event).getProperty().equals("name") && this.filter.isOk(((AccountPropertyChangedEvent)event).getAccount());
        boolean categoryRenamed = event instanceof CategoryPropertyChangedEvent && this.filter.isOk(((CategoryPropertyChangedEvent)event).getCategory());
        boolean modeRenamed = event instanceof ModePropertyChangedEvent && (((ModePropertyChangedEvent)event).getChanges() & 1) != 0 && this.filter.isOk(((ModePropertyChangedEvent)event).getNewMode());
        return accountRenamed || categoryRenamed || modeRenamed;
    }

    public Filter getFilter() {
        return this.filter;
    }

    private void filter() {
        double initialBalance = 0.0;
        for (int i = 0; i < this.getGlobalData().getAccountsNumber(); ++i) {
            Account account = this.getGlobalData().getAccount(i);
            if (!this.filter.isOk(account)) continue;
            initialBalance += account.getInitialBalance();
        }
        this.balanceData.enableEvents(false);
        this.balanceData.clear(initialBalance);
        this.transactions = new ArrayList<Transaction>();
        ArrayList<Transaction> balanceTransactions = new ArrayList<Transaction>(this.data.getTransactionsNumber());
        double addedAmount = 0.0;
        for (int i = 0; i < this.data.getTransactionsNumber(); ++i) {
            Transaction transaction = this.data.getTransaction(i);
            if (!this.filter.isOk(transaction.getAccount())) continue;
            Date valueDate = transaction.getValueDate();
            if (NullUtils.compareTo(valueDate, this.filter.getValueDateFrom(), true) < 0) {
                addedAmount += transaction.getAmount();
                continue;
            }
            balanceTransactions.add(transaction);
            if (!this.filter.isOk(transaction)) continue;
            int index = -Collections.binarySearch(this.transactions, transaction, this.comparator) - 1;
            this.transactions.add(index, transaction);
        }
        this.balanceData.updateBalance(addedAmount, true);
        this.balanceData.updateBalance(balanceTransactions.toArray(new Transaction[balanceTransactions.size()]), true);
        this.balanceData.enableEvents(true);
        this.fireEvent(new EverythingChangedEvent(this));
    }

    public int getTransactionsNumber() {
        return this.transactions.size();
    }

    public Transaction getTransaction(int index) {
        return this.transactions.get(index);
    }

    public List<Transaction> getTransactions() {
        return Collections.unmodifiableList(this.transactions);
    }

    public int indexOf(Transaction transaction) {
        return Collections.binarySearch(this.transactions, transaction, this.comparator);
    }

    public GlobalData getGlobalData() {
        return this.data;
    }
}

