/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.data.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.UnsupportedEncodingException;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.yapbam.data.ProgressReport;
import net.yapbam.data.xml.UnsupportedFileVersionException;
import net.yapbam.data.xml.task.DecrypterTask;
import net.yapbam.data.xml.task.DeflaterTask;
import net.yapbam.data.xml.task.EncrypterTask;
import net.yapbam.data.xml.task.InflaterTask;
import net.yapbam.data.xml.task.PipeTask;

public abstract class AbstractSerializer<T> {
    private static final boolean NEW_ENCODER_ON = true;
    private static final byte[] PASSWORD_ENCODED_FILE_HEADER = AbstractSerializer.toBytes("<Yapbam password encoded file ***>");
    private static final String V1 = "1.0";
    private static final String V2 = "2.0";

    private static byte[] toBytes(String magicString) {
        byte[] bytes;
        try {
            bytes = magicString.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            bytes = null;
        }
        return bytes;
    }

    public void write(final T data, OutputStream out, String password, final ProgressReport report) throws IOException {
        if (password != null) {
            out.write(AbstractSerializer.getHeader(V2));
            final PipedOutputStream xmlOutput = new PipedOutputStream();
            PipedInputStream compressorInput = new PipedInputStream(xmlOutput);
            PipedOutputStream compressorOutput = new PipedOutputStream();
            PipedInputStream encoderInput = new PipedInputStream(compressorOutput);
            ThreadPoolExecutor service = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 0L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
            ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>(3);
            Callable<Void> c = new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    try {
                        AbstractSerializer.this.directWrite(data, xmlOutput, report);
                        Void void_ = null;
                        return void_;
                    }
                    finally {
                        xmlOutput.close();
                    }
                }
            };
            futures.add(service.submit(c));
            futures.add(service.submit(new DeflaterTask(compressorInput, compressorOutput)));
            PipedOutputStream encrypterOutput = new PipedOutputStream();
            PipedInputStream entryWriterInput = new PipedInputStream(encrypterOutput);
            futures.add(service.submit(new EncrypterTask(encoderInput, encrypterOutput, password, false)));
            futures.add(service.submit(new PipeTask(entryWriterInput, out)));
            try {
                for (Future future : futures) {
                    future.get();
                }
            }
            catch (ExecutionException e) {
                Throwable throwable = e.getCause();
                if (throwable instanceof IOException) {
                    throw (IOException)throwable;
                }
                throw new RuntimeException(throwable);
            }
            catch (InterruptedException e) {
                for (Future future : futures) {
                    future.cancel(true);
                }
                Thread.currentThread().interrupt();
            }
        } else {
            this.directWrite(data, out, report);
        }
    }

    public abstract void directWrite(T var1, OutputStream var2, ProgressReport var3) throws IOException;

    private static byte[] getHeader(String version) {
        int index = 0;
        byte[] result = new byte[PASSWORD_ENCODED_FILE_HEADER.length];
        for (int i = 0; i < result.length; ++i) {
            if (PASSWORD_ENCODED_FILE_HEADER[i] != 42) {
                result[i] = PASSWORD_ENCODED_FILE_HEADER[i];
                continue;
            }
            result[i] = (byte)version.charAt(index);
            ++index;
        }
        return result;
    }

    public T read(final String password, InputStream in, final ProgressReport report) throws IOException, AccessControlException {
        SerializationData serializationData = AbstractSerializer.getSerializationData(in);
        boolean encoded = serializationData.isPasswordRequired;
        if (encoded) {
            if (password == null) {
                throw new AccessControlException("Stream is encoded but password is null");
            }
            for (int i = 0; i < PASSWORD_ENCODED_FILE_HEADER.length; ++i) {
                in.read();
            }
            if (!serializationData.version.equals(V1) && !serializationData.version.equals(V2)) {
                throw new UnsupportedFileVersionException("encoded " + serializationData.version);
            }
            PipedOutputStream decoderOutput = new PipedOutputStream();
            PipedInputStream deflaterInput = new PipedInputStream(decoderOutput);
            PipedOutputStream deflaterOutput = new PipedOutputStream();
            final PipedInputStream readerInput = new PipedInputStream(deflaterOutput);
            ThreadPoolExecutor service = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 0L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
            try {
                Future<Void> decrypter = service.submit(new DecrypterTask(in, decoderOutput, password, serializationData.version.equals(V1)));
                Future<Void> inflater = service.submit(new InflaterTask(deflaterInput, deflaterOutput));
                Callable c = new Callable<T>(){

                    @Override
                    public T call() throws Exception {
                        try {
                            Object t = AbstractSerializer.this.directRead(password, readerInput, report);
                            return t;
                        }
                        finally {
                            readerInput.close();
                        }
                    }
                };
                Future reader = service.submit(c);
                decrypter.get();
                inflater.get();
                return reader.get();
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                if (cause instanceof AccessControlException) {
                    throw (AccessControlException)cause;
                }
                throw new RuntimeException(cause);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return null;
            }
        }
        return this.directRead(password, in, report);
    }

    public abstract T directRead(String var1, InputStream var2, ProgressReport var3) throws IOException;

    public boolean isPasswordOk(InputStream in, String password) throws IOException {
        SerializationData serializationData = AbstractSerializer.getSerializationData(in);
        if (!serializationData.isPasswordRequired) {
            return password == null;
        }
        try {
            if (password == null) {
                return false;
            }
            for (int i = 0; i < PASSWORD_ENCODED_FILE_HEADER.length; ++i) {
                in.read();
            }
            DecrypterTask.verifyPassword(in, password);
            return true;
        }
        catch (AccessControlException e) {
            return false;
        }
    }

    private static SerializationData getSerializationData(InputStream in) throws IOException {
        if (in.markSupported()) {
            in.mark(PASSWORD_ENCODED_FILE_HEADER.length);
        }
        boolean isEncoded = true;
        StringBuilder encodingVersion = new StringBuilder();
        for (int i = 0; i < PASSWORD_ENCODED_FILE_HEADER.length; ++i) {
            int c = in.read();
            if (PASSWORD_ENCODED_FILE_HEADER[i] == 42) {
                encodingVersion.append((char)c);
                continue;
            }
            if (c == PASSWORD_ENCODED_FILE_HEADER[i]) continue;
            isEncoded = false;
            break;
        }
        if (in.markSupported()) {
            in.reset();
        }
        return new SerializationData(isEncoded, encodingVersion.toString());
    }

    static {
        int nb = 0;
        for (byte c : PASSWORD_ENCODED_FILE_HEADER) {
            if (c != 42) continue;
            ++nb;
        }
        try {
            if (V1.getBytes("UTF-8").length != nb || V2.getBytes("UTF-8").length != nb || nb == 0) {
                throw new IllegalArgumentException("Encoded file headers versions have invalid lengths !");
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static class SerializationData {
        private boolean isPasswordRequired;
        private String version;

        private SerializationData(boolean isEncoded, String version) {
            this.isPasswordRequired = isEncoded;
            this.version = version;
        }

        public boolean isPasswordRequired() {
            return this.isPasswordRequired;
        }
    }
}

