/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.data.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import net.yapbam.data.Account;
import net.yapbam.data.AlertThreshold;
import net.yapbam.data.Category;
import net.yapbam.data.Checkbook;
import net.yapbam.data.Filter;
import net.yapbam.data.GlobalData;
import net.yapbam.data.Mode;
import net.yapbam.data.PeriodicalTransaction;
import net.yapbam.data.ProgressReport;
import net.yapbam.data.SubTransaction;
import net.yapbam.data.Transaction;
import net.yapbam.data.xml.GlobalDataHandler;
import net.yapbam.data.xml.ParsingCancelledException;
import net.yapbam.data.xml.SaxUnsupportedFileVersionException;
import net.yapbam.data.xml.UnsupportedFileVersionException;
import net.yapbam.data.xml.UnsupportedFormatException;
import net.yapbam.date.helpers.DateStepper;
import net.yapbam.date.helpers.DayDateStepper;
import net.yapbam.date.helpers.DeferredValueDateComputer;
import net.yapbam.date.helpers.MonthDateStepper;
import net.yapbam.util.ArrayUtils;
import net.yapbam.util.DateUtils;
import net.yapbam.util.TextMatcher;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class XMLSerializer {
    public static final String UTF8 = "UTF-8";
    static boolean SCHEMA_VALIDATION = Boolean.getBoolean("xml.schema.validation");
    private static final boolean SLOW_WRITING = Boolean.getBoolean("slowDataWriting");
    private static final String EMPTY = "";
    private static final String CDATA = "CDATA";
    private static final String DATE_DELIM = "/";
    private static final String TRUE = "true";
    static final int CURRENT_VERSION = 1;
    static final String VERSION_ATTRIBUTE = "version";
    static final String LOCKED_ATTRIBUTE = "locked";
    static final String ARCHIVE_ATTRIBUTE = "archive";
    static final String SUBCATEGORY_SEPARATOR_ATTRIBUTE = "subCategorySeparator";
    static final String NB_TRANSACTIONS_ATTRIBUTE = "nbTransactions";
    static final String STATEMENT_ATTRIBUTE = "statement";
    static final String VALUE_DATE_ATTRIBUTE = "valueDate";
    static final String CATEGORY_ATTRIBUTE = "category";
    static final String NUMBER_ATTRIBUTE = "number";
    static final String MODE_ATTRIBUTE = "mode";
    static final String AMOUNT_ATTRIBUTE = "amount";
    static final String DATE_ATTRIBUTE = "date";
    static final String DESCRIPTION_ATTRIBUTE = "description";
    static final String COMMENT_ATTRIBUTE = "comment";
    static final String ACCOUNT_ATTRIBUTE = "account";
    static final String DEBT_DAY_ATTRIBUTE = "debtDay";
    static final String STOP_DAY_ATTRIBUTE = "stopDay";
    static final String DAY_ATTRIBUTE = "day";
    static final String PERIOD_ATTRIBUTE = "period";
    static final String KIND_ATTRIBUTE = "kind";
    static final String IMMEDIATE_DATE_STEPPER_KIND = "immediate";
    static final String MONTHLY_DATE_STEPPER_KIND = "monthly";
    static final String DEFERRED_DATE_STEPPER_KIND = "deferred";
    static final String RELATIVE_DATE_STEPPER_KIND = "daily";
    static final String CHECKBOOK_ATTRIBUTE = "checkbook";
    static final String PREFIX_ATTRIBUTE = "prefix";
    static final String FIRST_NUMBER_ATTRIBUTE = "first";
    static final String SIZE_ATTRIBUTE = "size";
    static final String NEXT_NUMBER_ATTRIBUTE = "next";
    static final String INITIAL_BALANCE_ATTRIBUTE = "initialBalance";
    static final String ALERT_THRESHOLD_LESS = "alertThresholdLess";
    static final String ALERT_THRESHOLD_MORE = "alertThresholdMore";
    static final String ALERT_IGNORE = "no";
    static final String ID_ATTRIBUTE = "id";
    static final String NEXT_DATE_ATTRIBUTE = "next";
    static final String LAST_DATE_ATTRIBUTE = "last";
    static final String ENABLED_ATTRIBUTE = "enabled";
    static final String GLOBAL_DATA_TAG = "DATA";
    static final String CATEGORY_TAG = "CATEGORY";
    static final String ACCOUNT_TAG = "ACCOUNT";
    static final String MODE_TAG = "MODE";
    static final String CHECKBOOK_TAG = "CHECKBOOK";
    static final String EXPENSE_VDC_TAG = "EXPENSE";
    static final String RECEIPT_VDC_TAG = "RECEIPT";
    static final String PERIODICAL_TAG = "PERIODICAL";
    static final String DATE_STEPPER_TAG = "DATE_STEPPER";
    static final String TRANSACTION_TAG = "TRANSACTION";
    static final String SUBTRANSACTION_TAG = "SUBTRANSACTION";
    static final String FILTER_TAG = "FILTER";
    static final String FILTER_DATE_FROM_ATTRIBUTE = "dateFrom";
    static final String FILTER_DATE_TO_ATTRIBUTE = "dateTo";
    static final String FILTER_VALUE_DATE_FROM_ATTRIBUTE = "valueDateFrom";
    static final String FILTER_VALUE_DATE_TO_ATTRIBUTE = "valueDateTo";
    static final String FILTER_AMOUNT_FROM_ATTRIBUTE = "amountFrom";
    static final String FILTER_AMOUNT_TO_ATTRIBUTE = "amountTo";
    static final String FILTER_ATTRIBUTE = "filter";
    static final String FILTER_DESCRIPTION_ID = "description";
    static final String FILTER_COMMENT_ID = "comment";
    static final String FILTER_NUMBER_ID = "number";
    static final String FILTER_STATEMENT_ID = "statement";
    static final String TEXT_MATCHER_TAG = "TEXT_MATCHER";
    static final String CONTAINS = "contains";
    static final String EQUALS = "equals";
    static final String REGULAR = "regular";
    static final String DIACRITICAL_SENSITIVE_ATTRIBUTE = "diacriticalSensitive";
    static final String CASE_SENSITIVE_ATTRIBUTE = "caseSensitive";
    private AttributesImpl atts;
    private TransformerHandler hd;

    public XMLSerializer(OutputStream os) throws IOException {
        try {
            StreamResult streamResult = new StreamResult(os);
            SAXTransformerFactory tf = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
            this.hd = tf.newTransformerHandler();
            Transformer serializer = this.hd.getTransformer();
            serializer.setOutputProperty("encoding", UTF8);
            serializer.setOutputProperty("indent", "yes");
            this.hd.setResult(streamResult);
            this.atts = new AttributesImpl();
            this.hd.startDocument();
        }
        catch (TransformerConfigurationException e) {
            throw new IOException(e);
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
    }

    public void closeDocument() throws IOException {
        try {
            this.hd.endDocument();
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
    }

    public static GlobalData read(InputStream in, ProgressReport report) throws IOException {
        GlobalDataHandler dh = new GlobalDataHandler(SCHEMA_VALIDATION, report);
        try {
            SAXParserFactory saxFactory = SAXParserFactory.newInstance();
            if (SCHEMA_VALIDATION) {
                SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                Schema schema = schemaFactory.newSchema(XMLSerializer.class.getResource("yapbam.xsd"));
                saxFactory.setSchema(schema);
            }
            try {
                saxFactory.newSAXParser().parse(in, (DefaultHandler)dh);
            }
            catch (RuntimeException e) {
                if (SCHEMA_VALIDATION) {
                    throw e;
                }
                throw new UnsupportedFormatException(e);
            }
            catch (ParsingCancelledException e) {
                return null;
            }
        }
        catch (SaxUnsupportedFileVersionException e) {
            throw new UnsupportedFileVersionException(Integer.toString(e.getVersion()));
        }
        catch (SAXParseException e) {
            throw new UnsupportedFormatException(e);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        return dh.getData();
    }

    public void serialize(GlobalData data, ProgressReport report) throws IOException {
        try {
            int i;
            this.atts.clear();
            this.atts.addAttribute(EMPTY, EMPTY, VERSION_ATTRIBUTE, CDATA, Integer.toString(1));
            this.atts.addAttribute(EMPTY, EMPTY, "nbAccounts", CDATA, Integer.toString(data.getAccountsNumber()));
            this.atts.addAttribute(EMPTY, EMPTY, "nbCategories", CDATA, Integer.toString(data.getCategoriesNumber()));
            this.atts.addAttribute(EMPTY, EMPTY, SUBCATEGORY_SEPARATOR_ATTRIBUTE, CDATA, Character.toString(data.getSubCategorySeparator()));
            this.atts.addAttribute(EMPTY, EMPTY, "nbPeriodicalTransactions", CDATA, Integer.toString(data.getPeriodicalTransactionsNumber()));
            this.atts.addAttribute(EMPTY, EMPTY, NB_TRANSACTIONS_ATTRIBUTE, CDATA, Integer.toString(data.getTransactionsNumber()));
            if (data.isLocked()) {
                this.atts.addAttribute(EMPTY, EMPTY, LOCKED_ATTRIBUTE, CDATA, Boolean.toString(true));
            }
            if (data.isArchive()) {
                this.atts.addAttribute(EMPTY, EMPTY, ARCHIVE_ATTRIBUTE, CDATA, Boolean.toString(true));
            }
            this.hd.startElement(EMPTY, EMPTY, GLOBAL_DATA_TAG, this.atts);
            for (i = 0; i < data.getAccountsNumber(); ++i) {
                this.serialize(data.getAccount(i));
            }
            for (i = 0; i < data.getCategoriesNumber(); ++i) {
                this.serialize(data.getCategory(i));
            }
            for (i = 0; i < data.getFiltersNumber(); ++i) {
                this.serialize(data.getFilter(i));
            }
            for (i = 0; i < data.getPeriodicalTransactionsNumber(); ++i) {
                this.serialize(data.getPeriodicalTransaction(i));
            }
            if (report != null) {
                report.setMax(data.getTransactionsNumber());
            }
            for (i = 0; i < data.getTransactionsNumber(); ++i) {
                if (SLOW_WRITING) {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                this.serialize(data.getTransaction(i));
                if (report == null) continue;
                report.reportProgress(i + 1);
            }
            this.hd.endElement(EMPTY, EMPTY, GLOBAL_DATA_TAG);
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
    }

    public void serialize(Filter filter) throws SAXException {
        List<Category> categories;
        List<String> modes;
        List<Account> accounts;
        this.atts.clear();
        if (filter.getName() != null) {
            this.atts.addAttribute(EMPTY, EMPTY, ID_ATTRIBUTE, CDATA, filter.getName());
        }
        if (filter.getDateFrom() != null) {
            this.atts.addAttribute(EMPTY, EMPTY, FILTER_DATE_FROM_ATTRIBUTE, CDATA, this.toString(filter.getDateFrom()));
        }
        if (filter.getDateTo() != null) {
            this.atts.addAttribute(EMPTY, EMPTY, FILTER_DATE_TO_ATTRIBUTE, CDATA, this.toString(filter.getDateTo()));
        }
        if (filter.getValueDateTo() != null) {
            this.atts.addAttribute(EMPTY, EMPTY, FILTER_VALUE_DATE_TO_ATTRIBUTE, CDATA, this.toString(filter.getValueDateTo()));
        }
        if (filter.getValueDateFrom() != null) {
            this.atts.addAttribute(EMPTY, EMPTY, FILTER_VALUE_DATE_FROM_ATTRIBUTE, CDATA, this.toString(filter.getValueDateFrom()));
        }
        if (filter.getMinAmount() != 0.0) {
            this.atts.addAttribute(EMPTY, EMPTY, FILTER_AMOUNT_FROM_ATTRIBUTE, CDATA, Double.toString(filter.getMinAmount()));
        }
        if (filter.getMaxAmount() != Double.POSITIVE_INFINITY) {
            this.atts.addAttribute(EMPTY, EMPTY, FILTER_AMOUNT_TO_ATTRIBUTE, CDATA, Double.toString(filter.getMaxAmount()));
        }
        if ((accounts = filter.getValidAccounts()) != null) {
            String[] strings = new String[accounts.size()];
            for (int i = 0; i < strings.length; ++i) {
                strings[i] = accounts.get(i).getName();
            }
            this.atts.addAttribute(EMPTY, EMPTY, ACCOUNT_ATTRIBUTE, CDATA, ArrayUtils.toString(strings));
        }
        if ((modes = filter.getValidModes()) != null) {
            this.atts.addAttribute(EMPTY, EMPTY, MODE_ATTRIBUTE, CDATA, ArrayUtils.toString(modes.toArray(new String[modes.size()])));
        }
        if ((categories = filter.getValidCategories()) != null) {
            String[] strings = new String[categories.size()];
            for (int i = 0; i < strings.length; ++i) {
                strings[i] = categories.get(i).equals(Category.UNDEFINED) ? EMPTY : categories.get(i).getName();
            }
            this.atts.addAttribute(EMPTY, EMPTY, CATEGORY_ATTRIBUTE, CDATA, ArrayUtils.toString(strings));
        }
        int mask = 0;
        if (filter.isOk(8)) {
            mask += 8;
        }
        if (filter.isOk(4)) {
            mask += 4;
        }
        if (filter.isOk(1)) {
            ++mask;
        }
        if (filter.isOk(2)) {
            mask += 2;
        }
        if (mask != 15) {
            this.atts.addAttribute(EMPTY, EMPTY, FILTER_ATTRIBUTE, CDATA, Integer.toString(mask));
        }
        this.hd.startElement(EMPTY, EMPTY, FILTER_TAG, this.atts);
        if (filter.getDescriptionMatcher() != null) {
            this.serialize(filter.getDescriptionMatcher(), "description");
        }
        if (filter.getCommentMatcher() != null) {
            this.serialize(filter.getCommentMatcher(), "comment");
        }
        if (filter.getNumberMatcher() != null) {
            this.serialize(filter.getNumberMatcher(), "number");
        }
        if (filter.getStatementMatcher() != null) {
            this.serialize(filter.getStatementMatcher(), "statement");
        }
        this.hd.endElement(EMPTY, EMPTY, FILTER_TAG);
    }

    private void serialize(TextMatcher matcher, String id) throws SAXException {
        this.atts.clear();
        this.atts.addAttribute(EMPTY, EMPTY, ID_ATTRIBUTE, CDATA, id);
        String kind = null;
        if (matcher.getKind().equals((Object)TextMatcher.Kind.CONTAINS)) {
            kind = CONTAINS;
        } else if (matcher.getKind().equals((Object)TextMatcher.Kind.EQUALS)) {
            kind = EQUALS;
        } else if (matcher.getKind().equals((Object)TextMatcher.Kind.REGULAR)) {
            kind = REGULAR;
        } else {
            throw new IllegalArgumentException();
        }
        this.atts.addAttribute(EMPTY, EMPTY, KIND_ATTRIBUTE, CDATA, kind);
        this.atts.addAttribute(EMPTY, EMPTY, FILTER_ATTRIBUTE, CDATA, XMLSerializer.encode(matcher.getFilter()));
        if (matcher.isCaseSensitive()) {
            this.atts.addAttribute(EMPTY, EMPTY, CASE_SENSITIVE_ATTRIBUTE, CDATA, TRUE);
        }
        if (matcher.isDiacriticalSensitive()) {
            this.atts.addAttribute(EMPTY, EMPTY, DIACRITICAL_SENSITIVE_ATTRIBUTE, CDATA, TRUE);
        }
        this.hd.startElement(EMPTY, EMPTY, TEXT_MATCHER_TAG, this.atts);
        this.hd.endElement(EMPTY, EMPTY, TEXT_MATCHER_TAG);
    }

    static String encode(String string) {
        if (string == null) {
            return string;
        }
        try {
            return URLEncoder.encode(string, UTF8);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    static String decode(String string) {
        if (string == null) {
            return string;
        }
        try {
            return URLDecoder.decode(string, UTF8);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private void serialize(Account account) throws SAXException {
        int i;
        this.atts.clear();
        this.atts.addAttribute(EMPTY, EMPTY, ID_ATTRIBUTE, CDATA, account.getName());
        this.atts.addAttribute(EMPTY, EMPTY, INITIAL_BALANCE_ATTRIBUTE, CDATA, Double.toString(account.getInitialBalance()));
        AlertThreshold alertThreshold = account.getAlertThreshold();
        if (!alertThreshold.equals(AlertThreshold.DEFAULT)) {
            this.atts.addAttribute(EMPTY, EMPTY, ALERT_THRESHOLD_LESS, CDATA, Double.toString(alertThreshold.getLessThreshold()));
            this.atts.addAttribute(EMPTY, EMPTY, ALERT_THRESHOLD_MORE, CDATA, Double.toString(alertThreshold.getMoreThreshold()));
        }
        this.hd.startElement(EMPTY, EMPTY, ACCOUNT_TAG, this.atts);
        String comment = account.getComment();
        if (comment != null) {
            this.hd.startCDATA();
            this.hd.characters(comment.toCharArray(), 0, comment.length());
            this.hd.endCDATA();
        }
        for (i = 0; i < account.getModesNumber(); ++i) {
            Mode mode = account.getMode(i);
            if (mode.equals(Mode.UNDEFINED)) continue;
            this.serialize(mode);
        }
        for (i = 0; i < account.getCheckbooksNumber(); ++i) {
            this.serialize(account.getCheckbook(i));
        }
        this.hd.endElement(EMPTY, EMPTY, ACCOUNT_TAG);
    }

    private void serialize(Mode mode) throws SAXException {
        DateStepper receipt;
        if (mode.equals(Mode.UNDEFINED)) {
            throw new IllegalArgumentException();
        }
        this.atts.clear();
        this.atts.addAttribute(EMPTY, EMPTY, ID_ATTRIBUTE, CDATA, mode.getName());
        if (mode.isUseCheckBook()) {
            this.atts.addAttribute(EMPTY, EMPTY, CHECKBOOK_ATTRIBUTE, CDATA, TRUE);
        }
        this.hd.startElement(EMPTY, EMPTY, MODE_TAG, this.atts);
        DateStepper expense = mode.getExpenseVdc();
        if (expense != null) {
            this.setAttributes(expense);
            this.hd.startElement(EMPTY, EMPTY, EXPENSE_VDC_TAG, this.atts);
            this.hd.endElement(EMPTY, EMPTY, EXPENSE_VDC_TAG);
        }
        if ((receipt = mode.getReceiptVdc()) != null) {
            this.setAttributes(receipt);
            this.hd.startElement(EMPTY, EMPTY, RECEIPT_VDC_TAG, this.atts);
            this.hd.endElement(EMPTY, EMPTY, RECEIPT_VDC_TAG);
        }
        this.hd.endElement(EMPTY, EMPTY, MODE_TAG);
    }

    private void serialize(Checkbook book) throws SAXException {
        this.atts.clear();
        this.atts.addAttribute(EMPTY, EMPTY, PREFIX_ATTRIBUTE, CDATA, book.getPrefix());
        this.atts.addAttribute(EMPTY, EMPTY, FIRST_NUMBER_ATTRIBUTE, CDATA, book.getFirst().toString());
        this.atts.addAttribute(EMPTY, EMPTY, SIZE_ATTRIBUTE, CDATA, Integer.toString(book.size()));
        if (!book.isEmpty()) {
            this.atts.addAttribute(EMPTY, EMPTY, "next", CDATA, book.getFirst().add(BigInteger.valueOf(book.getUsed())).toString());
        }
        this.hd.startElement(EMPTY, EMPTY, CHECKBOOK_TAG, this.atts);
        this.hd.endElement(EMPTY, EMPTY, CHECKBOOK_TAG);
    }

    private void setAttributes(DateStepper dateStepper) {
        String kind;
        this.atts.clear();
        if (dateStepper instanceof DayDateStepper) {
            kind = RELATIVE_DATE_STEPPER_KIND;
            this.atts.addAttribute(EMPTY, EMPTY, PERIOD_ATTRIBUTE, CDATA, Integer.toString(((DayDateStepper)dateStepper).getStep()));
        } else if (dateStepper instanceof DeferredValueDateComputer) {
            kind = DEFERRED_DATE_STEPPER_KIND;
            this.atts.addAttribute(EMPTY, EMPTY, STOP_DAY_ATTRIBUTE, CDATA, Integer.toString(((DeferredValueDateComputer)dateStepper).getStopDay()));
            this.atts.addAttribute(EMPTY, EMPTY, DEBT_DAY_ATTRIBUTE, CDATA, Integer.toString(((DeferredValueDateComputer)dateStepper).getDebtDay()));
        } else if (dateStepper.equals(DateStepper.IMMEDIATE)) {
            kind = IMMEDIATE_DATE_STEPPER_KIND;
        } else {
            throw new RuntimeException("Unsupported ValueDateComputer class : " + dateStepper.getClass().getName());
        }
        this.atts.addAttribute(EMPTY, EMPTY, KIND_ATTRIBUTE, CDATA, kind);
    }

    private void serialize(Category category) throws SAXException {
        if (!category.equals(Category.UNDEFINED)) {
            this.atts.clear();
            this.atts.addAttribute(EMPTY, EMPTY, ID_ATTRIBUTE, CDATA, category.getName());
            this.hd.startElement(EMPTY, EMPTY, CATEGORY_TAG, this.atts);
            this.hd.endElement(EMPTY, EMPTY, CATEGORY_TAG);
        }
    }

    private void serialize(Transaction transaction) throws SAXException {
        Category category;
        String number;
        String comment;
        this.atts.clear();
        this.atts.addAttribute(EMPTY, EMPTY, ACCOUNT_ATTRIBUTE, CDATA, transaction.getAccount().getName());
        String description = transaction.getDescription();
        if (description != null) {
            this.atts.addAttribute(EMPTY, EMPTY, "description", CDATA, description);
        }
        if ((comment = transaction.getComment()) != null) {
            this.atts.addAttribute(EMPTY, EMPTY, "comment", CDATA, comment);
        }
        this.atts.addAttribute(EMPTY, EMPTY, DATE_ATTRIBUTE, CDATA, this.toString(transaction.getDate()));
        this.atts.addAttribute(EMPTY, EMPTY, AMOUNT_ATTRIBUTE, CDATA, Double.toString(transaction.getAmount()));
        Mode mode = transaction.getMode();
        if (!mode.equals(Mode.UNDEFINED)) {
            this.atts.addAttribute(EMPTY, EMPTY, MODE_ATTRIBUTE, CDATA, mode.getName());
        }
        if ((number = transaction.getNumber()) != null && number.length() > 0) {
            this.atts.addAttribute(EMPTY, EMPTY, "number", CDATA, number);
        }
        if (!(category = transaction.getCategory()).equals(Category.UNDEFINED)) {
            this.atts.addAttribute(EMPTY, EMPTY, CATEGORY_ATTRIBUTE, CDATA, category.getName());
        }
        this.atts.addAttribute(EMPTY, EMPTY, VALUE_DATE_ATTRIBUTE, CDATA, this.toString(transaction.getValueDate()));
        String statement = transaction.getStatement();
        if (statement != null) {
            this.atts.addAttribute(EMPTY, EMPTY, "statement", CDATA, statement);
        }
        this.hd.startElement(EMPTY, EMPTY, TRANSACTION_TAG, this.atts);
        for (int i = 0; i < transaction.getSubTransactionSize(); ++i) {
            this.serialize(transaction.getSubTransaction(i));
        }
        this.hd.endElement(EMPTY, EMPTY, TRANSACTION_TAG);
    }

    private void serialize(SubTransaction subTransaction) throws SAXException {
        this.atts.clear();
        this.atts.addAttribute(EMPTY, EMPTY, "description", CDATA, subTransaction.getDescription());
        this.atts.addAttribute(EMPTY, EMPTY, AMOUNT_ATTRIBUTE, CDATA, Double.toString(subTransaction.getAmount()));
        Category category = subTransaction.getCategory();
        if (!category.equals(Category.UNDEFINED)) {
            this.atts.addAttribute(EMPTY, EMPTY, CATEGORY_ATTRIBUTE, CDATA, category.getName());
        }
        this.hd.startElement(EMPTY, EMPTY, SUBTRANSACTION_TAG, this.atts);
        this.hd.endElement(EMPTY, EMPTY, SUBTRANSACTION_TAG);
    }

    private void serialize(PeriodicalTransaction periodicalTransaction) throws SAXException {
        Category category;
        String comment;
        this.atts.clear();
        this.atts.addAttribute(EMPTY, EMPTY, ACCOUNT_ATTRIBUTE, CDATA, periodicalTransaction.getAccount().getName());
        String description = periodicalTransaction.getDescription();
        if (description != null) {
            this.atts.addAttribute(EMPTY, EMPTY, "description", CDATA, description);
        }
        if ((comment = periodicalTransaction.getComment()) != null) {
            this.atts.addAttribute(EMPTY, EMPTY, "comment", CDATA, comment);
        }
        this.atts.addAttribute(EMPTY, EMPTY, AMOUNT_ATTRIBUTE, CDATA, Double.toString(periodicalTransaction.getAmount()));
        Mode mode = periodicalTransaction.getMode();
        if (!mode.equals(Mode.UNDEFINED)) {
            this.atts.addAttribute(EMPTY, EMPTY, MODE_ATTRIBUTE, CDATA, mode.getName());
        }
        if (!(category = periodicalTransaction.getCategory()).equals(Category.UNDEFINED)) {
            this.atts.addAttribute(EMPTY, EMPTY, CATEGORY_ATTRIBUTE, CDATA, category.getName());
        }
        this.atts.addAttribute(EMPTY, EMPTY, ENABLED_ATTRIBUTE, CDATA, Boolean.toString(periodicalTransaction.isEnabled()));
        Date nextDate = periodicalTransaction.getNextDate();
        if (nextDate != null) {
            this.atts.addAttribute(EMPTY, EMPTY, "next", CDATA, this.toString(nextDate));
        }
        this.hd.startElement(EMPTY, EMPTY, PERIODICAL_TAG, this.atts);
        DateStepper nextDateBuilder = periodicalTransaction.getNextDateBuilder();
        if (nextDateBuilder != null) {
            this.serialize(nextDateBuilder);
        }
        for (int i = 0; i < periodicalTransaction.getSubTransactionSize(); ++i) {
            this.serialize(periodicalTransaction.getSubTransaction(i));
        }
        this.hd.endElement(EMPTY, EMPTY, PERIODICAL_TAG);
    }

    private void serialize(DateStepper stepper) throws SAXException {
        if (stepper instanceof MonthDateStepper) {
            MonthDateStepper mds = (MonthDateStepper)stepper;
            this.atts.clear();
            this.atts.addAttribute(EMPTY, EMPTY, KIND_ATTRIBUTE, CDATA, MONTHLY_DATE_STEPPER_KIND);
            this.atts.addAttribute(EMPTY, EMPTY, PERIOD_ATTRIBUTE, CDATA, Integer.toString(mds.getPeriod()));
            this.atts.addAttribute(EMPTY, EMPTY, DAY_ATTRIBUTE, CDATA, Integer.toString(mds.getDay()));
            Date last = mds.getLastDate();
            if (last != null) {
                this.atts.addAttribute(EMPTY, EMPTY, LAST_DATE_ATTRIBUTE, CDATA, this.toString(last));
            }
            this.hd.startElement(EMPTY, EMPTY, DATE_STEPPER_TAG, this.atts);
            this.hd.endElement(EMPTY, EMPTY, DATE_STEPPER_TAG);
        } else if (stepper instanceof DayDateStepper) {
            DayDateStepper dds = (DayDateStepper)stepper;
            this.atts.addAttribute(EMPTY, EMPTY, KIND_ATTRIBUTE, CDATA, RELATIVE_DATE_STEPPER_KIND);
            this.atts.addAttribute(EMPTY, EMPTY, PERIOD_ATTRIBUTE, CDATA, Integer.toString(dds.getStep()));
            Date last = dds.getLastDate();
            if (last != null) {
                this.atts.addAttribute(EMPTY, EMPTY, LAST_DATE_ATTRIBUTE, CDATA, this.toString(last));
            }
            this.hd.startElement(EMPTY, EMPTY, DATE_STEPPER_TAG, this.atts);
            this.hd.endElement(EMPTY, EMPTY, DATE_STEPPER_TAG);
            this.atts.clear();
        } else {
            throw new IllegalArgumentException("This stepper class is not supported : " + stepper.getClass());
        }
    }

    private String toString(Date date) {
        int month = date.getMonth() + 1;
        int year = date.getYear() + 1900;
        return year + DATE_DELIM + month + DATE_DELIM + date.getDate();
    }

    static int toDate(String value) {
        if (value == null) {
            return -1;
        }
        StringTokenizer tokens = new StringTokenizer(value, DATE_DELIM);
        int year = Integer.parseInt(tokens.nextToken());
        int month = Integer.parseInt(tokens.nextToken());
        int day = Integer.parseInt(tokens.nextToken());
        return DateUtils.dateToInteger(year, month, day);
    }
}

