/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.data.xml;

import com.fathzer.soft.ajlib.utilities.FileUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.security.AccessControlException;
import java.text.MessageFormat;
import java.util.zip.ZipOutputStream;
import net.yapbam.data.GlobalData;
import net.yapbam.data.ProgressReport;
import net.yapbam.data.xml.Serializer;

public class YapbamSerializer {
    private static final String XML_EXTENSION = ".xml";
    private static final String ZIP_EXTENSION = ".zip";
    private static final String CLASSPATH_SCHEME = "classpath";

    private YapbamSerializer() {
    }

    public static void write(GlobalData data, File file, boolean zipped, ProgressReport report) throws IOException {
        File backupFile;
        if (!FileUtils.isWritable(file)) {
            throw new FileNotFoundException(MessageFormat.format("Writing to {0} is not allowed", file));
        }
        File file2 = backupFile = file.exists() && file.isFile() ? YapbamSerializer.getBackupFile(file) : null;
        if (backupFile != null) {
            FileUtils.copy(file, backupFile, true);
        }
        YapbamSerializer.doWrite(data, file, zipped, report);
        if (report != null) {
            report.setMax(-1);
        }
        if (backupFile != null && !backupFile.delete()) {
            FileOutputStream out = new FileOutputStream(backupFile);
            ((OutputStream)out).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doWrite(GlobalData data, File file, boolean zipped, ProgressReport report) throws IOException {
        OutputStream out = new FileOutputStream(file);
        try {
            if (zipped) {
                out = new ZipOutputStream(out);
                new Serializer().writeToZip(data, (ZipOutputStream)out, YapbamSerializer.getEntryName(file.getName()), report);
            } else {
                new Serializer().write(data, out, report);
            }
            out.flush();
        }
        finally {
            out.close();
        }
    }

    private static File getBackupFile(File file) {
        File parent = file.getParentFile();
        String root = FileUtils.getRootName(file);
        String extension = FileUtils.getExtension(file);
        if (extension == null) {
            extension = "";
        }
        int index = 1;
        File candidate;
        while ((candidate = new File(parent, root + "_backup" + index + extension)).exists() && candidate.length() != 0L) {
            ++index;
        }
        return candidate;
    }

    private static String getEntryName(String fileName) {
        String lowerCase = fileName.toLowerCase();
        if (lowerCase.endsWith(ZIP_EXTENSION)) {
            fileName = fileName.substring(0, fileName.length() - ZIP_EXTENSION.length());
            lowerCase = lowerCase.substring(0, lowerCase.length() - ZIP_EXTENSION.length());
        }
        return lowerCase.endsWith(XML_EXTENSION) ? fileName : fileName + XML_EXTENSION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GlobalData read(URI uri, String password, ProgressReport report) throws IOException, AccessControlException {
        InputStream in = YapbamSerializer.getStream(uri);
        try {
            GlobalData redData = new Serializer().read(password, in, report);
            if (redData != null) {
                redData.setURI(uri);
                redData.setChanged(false);
            }
            GlobalData globalData = redData;
            return globalData;
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isPasswordOk(URI uri, String password) throws IOException {
        InputStream global = YapbamSerializer.getStream(uri);
        try {
            boolean bl = new Serializer().isPasswordOk(global, password);
            return bl;
        }
        finally {
            global.close();
        }
    }

    private static InputStream getStream(URI uri) throws IOException {
        String scheme = uri.getScheme();
        if ("file".equals(scheme) || "ftp".equals(scheme)) {
            return uri.toURL().openStream();
        }
        if (CLASSPATH_SCHEME.equals(scheme)) {
            String resourcePath = uri.toString().substring(CLASSPATH_SCHEME.length() + 1);
            return YapbamSerializer.class.getResourceAsStream(resourcePath);
        }
        throw new IOException("Unsupported protocol: " + scheme);
    }
}

