/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.date.helpers;

import java.util.Date;
import java.util.GregorianCalendar;
import net.yapbam.date.helpers.DateStepper;

public class DeferredValueDateComputer
extends DateStepper {
    private int stopDay;
    private int debtDay;

    public DeferredValueDateComputer(int stopDay, int debtDay) {
        this.stopDay = stopDay;
        this.debtDay = debtDay;
    }

    public int getStopDay() {
        return this.stopDay;
    }

    public int getDebtDay() {
        return this.debtDay;
    }

    @Override
    public Date getNextStep(Date date) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(date);
        int day = gc.get(5);
        int month = gc.get(2);
        int year = gc.get(1);
        if (day > this.stopDay && ++month > gc.getActualMaximum(2)) {
            ++year;
            month = 0;
        }
        if (this.stopDay > this.debtDay && ++month > gc.getActualMaximum(2)) {
            ++year;
            month = 0;
        }
        gc.set(year, month, 1);
        gc.add(2, 1);
        gc.add(5, -1);
        if (this.debtDay < gc.get(5)) {
            gc.set(5, this.debtDay);
        }
        return gc.getTime();
    }

    @Override
    public Date getLastDate() {
        return null;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof DeferredValueDateComputer)) {
            return false;
        }
        return this.getStopDay() == ((DeferredValueDateComputer)obj).getStopDay() && this.getDebtDay() == ((DeferredValueDateComputer)obj).getDebtDay();
    }

    public int hashCode() {
        return this.getDebtDay() * 100 + this.getStopDay();
    }
}

