/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui;

import com.fathzer.soft.ajlib.swing.Utils;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;

public abstract class IconManager {
    private static Map<Name, Icon> map;
    private static int currentSize;

    public static Icon get(Name name) {
        return map.get((Object)name);
    }

    public static void reset(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException();
        }
        if (size == currentSize) {
            return;
        }
        if (map == null) {
            map = new HashMap<Name, Icon>();
        }
        map.clear();
        map.put(Name.OPEN, IconManager.create("images/open.png", size));
        map.put(Name.CLOSE, IconManager.create("images/close.png", size));
        map.put(Name.SAVE, IconManager.create("images/save.png", size));
        map.put(Name.SAVE_AS, IconManager.create("images/saveAs.png", size));
        map.put(Name.NEW, IconManager.create("images/new.png", size));
        map.put(Name.DELETE, IconManager.create("images/delete.png", size));
        map.put(Name.EDIT, IconManager.create("images/edit.png", size));
        map.put(Name.DUPLICATE, IconManager.create("images/duplicate.png", size));
        map.put(Name.NEW_FILE, map.get((Object)Name.NEW));
        map.put(Name.NEW_ACCOUNT, map.get((Object)Name.NEW));
        map.put(Name.EDIT_ACCOUNT, map.get((Object)Name.EDIT));
        map.put(Name.DELETE_ACCOUNT, map.get((Object)Name.DELETE));
        map.put(Name.NEW_TRANSACTION, map.get((Object)Name.NEW));
        map.put(Name.DELETE_TRANSACTION, map.get((Object)Name.DELETE));
        map.put(Name.EDIT_TRANSACTION, map.get((Object)Name.EDIT));
        map.put(Name.DUPLICATE_TRANSACTION, map.get((Object)Name.DUPLICATE));
        map.put(Name.NEW_BULK_TRANSACTION, IconManager.create("images/bulk.png", size));
        map.put(Name.NEW_MODE, map.get((Object)Name.NEW));
        map.put(Name.DELETE_MODE, map.get((Object)Name.DELETE));
        map.put(Name.EDIT_MODE, map.get((Object)Name.EDIT));
        map.put(Name.DUPLICATE_MODE, map.get((Object)Name.DUPLICATE));
        map.put(Name.NEW_CATEGORY, map.get((Object)Name.NEW));
        map.put(Name.DELETE_CATEGORY, map.get((Object)Name.DELETE));
        map.put(Name.CHECK_TRANSACTION, IconManager.create("images/check.png", size));
        map.put(Name.UNCHECK_TRANSACTION, IconManager.create("images/uncheck.png", size));
        map.put(Name.SPREAD, IconManager.create("images/spread.png", size));
        map.put(Name.SPREAD_UP, IconManager.create("images/spreadUp.png", size));
        map.put(Name.SPREADABLE, IconManager.create("images/spreadable.png", size));
        map.put(Name.FIRST, IconManager.create("/com/fathzer/soft/ajlib/swing/widget/first.png", size));
        map.put(Name.PREVIOUS, IconManager.create("/com/fathzer/soft/ajlib/swing/widget/previous.png", size));
        map.put(Name.NEXT, IconManager.create("/com/fathzer/soft/ajlib/swing/widget/next.png", size));
        map.put(Name.LAST, IconManager.create("/com/fathzer/soft/ajlib/swing/widget/last.png", size));
        map.put(Name.UP, IconManager.create("images/up.png", size));
        map.put(Name.DOWN, IconManager.create("images/down.png", size));
        map.put(Name.TOP, IconManager.create("images/top.png", size));
        map.put(Name.BOTTOM, IconManager.create("images/bottom.png", size));
        map.put(Name.IMPORT, IconManager.create("images/import.png", size));
        map.put(Name.EXPORT, IconManager.create("images/export.png", size));
        map.put(Name.ARCHIVE, IconManager.create("images/archive.png", size));
        map.put(Name.ALERT, IconManager.create("images/alert.png", size));
        map.put(Name.NEW_MESSAGE, IconManager.create("images/newMessage.png", size));
        map.put(Name.MESSAGE, IconManager.create("images/message.png", size));
        map.put(Name.LOCK, IconManager.create("images/locked.png", size));
        map.put(Name.HELP, IconManager.create("images/help.png", size));
        map.put(Name.PRINT, IconManager.create("images/print.png", size));
        map.put(Name.DEPLOY, IconManager.get(Name.SPREADABLE));
        map.put(Name.UNDEPLOY, IconManager.create("images/undeploy.png", size));
        map.put(Name.SETTINGS, IconManager.create("images/settings.png", size));
        map.put(Name.LINK, IconManager.create("images/link.png", size));
        currentSize = size;
    }

    private static Icon create(String path, int size) {
        return Utils.createIcon(IconManager.class.getResource(path), size);
    }

    static {
        IconManager.reset(16);
        currentSize = -1;
    }

    public static enum Name {
        OPEN,
        CLOSE,
        SAVE,
        SAVE_AS,
        NEW,
        DELETE,
        EDIT,
        DUPLICATE,
        NEW_FILE,
        NEW_ACCOUNT,
        EDIT_ACCOUNT,
        DELETE_ACCOUNT,
        NEW_TRANSACTION,
        DELETE_TRANSACTION,
        EDIT_TRANSACTION,
        DUPLICATE_TRANSACTION,
        NEW_BULK_TRANSACTION,
        CHECK_TRANSACTION,
        UNCHECK_TRANSACTION,
        NEW_MODE,
        EDIT_MODE,
        DELETE_MODE,
        DUPLICATE_MODE,
        NEW_CATEGORY,
        DELETE_CATEGORY,
        SPREAD,
        SPREADABLE,
        SPREAD_UP,
        FIRST,
        PREVIOUS,
        NEXT,
        LAST,
        UP,
        DOWN,
        TOP,
        BOTTOM,
        DEPLOY,
        UNDEPLOY,
        IMPORT,
        EXPORT,
        ARCHIVE,
        LOCK,
        ALERT,
        NEW_MESSAGE,
        MESSAGE,
        HELP,
        PRINT,
        SETTINGS,
        LINK;

    }
}

