/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui;

import com.fathzer.jlocal.Formatter;
import com.fathzer.soft.ajlib.swing.FontUtils;
import com.fathzer.soft.ajlib.swing.Utils;
import com.fathzer.soft.ajlib.utilities.NullUtils;
import com.fathzer.soft.jclop.Service;
import java.awt.AWTEvent;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import net.yapbam.data.Account;
import net.yapbam.data.Filter;
import net.yapbam.data.FilteredData;
import net.yapbam.data.GlobalData;
import net.yapbam.data.event.DataEvent;
import net.yapbam.data.event.DataListener;
import net.yapbam.data.event.EverythingChangedEvent;
import net.yapbam.data.event.NeedToBeSavedChangedEvent;
import net.yapbam.data.event.URIChangedEvent;
import net.yapbam.data.xml.UnsupportedFileVersionException;
import net.yapbam.data.xml.UnsupportedFormatException;
import net.yapbam.gui.AbstractPlugIn;
import net.yapbam.gui.ErrorManager;
import net.yapbam.gui.FolderCleaner;
import net.yapbam.gui.GlobalPanel;
import net.yapbam.gui.IconManager;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.MainMenuBar;
import net.yapbam.gui.MainPanel;
import net.yapbam.gui.PlugInContainer;
import net.yapbam.gui.Preferences;
import net.yapbam.gui.TransactionSelector;
import net.yapbam.gui.YapbamInstance;
import net.yapbam.gui.YapbamState;
import net.yapbam.gui.actions.CheckNewReleaseAction;
import net.yapbam.gui.dialogs.BasicHTMLDialog;
import net.yapbam.gui.info.MessagesBuilder;
import net.yapbam.gui.persistence.PersistenceManager;
import net.yapbam.gui.persistence.UnsupportedSchemeException;
import net.yapbam.gui.persistence.YapbamDataWrapper;
import net.yapbam.gui.persistence.YapbamPersistenceManager;
import net.yapbam.gui.welcome.WelcomeDialog;
import net.yapbam.update.ReleaseInfo;
import net.yapbam.util.ApplicationContext;
import net.yapbam.util.HtmlUtils;

public class MainFrame
extends JFrame
implements YapbamInstance {
    private static final long serialVersionUID = 1L;
    private static final String LAST_URI = "data.uri";
    private static final String FRAME_SIZE_WIDTH = "frame.size.width";
    private static final String FRAME_SIZE_HEIGHT = "frame.size.height";
    private static final String FRAME_LOCATION_Y = "frame.location.y";
    private static final String FRAME_LOCATION_X = "frame.location.x";
    private static final String LAST_VERSION_USED = "lastVersionUsed";
    private static final String LAST_FILTER_USED = "filter";
    private GlobalData data;
    private FilteredData filteredData;
    MainMenuBar mainMenu;
    private AbstractPlugIn[] plugins;
    private boolean isRestarting = false;
    public static File updater = null;

    public JFrame getJFrame() {
        return this;
    }

    public static void main(final String[] args) {
        if (!MainFrame.isJava6()) {
            System.setProperty("java.util.Arrays.useLegacyMergeSort", "true");
            if (!MainFrame.isJava7()) {
                System.setProperty("jdk.http.auth.tunneling.disabledSchemes", "");
            }
        }
        FolderCleaner.clean();
        MainFrame.setLookAndFeel();
        if (MainFrame.isJava6()) {
            MainFrame.installEventQueue();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        MainFrame.installEventQueue();
                    }
                });
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getCause());
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String importantNews;
                MainFrame frame = new MainFrame(null, null);
                frame.initData(args.length == 0 ? null : args[0]);
                CheckNewReleaseAction.doAutoCheck(frame.getJFrame());
                if (Preferences.INSTANCE.isWelcomeAllowed()) {
                    new WelcomeDialog((Window)frame.getJFrame(), frame.getData()).setVisible(true);
                }
                if (!Preferences.INSTANCE.isFirstRun() && (importantNews = MainFrame.buildNews()).length() > 0) {
                    BasicHTMLDialog dialog = new BasicHTMLDialog((Window)frame.getJFrame(), LocalizationData.get("ImportantNews.title"), LocalizationData.get("ImportantNews.intro"), BasicHTMLDialog.Type.INFO);
                    dialog.setContent(importantNews);
                    dialog.setVisible(true);
                }
            }
        });
    }

    private static boolean isJava6() {
        return "1.6".equals(System.getProperty("java.specification.version"));
    }

    private static boolean isJava7() {
        return "1.7".equals(System.getProperty("java.specification.version"));
    }

    private static void installEventQueue() {
        EventQueue queue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        queue.push(new EventQueue(){

            @Override
            protected void dispatchEvent(AWTEvent event) {
                try {
                    super.dispatchEvent(event);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    ErrorManager.INSTANCE.log(null, t);
                    Window[] windows = Window.getWindows();
                    for (int i = 0; i < windows.length; ++i) {
                        if (!(windows[i] instanceof MainFrame) || windows[i].isVisible()) continue;
                        windows[i].dispatchEvent(new WindowEvent(windows[i], 201));
                    }
                }
            }
        });
    }

    private static String buildNews() {
        String message;
        StringBuilder buf = new StringBuilder();
        ReleaseInfo lastVersion = (ReleaseInfo)YapbamState.INSTANCE.restore(LAST_VERSION_USED);
        if (NullUtils.compareTo(lastVersion, new ReleaseInfo("0.8.2 (10/04/2011)"), true) <= 0) {
            message = Formatter.format(HtmlUtils.removeHtmlTags(LocalizationData.get("ImportantNews.0.8.2")), LocalizationData.get("CheckModePanel.title"), LocalizationData.get("MainFrame.Transactions"), LocalizationData.get("StatementView.title"), LocalizationData.get("StatementView.notChecked"));
            buf.append(message);
        }
        if (NullUtils.compareTo(lastVersion, new ReleaseInfo("0.14.5 (24/03/2013)"), true) <= 0) {
            if (buf.length() > 0) {
                buf.append("<br><br><hr><br>");
            }
            message = Formatter.format(HtmlUtils.removeHtmlTags(LocalizationData.get("ImportantNews.0.14.5")), LocalizationData.get("CheckModePanel.title"), LocalizationData.get("MainFrame.Transactions"), LocalizationData.get("StatementView.title"), LocalizationData.get("StatementView.notChecked"));
            buf.append(message);
        }
        return buf.toString();
    }

    private MainFrame(FilteredData filteredData, Object[] restartData) {
        this.getJFrame().setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("yapbam_16.png")));
        this.getJFrame().setDefaultCloseOperation(0);
        this.getJFrame().addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                if (MainFrame.this.isRestarting) {
                    MainFrame.this.saveState();
                    super.windowClosing(event);
                    event.getWindow().dispose();
                } else if (YapbamPersistenceManager.MANAGER.verify(MainFrame.this.getJFrame(), new YapbamDataWrapper(MainFrame.this.getData()))) {
                    MainFrame.this.saveState();
                    try {
                        Preferences.INSTANCE.save();
                    }
                    catch (IOException e) {
                        JOptionPane.showMessageDialog(event.getWindow(), Formatter.format(LocalizationData.get("MainFrame.SavePreferencesError"), MainFrame.this.getStateSaver().getFile().getAbsolutePath()), LocalizationData.get("ErrorManager.title"), 2);
                    }
                    super.windowClosing(event);
                    event.getWindow().dispose();
                    if (updater != null && updater.exists() && updater.isFile()) {
                        ArrayList<String> command = new ArrayList<String>();
                        command.add(System.getProperty("java.home") + "/bin/java");
                        command.add("-jar");
                        command.add(updater.getAbsolutePath());
                        ProcessBuilder builder = new ProcessBuilder(command);
                        try {
                            Process process = builder.start();
                            BufferedReader err = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                            String line = err.readLine();
                            while (line != null) {
                                line = err.readLine();
                            }
                        }
                        catch (IOException e) {
                            ErrorManager.INSTANCE.log(event.getWindow(), e);
                        }
                    }
                }
            }
        });
        if (filteredData == null) {
            this.data = new GlobalData(){
                private final boolean checkEventOnEDT = Boolean.getBoolean("CheckGlobalDataEventAreOnEDT");

                @Override
                protected void fireEvent(DataEvent event) {
                    if (this.isEventsEnabled() && this.checkEventOnEDT && !SwingUtilities.isEventDispatchThread() && this.getNumberOfListeners() > 0) {
                        RuntimeException e = new RuntimeException("WARNING: a GlobalData event is thrown in a thread different from the event dispatch thread !");
                        e.fillInStackTrace();
                        e.printStackTrace();
                    }
                    super.fireEvent(event);
                }
            };
            this.filteredData = new FilteredData(this.data);
        } else {
            this.data = filteredData.getGlobalData();
            this.filteredData = filteredData;
        }
        PlugInContainer[] pluginContainers = Preferences.getPlugins();
        if (restartData == null) {
            restartData = new Object[pluginContainers.length];
        }
        this.plugins = new AbstractPlugIn[pluginContainers.length];
        for (int i = 0; i < this.plugins.length; ++i) {
            if (pluginContainers[i].isActivated()) {
                this.plugins[i] = pluginContainers[i].build(this.filteredData, restartData[i]);
                if (this.plugins[i] != null) {
                    this.plugins[i].setContext(this);
                }
            }
            if (pluginContainers[i].getInstanciationException() == null) continue;
            ErrorManager.INSTANCE.log(null, pluginContainers[i].getInstanciationException());
        }
        MainPanel mainPanel = new MainPanel(this.plugins);
        GlobalPanel gPanel = new GlobalPanel(mainPanel);
        this.getJFrame().setContentPane(gPanel);
        mainPanel.addPropertyChangeListener("selectedPlugin", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                MainFrame.this.mainMenu.updateMenu(MainFrame.this.getCurrentPlugIn());
            }
        });
        this.data.addListener(new DataListener(){

            @Override
            public void processEvent(DataEvent event) {
                if (event instanceof URIChangedEvent || event instanceof EverythingChangedEvent || event instanceof NeedToBeSavedChangedEvent) {
                    MainFrame.this.updateWindowTitle();
                }
            }
        });
        this.mainMenu = new MainMenuBar(this);
        this.getJFrame().setJMenuBar(this.mainMenu);
        float ratio = Preferences.INSTANCE.getFontSizeRatio();
        this.getJFrame().setMinimumSize(new Dimension((int)(800.0f * ratio), (int)(400.0f * ratio)));
        this.restoreMainFramePosition();
        this.getStateSaver().restoreState(gPanel.getMainPanel(), this.getClass().getCanonicalName());
        for (int i = 0; i < this.plugins.length; ++i) {
            if (this.plugins[i] == null) continue;
            this.plugins[i].restoreState();
        }
        this.mainMenu.updateMenu(gPanel.getMainPanel().getSelectedPlugIn());
        this.updateWindowTitle();
        this.getJFrame().setVisible(true);
        MessagesBuilder.build(((GlobalPanel)this.getContentPane()).getInfoPanel());
    }

    public GlobalData getData() {
        return this.data;
    }

    public FilteredData getFilteredData() {
        return this.filteredData;
    }

    public int getPlugInsNumber() {
        return this.plugins.length;
    }

    public AbstractPlugIn getPlugIn(int index) {
        return this.plugins[index];
    }

    public AbstractPlugIn getCurrentPlugIn() {
        return ((GlobalPanel)this.getContentPane()).getMainPanel().getSelectedPlugIn();
    }

    private void updateWindowTitle() {
        String title = LocalizationData.get("ApplicationName");
        URI uri = this.data.getURI();
        if (uri != null) {
            title = title + " - " + YapbamPersistenceManager.MANAGER.getAdapter(uri).getService().getDisplayable(uri);
        }
        if (this.data.somethingHasChanged()) {
            title = title + " *";
        }
        this.getJFrame().setTitle(title);
    }

    public void restart() {
        this.isRestarting = true;
        final Object[] restartData = new Object[this.plugins.length];
        for (int i = 0; i < restartData.length; ++i) {
            restartData[i] = this.plugins[i].getRestartData();
        }
        this.getJFrame().dispatchEvent(new WindowEvent(this.getJFrame(), 201));
        MainFrame.setLookAndFeel();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new MainFrame(MainFrame.this.filteredData, restartData);
            }
        });
    }

    public static void setLookAndFeel() {
        String lookAndFeelName = Preferences.INSTANCE.getLookAndFeel();
        try {
            String lookAndFeelClass = Utils.getLFClassFromName(lookAndFeelName);
            if (lookAndFeelClass != null) {
                UIManager.setLookAndFeel(lookAndFeelClass);
            }
            UIManager.getLookAndFeelDefaults().setDefaultLocale(LocalizationData.getLocale());
        }
        catch (Exception lookAndFeelClass) {
            // empty catch block
        }
        try {
            int iconSize = 16;
            Font defaultFont = Preferences.INSTANCE.getDefaultFont();
            if (defaultFont != null) {
                Font requiredFont = defaultFont.deriveFont(Preferences.INSTANCE.getFontSizeRatio() * (float)defaultFont.getSize());
                FontUtils.setDefaultFont(requiredFont);
                iconSize = 16 * requiredFont.getSize() / 12;
            }
            IconManager.reset(iconSize);
        }
        catch (Throwable e) {
            ErrorManager.INSTANCE.log(null, e);
        }
    }

    private void saveState() {
        if (this.getData().getURI() != null) {
            this.getStateSaver().put(LAST_URI, this.getData().getURI().toString());
        } else {
            this.getStateSaver().remove(LAST_URI);
        }
        Point location = this.getJFrame().getLocation();
        this.getStateSaver().put(FRAME_LOCATION_X, Integer.toString(location.x));
        this.getStateSaver().put(FRAME_LOCATION_Y, Integer.toString(location.y));
        Dimension size = this.getJFrame().getSize();
        int h = (this.getJFrame().getExtendedState() & 4) == 0 ? size.height : -1;
        this.getStateSaver().put(FRAME_SIZE_HEIGHT, Integer.toString(h));
        int w = (this.getJFrame().getExtendedState() & 2) == 0 ? size.width : -1;
        this.getStateSaver().put(FRAME_SIZE_WIDTH, Integer.toString(w));
        for (int i = 0; i < this.getPlugInsNumber(); ++i) {
            if (this.getPlugIn(i) == null) continue;
            this.getPlugIn(i).saveState();
        }
        this.getStateSaver().saveState(((GlobalPanel)this.getContentPane()).getMainPanel(), this.getClass().getCanonicalName());
        this.getStateSaver().save(LAST_VERSION_USED, ApplicationContext.getVersion());
        if (Preferences.INSTANCE.getStartStateOptions().isRememberFilter()) {
            if (!this.getData().somethingHasChanged() && this.getFilteredData().getFilter().isActive()) {
                this.getStateSaver().save(LAST_FILTER_USED, this.getFilteredData().getFilter(), this.getData().getPassword());
            } else {
                this.getStateSaver().remove(LAST_FILTER_USED);
            }
        }
        try {
            this.getStateSaver().toDisk();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this.getJFrame(), Formatter.format(LocalizationData.get("MainFrame.SaveStateError"), this.getStateSaver().getFile().getAbsolutePath()), LocalizationData.get("ErrorManager.title"), 2);
        }
    }

    private YapbamState getStateSaver() {
        return YapbamState.INSTANCE;
    }

    private void restoreMainFramePosition() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int x = Integer.parseInt(this.getStateSaver().get(FRAME_LOCATION_X, "0"));
        int y = Integer.parseInt(this.getStateSaver().get(FRAME_LOCATION_Y, "0"));
        int width = Integer.parseInt(this.getStateSaver().get(FRAME_SIZE_WIDTH, "" + screenSize.width / 2));
        int height = Integer.parseInt(this.getStateSaver().get(FRAME_SIZE_HEIGHT, "" + screenSize.height / 2));
        this.getJFrame().setLocation(x, y);
        this.getJFrame().setSize(width, height);
        int extendedState = 0;
        if (height < 0) {
            extendedState |= 4;
        }
        if (width < 0) {
            extendedState |= 2;
        }
        this.getJFrame().setExtendedState(extendedState);
    }

    private void initData(String path) {
        boolean restore;
        URI lastUri = Preferences.INSTANCE.getStartStateOptions().isRememberFile() && this.getStateSaver().contains(LAST_URI) ? URI.create(this.getStateSaver().get(LAST_URI)) : null;
        URI uri = null;
        uri = path != null ? new File(path).toURI() : lastUri;
        boolean bl = restore = path == null;
        if (uri != null) {
            final URI finalURI = uri;
            YapbamPersistenceManager.MANAGER.read(this.getJFrame(), new YapbamDataWrapper(this.getData()), uri, new PersistenceManager.ErrorProcessor(){

                @Override
                public boolean processError(Throwable e) {
                    if (e instanceof UnsupportedSchemeException) {
                        return true;
                    }
                    Service service = YapbamPersistenceManager.MANAGER.getAdapter(finalURI).getService();
                    String displayedURI = service.getDisplayable(finalURI);
                    File file = service.getLocalFile(finalURI);
                    if (e instanceof FileNotFoundException) {
                        if (file.exists()) {
                            if ("file".equals(finalURI.getScheme())) {
                                ErrorManager.INSTANCE.display(MainFrame.this.getJFrame(), null, Formatter.format(LocalizationData.get("MainFrame.LastNotReadable"), displayedURI));
                            } else {
                                ErrorManager.INSTANCE.display(MainFrame.this.getJFrame(), null, Formatter.format(LocalizationData.get("openDialog.cacheNotReadable"), file));
                            }
                        } else {
                            ErrorManager.INSTANCE.display(MainFrame.this.getJFrame(), null, Formatter.format(LocalizationData.get("MainFrame.LastNotFound"), displayedURI));
                        }
                    } else if (e instanceof IOException) {
                        if (e instanceof UnsupportedFileVersionException || e instanceof UnsupportedFormatException) {
                            return false;
                        }
                        if (restore) {
                            ErrorManager.INSTANCE.display(MainFrame.this.getJFrame(), e, Formatter.format(LocalizationData.get("MainFrame.ReadLastError"), displayedURI));
                        } else {
                            ErrorManager.INSTANCE.display(MainFrame.this.getJFrame(), e, LocalizationData.get("MainFrame.ReadError"));
                        }
                    } else {
                        return false;
                    }
                    return true;
                }
            });
            if (uri.equals(lastUri) && Preferences.INSTANCE.getStartStateOptions().isRememberFilter()) {
                try {
                    Filter filter = this.getStateSaver().restoreFilter(LAST_FILTER_USED, this.getData());
                    if (filter != null) {
                        this.getFilteredData().getFilter().copy(filter);
                    }
                }
                catch (Exception e) {
                    ErrorManager.INSTANCE.log(this.getJFrame(), e);
                    JOptionPane.showMessageDialog(this.getJFrame(), LocalizationData.get("MainFrame.ReadLastFilterError"), LocalizationData.get("ErrorManager.title"), 2);
                }
            }
        }
    }

    @Override
    public TransactionSelector getCurrentTransactionSelector() {
        return this.mainMenu.getTransactionSelector();
    }

    @Override
    public Account getSelectedAccount() {
        return this.getCurrentPlugIn().getSelectedAccount();
    }

    @Override
    public Window getApplicationWindow() {
        return this.getJFrame();
    }
}

