/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui;

import com.fathzer.jlocal.Formatter;
import com.fathzer.soft.ajlib.swing.dialog.FileChooser;
import com.fathzer.soft.ajlib.utilities.FileUtils;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.print.PrinterException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import net.yapbam.data.Account;
import net.yapbam.data.Filter;
import net.yapbam.data.GlobalData;
import net.yapbam.data.comparator.AccountComparator;
import net.yapbam.data.event.AccountAddedEvent;
import net.yapbam.data.event.AccountPropertyChangedEvent;
import net.yapbam.data.event.AccountRemovedEvent;
import net.yapbam.data.event.DataEvent;
import net.yapbam.data.event.DataListener;
import net.yapbam.data.event.EverythingChangedEvent;
import net.yapbam.data.event.FilterPropertyChangedEvent;
import net.yapbam.data.event.FiltersAddedEvent;
import net.yapbam.data.event.FiltersRemovedEvent;
import net.yapbam.gui.AbstractPlugIn;
import net.yapbam.gui.AccountSelector;
import net.yapbam.gui.ErrorManager;
import net.yapbam.gui.HelpManager;
import net.yapbam.gui.IconManager;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.MainFrame;
import net.yapbam.gui.actions.CheckNewReleaseAction;
import net.yapbam.gui.actions.CompoundTransactionSelector;
import net.yapbam.gui.actions.ConvertToPeriodicalTransactionAction;
import net.yapbam.gui.actions.CustomFilterAction;
import net.yapbam.gui.actions.DeleteTransactionAction;
import net.yapbam.gui.actions.DuplicateTransactionAction;
import net.yapbam.gui.actions.EditPreferenceAction;
import net.yapbam.gui.actions.EditTransactionAction;
import net.yapbam.gui.actions.NewAccountAction;
import net.yapbam.gui.actions.NewTransactionAction;
import net.yapbam.gui.actions.OpenAction;
import net.yapbam.gui.actions.SaveAction;
import net.yapbam.gui.actions.SaveAsAction;
import net.yapbam.gui.dialogs.AboutDialog;
import net.yapbam.gui.dialogs.GetPasswordDialog;
import net.yapbam.gui.dialogs.export.ExportDialog;
import net.yapbam.gui.dialogs.export.Exporter;
import net.yapbam.gui.dialogs.export.ImportDialog;
import net.yapbam.gui.dialogs.export.ImportError;
import net.yapbam.gui.dialogs.export.ImportErrorDialog;
import net.yapbam.gui.dialogs.export.Importer;
import net.yapbam.gui.filter.UserDefinedFilterAction;
import net.yapbam.gui.persistence.YapbamDataWrapper;
import net.yapbam.gui.persistence.YapbamPersistenceManager;
import net.yapbam.gui.transactiontable.GeneratePeriodicalTransactionsAction;
import net.yapbam.gui.util.MenuScroller;
import net.yapbam.util.Portable;

public class MainMenuBar
extends JMenuBar
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private MainFrame frame;
    private JMenuItem menuItemNew;
    private JMenuItem menuItemImport;
    private JMenuItem menuItemSave;
    private JMenuItem menuItemSaveAs;
    private JMenuItem menuItemProtect;
    private JMenuItem menuItemExport;
    private JMenuItem menuItemPrint;
    private JMenuItem menuItemQuit;
    private JMenuItem menuItemAbout;
    private JMenu filterMenu;
    private JMenu transactionMenu;
    private MenuScroller menuScroller;
    private CompoundTransactionSelector selector;

    MainMenuBar(MainFrame frame) {
        this.frame = frame;
        int menuShortcutKeyMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        JMenu menu = new JMenu(LocalizationData.get("MainMenu.File"));
        menu.setMnemonic(LocalizationData.getChar("MainMenu.File.Mnemonic"));
        menu.setToolTipText(LocalizationData.get("MainMenu.File.ToolTip"));
        this.add(menu);
        this.menuItemNew = new JMenuItem(LocalizationData.get("MainMenu.NewFile"), LocalizationData.getChar("MainMenu.NewFile.Mnemonic"));
        this.menuItemNew.setIcon(IconManager.get(IconManager.Name.NEW_FILE));
        this.menuItemNew.setToolTipText(LocalizationData.get("MainMenu.NewFile.ToolTip"));
        this.menuItemNew.addActionListener(this);
        menu.add(this.menuItemNew);
        JMenuItem menuItemOpen = new JMenuItem(new OpenAction(this.frame));
        menuItemOpen.setMnemonic(LocalizationData.getChar("MainMenu.Open.Mnemonic"));
        menuItemOpen.setAccelerator(KeyStroke.getKeyStroke((int)LocalizationData.getChar("MainMenu.Open.Accelerator"), menuShortcutKeyMask));
        menu.add(menuItemOpen);
        this.menuItemSave = new JMenuItem(new SaveAction(this.frame));
        this.menuItemSave.setAccelerator(KeyStroke.getKeyStroke((int)LocalizationData.getChar("MainMenu.Save.Accelerator"), menuShortcutKeyMask));
        this.menuItemSave.setMnemonic(LocalizationData.getChar("MainMenu.Save.Mnemonic"));
        this.menuItemSave.setEnabled(frame.getData().somethingHasChanged());
        menu.add(this.menuItemSave);
        this.menuItemSaveAs = new JMenuItem(new SaveAsAction(this.frame));
        this.menuItemSaveAs.setMnemonic(LocalizationData.getChar("MainMenu.SaveAs.Mnemonic"));
        this.menuItemSaveAs.setEnabled(!frame.getData().isEmpty());
        menu.add(this.menuItemSaveAs);
        this.insertPluginMenuItems(menu, 1);
        menu.addSeparator();
        this.menuItemProtect = new JMenuItem(LocalizationData.get("MainMenu.Protect"), IconManager.get(IconManager.Name.LOCK));
        this.menuItemProtect.setMnemonic(LocalizationData.getChar("MainMenu.Protect.Mnemonic"));
        this.menuItemProtect.setToolTipText(LocalizationData.get("MainMenu.Protect.ToolTip"));
        this.menuItemProtect.addActionListener(this);
        this.menuItemProtect.setEnabled(frame.getData().getURI() != null);
        menu.add(this.menuItemProtect);
        menu.addSeparator();
        this.menuItemImport = new JMenuItem(LocalizationData.get("MainMenu.Import"), IconManager.get(IconManager.Name.IMPORT));
        this.menuItemImport.setMnemonic(LocalizationData.getChar("MainMenu.Import.Mnemonic"));
        this.menuItemImport.setToolTipText(LocalizationData.get("MainMenu.Import.ToolTip"));
        this.menuItemImport.addActionListener(this);
        menu.add(this.menuItemImport);
        this.menuItemExport = new JMenuItem(LocalizationData.get("MainMenu.Export"), IconManager.get(IconManager.Name.EXPORT));
        this.menuItemExport.setMnemonic(LocalizationData.getChar("MainMenu.Export.Mnemonic"));
        this.menuItemExport.setToolTipText(LocalizationData.get("MainMenu.Export.ToolTip"));
        this.menuItemExport.addActionListener(this);
        this.menuItemExport.setEnabled(frame.getData().getAccountsNumber() > 0);
        menu.add(this.menuItemExport);
        this.insertPluginMenuItems(menu, 8);
        menu.addSeparator();
        this.menuItemPrint = new JMenuItem(LocalizationData.get("MainMenuBar.Print"), IconManager.get(IconManager.Name.PRINT));
        this.menuItemPrint.setMnemonic(LocalizationData.getChar("MainMenu.Print.Mnemonic"));
        this.menuItemPrint.setAccelerator(KeyStroke.getKeyStroke((int)LocalizationData.getChar("MainMenuBar.Print.Accelerator"), menuShortcutKeyMask));
        this.menuItemPrint.setToolTipText(LocalizationData.get("MainMenuBar.Print.ToolTip"));
        this.menuItemPrint.addActionListener(this);
        this.menuItemPrint.setEnabled(false);
        menu.add(this.menuItemPrint);
        menu.addSeparator();
        JMenuItem editPrefMenu = new JMenuItem(new EditPreferenceAction(frame));
        editPrefMenu.setIcon(IconManager.get(IconManager.Name.SETTINGS));
        menu.add(editPrefMenu);
        this.insertPluginMenuItems(menu, 2);
        menu.addSeparator();
        this.menuItemQuit = new JMenuItem(LocalizationData.get("MainMenu.Quit"));
        this.menuItemQuit.setAccelerator(KeyStroke.getKeyStroke((int)LocalizationData.getChar("MainMenu.Quit.Accelerator"), menuShortcutKeyMask));
        this.menuItemQuit.setMnemonic(LocalizationData.getChar("MainMenu.Quit.Mnemonic"));
        this.menuItemQuit.setToolTipText(LocalizationData.get("MainMenu.Quit.ToolTip"));
        this.menuItemQuit.addActionListener(this);
        menu.add(this.menuItemQuit);
        this.transactionMenu = new JMenu(LocalizationData.get("MainMenu.Transactions"));
        this.transactionMenu.setMnemonic(LocalizationData.getChar("MainMenu.Transactions.Mnemonic"));
        this.transactionMenu.setToolTipText(LocalizationData.get("MainMenu.Transactions.ToolTip"));
        JMenuItem menuItemNewAccount = new JMenuItem(new NewAccountAction(frame.getData()));
        menuItemNewAccount.setMnemonic(LocalizationData.getChar("MainMenu.Accounts.New.Mnemonic"));
        this.transactionMenu.add(menuItemNewAccount);
        this.insertPluginMenuItems(this.transactionMenu, 3);
        this.transactionMenu.addSeparator();
        AccountSelector as = new AccountSelector(){

            @Override
            public Account getSelectedAccount() {
                return MainMenuBar.this.frame.getSelectedAccount();
            }
        };
        JMenuItem item = new JMenuItem(new NewTransactionAction(frame.getFilteredData(), this.getTransactionSelector(), false, as));
        item.setAccelerator(KeyStroke.getKeyStroke((int)LocalizationData.getChar("MainMenu.Transactions.New.Accelerator"), menuShortcutKeyMask));
        this.transactionMenu.add(item);
        item = new JMenuItem(new NewTransactionAction(frame.getFilteredData(), this.getTransactionSelector(), true, as));
        item.setText(LocalizationData.get("MainMenu.Transactions.NewMultiple"));
        item.setToolTipText(LocalizationData.get("MainMenu.Transactions.NewMultiple.ToolTip"));
        item.setAccelerator(KeyStroke.getKeyStroke((int)LocalizationData.getChar("MainMenu.Transactions.New.Accelerator"), menuShortcutKeyMask + 1));
        this.transactionMenu.add(item);
        CompoundTransactionSelector selector = this.getTransactionSelector();
        item = new JMenuItem(new EditTransactionAction(selector));
        item.setAccelerator(KeyStroke.getKeyStroke((int)LocalizationData.getChar("MainMenu.Transactions.Edit.Accelerator"), menuShortcutKeyMask));
        this.transactionMenu.add(item);
        item = new JMenuItem(new DuplicateTransactionAction(selector));
        item.setAccelerator(KeyStroke.getKeyStroke((int)LocalizationData.getChar("MainMenu.Transactions.Duplicate.Accelerator"), menuShortcutKeyMask));
        this.transactionMenu.add(item);
        item = new JMenuItem(new DeleteTransactionAction(selector));
        item.setAccelerator(KeyStroke.getKeyStroke(127, menuShortcutKeyMask));
        this.transactionMenu.add(item);
        this.insertPluginMenuItems(this.transactionMenu, 4);
        this.transactionMenu.addSeparator();
        this.transactionMenu.add(new JMenuItem(new GeneratePeriodicalTransactionsAction(frame.getData(), true)));
        this.transactionMenu.add(new JMenuItem(new ConvertToPeriodicalTransactionAction(selector)));
        this.insertPluginMenuItems(this.transactionMenu, 5);
        this.add(this.transactionMenu);
        this.filterMenu = new JMenu(LocalizationData.get("MainMenuBar.Filter"));
        this.filterMenu.setToolTipText(LocalizationData.get("MainMenuBar.Filter.Tooltip"));
        this.filterMenu.setMnemonic(LocalizationData.getChar("MainMenuBar.Filter.Mnemonic"));
        this.updateFilterMenu();
        this.add(this.filterMenu);
        PropertyChangeListener listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("filter".equals(evt.getPropertyName())) {
                    MainMenuBar.this.filterMenu.setVisible((Boolean)evt.getNewValue());
                } else if ("printing".equals(evt.getPropertyName())) {
                    MainMenuBar.this.menuItemPrint.setEnabled((Boolean)evt.getNewValue());
                }
            }
        };
        for (int i = 0; i < this.frame.getPlugInsNumber(); ++i) {
            if (this.frame.getPlugIn(i) == null) continue;
            JMenu[] menus = this.frame.getPlugIn(i).getPlugInMenu();
            if (menus != null) {
                for (int j = 0; j < menus.length; ++j) {
                    this.add(menus[j]);
                }
            }
            this.frame.getPlugIn(i).getPropertyChangeSupport().addPropertyChangeListener(listener);
        }
        menu = new JMenu(LocalizationData.get("MainMenu.QuestionMark"));
        menu.setMnemonic(LocalizationData.getChar("MainMenu.QuestionMark.Mnemonic"));
        menu.setToolTipText(LocalizationData.get("MainMenu.QuestionMark.ToolTip"));
        this.add(menu);
        if (!Portable.isWebStarted()) {
            menu.add(new CheckNewReleaseAction(this.frame.getJFrame()));
            this.insertPluginMenuItems(menu, 7);
            menu.addSeparator();
        }
        item = this.getURLMenuItem(LocalizationData.get("MainMenu.help"), new File(Portable.getApplicationDirectory(), "help.html").toURI().toString());
        item.setToolTipText(LocalizationData.get("MainMenu.help.tooltip"));
        menu.add(item);
        item = this.getURLMenuItem(LocalizationData.get("MainMenu.web.support"), "http://sourceforge.net/projects/yapbam/support");
        item.setToolTipText(LocalizationData.get("MainMenu.web.support.tooltip"));
        menu.add(item);
        item = this.getURLMenuItem(LocalizationData.get("MainMenu.web.yapbam"), "https://www.yapbam.net");
        item.setToolTipText(LocalizationData.get("MainMenu.web.yapbam.tooltip"));
        menu.add(item);
        this.insertPluginMenuItems(menu, 9);
        menu.addSeparator();
        this.menuItemAbout = new JMenuItem(LocalizationData.get("MainMenu.About"));
        this.menuItemAbout.setMnemonic(LocalizationData.getChar("MainMenu.About.Mnemonic"));
        this.menuItemAbout.setToolTipText(LocalizationData.get("MainMenu.About.ToolTip"));
        this.menuItemAbout.addActionListener(this);
        menu.add(this.menuItemAbout);
        this.insertPluginMenuItems(menu, 6);
        this.frame.getData().addListener(new GlobalDataListener());
        this.frame.getFilteredData().addListener(new DataListener(){

            @Override
            public void processEvent(DataEvent event) {
                if (event instanceof EverythingChangedEvent) {
                    MainMenuBar.this.updateFilterMenu();
                }
            }
        });
    }

    private JMenuItem getURLMenuItem(String title, String url) {
        try {
            final URI uri = new URI(url);
            JMenuItem item = new JMenuItem(new AbstractAction(title){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    HelpManager.show((Component)MainMenuBar.this, uri);
                }
            });
            return item;
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private void insertPluginMenuItems(JMenu menu, int part) {
        for (int i = 0; i < this.frame.getPlugInsNumber(); ++i) {
            JMenuItem[] items;
            if (this.frame.getPlugIn(i) == null || (items = this.frame.getPlugIn(i).getMenuItem(part)) == null) continue;
            for (int j = 0; j < items.length; ++j) {
                if (items[j] == null) {
                    menu.addSeparator();
                    continue;
                }
                menu.add(items[j]);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        GlobalData data = this.frame.getData();
        if (source.equals(this.menuItemQuit)) {
            this.frame.getJFrame().dispatchEvent(new WindowEvent(this.frame.getJFrame(), 201));
        } else if (source.equals(this.menuItemNew)) {
            if (YapbamPersistenceManager.MANAGER.verify(this.frame, new YapbamDataWrapper(this.frame.getData())) && JOptionPane.showConfirmDialog(this.frame, LocalizationData.get("MainMenu.NewFile.ConfirmMessage"), LocalizationData.get("MainMenu.NewFile"), 0) == 0) {
                data.clear();
            }
        } else if (source.equals(this.menuItemProtect)) {
            String password = this.frame.getData().getPassword();
            GetPasswordDialog dialog = new GetPasswordDialog(this.frame.getJFrame(), LocalizationData.get("FilePasswordDialog.title"), LocalizationData.get("FilePasswordDialog.setPassword.question"), null, password);
            dialog.setWarningMessage(LocalizationData.get("FilePasswordDialog.setPassword.warning"));
            dialog.setPasswordFieldToolTipText(LocalizationData.get("FilePasswordDialog.setPassword.tooltip"));
            dialog.setConfirmIsRequired(true);
            dialog.setVisible(true);
            String newPassword = dialog.getPassword();
            if (newPassword != null) {
                this.frame.getData().setPassword(newPassword);
            }
        } else if (source.equals(this.menuItemImport)) {
            File file;
            FileChooser chooser = new FileChooser(null);
            chooser.setLocale(LocalizationData.getLocale());
            File lastFile = ImportDialog.getLastFile();
            if (lastFile != null && lastFile.exists() && lastFile.canRead()) {
                ((JFileChooser)chooser).setSelectedFile(lastFile);
            }
            chooser.updateUI();
            File file2 = file = chooser.showOpenDialog(this.frame.getJFrame()) == 0 ? ((JFileChooser)chooser).getSelectedFile() : null;
            if (file != null) {
                try {
                    ImportDialog dialog = new ImportDialog((Window)this.frame.getJFrame(), data, file);
                    dialog.setVisible(true);
                    Importer importer = (Importer)dialog.getResult();
                    if (importer != null && YapbamPersistenceManager.MANAGER.verify(this.frame, new YapbamDataWrapper(this.frame.getData()))) {
                        ImportError[] errors;
                        if (!dialog.getAddToCurrentData()) {
                            data.clear();
                        }
                        if ((errors = importer.importFile(null)).length != 0) {
                            ImportErrorDialog importErrorDialog = new ImportErrorDialog((Window)this.frame.getJFrame(), importer.getParameters().getImportedFileColumns(), errors);
                            importErrorDialog.setVisible(true);
                            if (importErrorDialog.getResult() != null) {
                                errors = new ImportError[]{};
                            }
                        }
                        if (errors.length == 0) {
                            importer.importFile(data);
                        }
                    }
                }
                catch (IOException e) {
                    ImportDialog.doError(this.frame.getJFrame(), e);
                }
            }
        } else if (source.equals(this.menuItemExport)) {
            ExportDialog exportDialog = new ExportDialog((Window)this.frame.getJFrame(), this.frame.getFilteredData());
            exportDialog.setVisible(true);
            Exporter exporter = (Exporter)exportDialog.getResult();
            if (exporter != null) {
                File file;
                FileChooser chooser = new FileChooser(null);
                chooser.setLocale(LocalizationData.getLocale());
                chooser.updateUI();
                File file3 = file = chooser.showSaveDialog(this.frame.getJFrame()) == 0 ? ((JFileChooser)chooser).getSelectedFile() : null;
                if (file != null) {
                    try {
                        file = FileUtils.getCanonical(file);
                        exporter.exportFile(file, this.frame.getFilteredData());
                        JOptionPane.showMessageDialog(this.frame.getJFrame(), LocalizationData.get("ExportDialog.done"), LocalizationData.get("ExportDialog.title"), 1);
                    }
                    catch (IOException e1) {
                        ErrorManager.INSTANCE.display(this.frame.getJFrame(), e1);
                    }
                }
            }
        } else if (source.equals(this.menuItemPrint)) {
            try {
                this.frame.getCurrentPlugIn().print();
            }
            catch (PrinterException e1) {
                String okButton = LocalizationData.get("GenericButton.ok");
                String message = Formatter.format(LocalizationData.get("MainMenuBar.Print.Error.Message"), e1.getMessage());
                JOptionPane.showOptionDialog(this.frame.getJFrame(), message, LocalizationData.get("MainMenuBar.Print.Error.Title"), 0, 0, null, new String[]{okButton}, okButton);
            }
        } else if (source.equals(this.menuItemAbout)) {
            new AboutDialog((Window)this.frame.getJFrame()).setVisible(true);
        }
    }

    private void updateFilterMenu() {
        if (this.menuScroller != null) {
            this.menuScroller.dispose();
        }
        this.filterMenu.removeAll();
        if (this.frame.getFilteredData() != null) {
            JCheckBoxMenuItem complexFilterMenuItem = new JCheckBoxMenuItem(new CustomFilterAction(this.frame.getFilteredData()));
            complexFilterMenuItem.setToolTipText(LocalizationData.get("MainMenuBar.customizedFilter.toolTip"));
            this.filterMenu.add(complexFilterMenuItem);
            complexFilterMenuItem.setSelected(this.isComplex(this.frame.getFilteredData().getFilter()));
            JMenuItem eraseItem = new JMenuItem(LocalizationData.get("MainMenuBar.eraseFilters"));
            eraseItem.setToolTipText(LocalizationData.get("MainMenuBar.eraseFilters.toolTip"));
            eraseItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainMenuBar.this.frame.getFilteredData().getFilter().clear();
                }
            });
            this.filterMenu.add(eraseItem);
            this.filterMenu.addSeparator();
            GlobalData data = this.frame.getData();
            this.buildUserDefinedFiltersMenu(data);
            AccountFilterActionListener listener = new AccountFilterActionListener();
            List<Account> filterAccounts = this.frame.getFilteredData().getFilter().getValidAccounts();
            boolean hasAccountFilter = filterAccounts != null;
            Account[] accounts = AccountComparator.getSortedAccounts(this.frame.getData(), this.getLocale());
            for (int i = 0; i < data.getAccountsNumber(); ++i) {
                Account account = accounts[i];
                JRadioButtonMenuItem item = new JRadioButtonMenuItem(account.getName());
                item.setToolTipText(Formatter.format(LocalizationData.get("MainMenuBar.AccountFilter.toolTip"), account.getName()));
                if (hasAccountFilter) {
                    item.setSelected(filterAccounts.contains(account));
                }
                this.filterMenu.add(item);
                item.addActionListener(listener);
            }
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(LocalizationData.get("MainMenuBar.NoFilter"));
            item.setToolTipText(LocalizationData.get("MainMenuBar.NoAccountFilter.toolTip"));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainMenuBar.this.frame.getFilteredData().getFilter().setValidAccounts(null);
                }
            });
            item.setSelected(!hasAccountFilter);
            this.filterMenu.add(item);
            this.filterMenu.addSeparator();
            this.buildBooleanFilterChoiceMenu(1, new String[]{LocalizationData.get("MainMenuBar.checked"), LocalizationData.get("MainMenuBar.notChecked")}, new int[]{1, 2}, new String[]{LocalizationData.get("MainMenuBar.checked.toolTip"), LocalizationData.get("MainMenuBar.notChecked.toolTip")}, LocalizationData.get("MainMenuBar.NoCheckedFilter.toolTip"));
            this.filterMenu.addSeparator();
            this.buildBooleanFilterChoiceMenu(2, new String[]{LocalizationData.get("MainMenuBar.Expenses"), LocalizationData.get("MainMenuBar.Receipts")}, new int[]{4, 8}, new String[]{LocalizationData.get("MainMenuBar.Expenses.toolTip"), LocalizationData.get("MainMenuBar.Receipts.toolTip")}, LocalizationData.get("MainMenuBar.NoAmountFilter.toolTip"));
            this.menuScroller = new MenuScroller(this.filterMenu, 16, 150, data.getFiltersNumber() > 0 ? 5 : 3, 9, false);
        }
    }

    private void buildUserDefinedFiltersMenu(GlobalData data) {
        if (data.getFiltersNumber() > 0) {
            JMenu menu = new JMenu(LocalizationData.get("MainMenuBar.predefinedFilters.menu.title"));
            menu.setToolTipText(LocalizationData.get("MainMenuBar.predefinedFilters.menu.tooltip"));
            ArrayList<String> filterNames = new ArrayList<String>(data.getFiltersNumber());
            for (int i = 0; i < data.getFiltersNumber(); ++i) {
                filterNames.add(data.getFilter(i).getName());
            }
            Collections.sort(filterNames, String.CASE_INSENSITIVE_ORDER);
            for (String name : filterNames) {
                menu.add(new JMenuItem(new UserDefinedFilterAction(this.frame.getFilteredData(), name)));
            }
            this.filterMenu.add(menu);
            this.filterMenu.addSeparator();
        }
    }

    private boolean isComplex(Filter filter) {
        double min = filter.getMinAmount();
        double max = filter.getMaxAmount();
        boolean amountSimple = min == 0.0 && max == Double.POSITIVE_INFINITY;
        List<Account> validAccounts = filter.getValidAccounts();
        boolean complexAccount = validAccounts != null && validAccounts.size() != 1;
        return complexAccount || filter.getValidCategories() != null || filter.getValidModes() != null || filter.getDateFrom() != null || filter.getDateTo() != null || filter.getValueDateFrom() != null || filter.getValueDateTo() != null || filter.getDescriptionMatcher() != null || filter.getCommentMatcher() != null || filter.getNumberMatcher() != null || filter.getStatementMatcher() != null || !amountSimple;
    }

    private void buildBooleanFilterChoiceMenu(int kind, String[] texts, int[] properties, String[] tooltips, String eraseTooltip) {
        Filter filter = this.frame.getFilteredData().getFilter();
        ButtonGroup group = new ButtonGroup();
        JRadioButtonMenuItem menuItem = new JRadioButtonMenuItem(texts[0]);
        menuItem.setToolTipText(tooltips[0]);
        menuItem.setSelected(filter.isOk(properties[0]) && !filter.isOk(properties[1]));
        this.filterMenu.add(menuItem);
        group.add(menuItem);
        menuItem.addActionListener(new FilterActionItem(kind, properties[0]));
        menuItem = new JRadioButtonMenuItem(texts[1]);
        menuItem.setToolTipText(tooltips[1]);
        menuItem.setSelected(!filter.isOk(properties[0]) && filter.isOk(properties[1]));
        this.filterMenu.add(menuItem);
        group.add(menuItem);
        menuItem.addActionListener(new FilterActionItem(kind, properties[1]));
        menuItem = new JRadioButtonMenuItem(LocalizationData.get("MainMenuBar.NoFilter"));
        menuItem.setToolTipText(eraseTooltip);
        menuItem.setSelected(filter.isOk(properties[0]) && filter.isOk(properties[1]));
        this.filterMenu.add(menuItem);
        group.add(menuItem);
        menuItem.addActionListener(new FilterActionItem(kind, properties[0] | properties[1]));
    }

    public void updateMenu(AbstractPlugIn plugin) {
        this.transactionMenu.setVisible(plugin != null && plugin.allowMenu(1));
        this.filterMenu.setVisible(plugin != null && plugin.allowMenu(2));
        this.menuItemPrint.setEnabled(plugin != null && plugin.isPrintingSupported());
        this.getTransactionSelector().setInternalSelector(plugin == null ? null : plugin.getTransactionSelector());
    }

    public CompoundTransactionSelector getTransactionSelector() {
        if (this.selector == null) {
            this.selector = new CompoundTransactionSelector(this.frame.getFilteredData());
        }
        return this.selector;
    }

    class FilterActionItem
    implements ActionListener {
        static final int CHECKED_STATUS = 1;
        static final int NATURE = 2;
        private int property;
        private int kind;

        FilterActionItem(int kind, int property) {
            this.kind = kind;
            this.property = property;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Filter filter = MainMenuBar.this.frame.getFilteredData().getFilter();
            if (this.kind == 1) {
                filter.setStatementFilter(this.property, this.property == 2 ? null : filter.getStatementMatcher());
            } else {
                filter.setAmountFilter(this.property, filter.getMinAmount(), filter.getMaxAmount());
            }
        }
    }

    class GlobalDataListener
    implements DataListener {
        GlobalDataListener() {
        }

        @Override
        public void processEvent(DataEvent event) {
            boolean filterEvent;
            GlobalData data = (GlobalData)event.getSource();
            boolean somethingToSave = !data.isEmpty();
            MainMenuBar.this.menuItemSave.setEnabled(data.somethingHasChanged() && somethingToSave);
            MainMenuBar.this.menuItemSaveAs.setEnabled(somethingToSave);
            MainMenuBar.this.menuItemProtect.setEnabled(somethingToSave || data.getURI() != null);
            MainMenuBar.this.menuItemExport.setEnabled(data.getAccountsNumber() != 0);
            boolean accountEvent = event instanceof AccountAddedEvent || event instanceof AccountRemovedEvent || event instanceof AccountPropertyChangedEvent && ((AccountPropertyChangedEvent)event).getProperty().equals("name");
            boolean bl = filterEvent = event instanceof FiltersAddedEvent || event instanceof FiltersRemovedEvent || event instanceof FilterPropertyChangedEvent;
            if (accountEvent || filterEvent) {
                MainMenuBar.this.updateFilterMenu();
            }
        }
    }

    private final class AccountFilterActionListener
    implements ActionListener {
        private AccountFilterActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JMenuItem item = (JMenuItem)e.getSource();
            Account account = MainMenuBar.this.frame.getData().getAccount(item.getText());
            if ((e.getModifiers() & 1) == 0) {
                MainMenuBar.this.frame.getFilteredData().getFilter().setValidAccounts(Collections.singletonList(account));
            } else {
                this.doRemove(account);
            }
        }

        private void doRemove(Account account) {
            GlobalData globalData = MainMenuBar.this.frame.getData();
            Filter filter = MainMenuBar.this.frame.getFilteredData().getFilter();
            List<Account> validAccounts = MainMenuBar.this.frame.getFilteredData().getFilter().getValidAccounts();
            if (validAccounts == null) {
                validAccounts = new ArrayList<Account>();
                for (int i = 0; i < globalData.getAccountsNumber(); ++i) {
                    validAccounts.add(globalData.getAccount(i));
                }
            }
            if (validAccounts.contains(account)) {
                validAccounts.remove(account);
                if (validAccounts.isEmpty()) {
                    validAccounts = null;
                }
            } else {
                validAccounts.add(account);
                if (validAccounts.size() == globalData.getAccountsNumber()) {
                    validAccounts = null;
                }
            }
            filter.setValidAccounts(validAccounts);
        }
    }
}

