/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui;

import com.fathzer.jlocal.Formatter;
import com.fathzer.soft.ajlib.utilities.FileUtils;
import com.fathzer.soft.ajlib.utilities.StringUtils;
import java.awt.Rectangle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import net.yapbam.data.Filter;
import net.yapbam.data.GlobalData;
import net.yapbam.data.ProgressReport;
import net.yapbam.data.xml.AbstractSerializer;
import net.yapbam.data.xml.FilterHandler;
import net.yapbam.data.xml.XMLSerializer;
import net.yapbam.gui.Preferences;
import net.yapbam.gui.preferences.StartStateSettings;
import net.yapbam.gui.util.XTableColumnModel;
import net.yapbam.gui.widget.TabbedPane;
import net.yapbam.util.ArrayUtils;
import net.yapbam.util.DateUtils;
import net.yapbam.util.Portable;
import net.yapbam.util.PreferencesUtils;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class YapbamState {
    private static final String COLUMN_WIDTH = "column.width.";
    private static final String COLUMN_INDEX = "column.index.";
    private static final String COLUMN_HIDDEN = "column.hidden.";
    private static final String COLUMN_SORTER = "column.sorter";
    private static final String PRINTING_ATTRIBUTES = ".printing.attributes";
    private static final String TAB_ORDER = ".tab.order";
    public static final YapbamState INSTANCE = new YapbamState();
    private Properties properties;

    protected YapbamState() {
        block6: {
            this.properties = new Properties();
            try {
                if (Portable.isPortable()) {
                    if (Preferences.INSTANCE.isFirstRun()) break block6;
                    FileInputStream inStream = new FileInputStream(this.getFile());
                    try {
                        this.properties.load(inStream);
                        break block6;
                    }
                    finally {
                        inStream.close();
                    }
                }
                PreferencesUtils.fromPreferences(this.getPreferences(), this.properties);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private java.util.prefs.Preferences getPreferences() {
        return java.util.prefs.Preferences.userRoot().node(this.getClass().getName());
    }

    protected File getFile() {
        return new File(Portable.getDataDirectory(), ".yapbam");
    }

    public void restoreState(JTable table, String prefix) {
        String sorters;
        RowSorter<? extends TableModel> sorter;
        String valueString;
        int i;
        TableColumnModel model = table.getColumnModel();
        StartStateSettings startOptions = Preferences.INSTANCE.getStartStateOptions();
        if (startOptions.isRememberColumnsWidth()) {
            for (i = 0; i < model.getColumnCount(); ++i) {
                int width;
                valueString = (String)this.properties.get(prefix + COLUMN_WIDTH + i);
                if (valueString == null || (width = Integer.parseInt(valueString)) <= 0) continue;
                model.getColumn(i).setPreferredWidth(width);
            }
        }
        if (startOptions.isRememberColumnsOrder()) {
            for (i = model.getColumnCount() - 1; i >= 0; --i) {
                int modelIndex;
                valueString = (String)this.properties.get(prefix + COLUMN_INDEX + i);
                if (valueString == null || (modelIndex = Integer.parseInt(valueString)) < 0 || modelIndex >= table.getColumnCount()) continue;
                table.moveColumn(table.convertColumnIndexToView(modelIndex), i);
            }
        }
        if (startOptions.isRememberHiddenColumns() && model instanceof XTableColumnModel) {
            XTableColumnModel xModel = (XTableColumnModel)model;
            for (int i2 = 0; i2 < xModel.getColumnCount(false); ++i2) {
                if (!Boolean.valueOf(this.properties.getProperty(prefix + COLUMN_HIDDEN + i2, "false")).booleanValue()) continue;
                TableColumn column = xModel.getColumnByModelIndex(i2);
                xModel.setColumnVisible(column, false);
            }
        }
        if (startOptions.isRememberRowsSortKeys() && (sorter = table.getRowSorter()) != null && (sorters = this.properties.getProperty(prefix + COLUMN_SORTER)) != null) {
            ArrayList<RowSorter.SortKey> keys = new ArrayList<RowSorter.SortKey>();
            String[] split = StringUtils.split(sorters, ',');
            for (int i3 = 0; i3 < split.length; ++i3) {
                RowSorter.SortKey sortKey = YapbamState.getSortKey(split[i3]);
                if (sortKey.getColumn() >= table.getColumnCount()) continue;
                keys.add(sortKey);
            }
            sorter.setSortKeys(keys);
        }
    }

    private static RowSorter.SortKey getSortKey(String encodedForm) {
        String[] split = StringUtils.split(encodedForm, ':');
        int column = Integer.parseInt(split[0]);
        boolean ascending = Boolean.parseBoolean(split[1]);
        return new RowSorter.SortKey(column, ascending ? SortOrder.ASCENDING : SortOrder.DESCENDING);
    }

    public void saveState(JTable table, String prefix) {
        StringBuilder buf = new StringBuilder();
        RowSorter<? extends TableModel> sorter = table.getRowSorter();
        if (sorter != null) {
            List<RowSorter.SortKey> sortKeys = sorter.getSortKeys();
            for (RowSorter.SortKey sortKey : sortKeys) {
                if (sortKey.getSortOrder() == SortOrder.UNSORTED) continue;
                if (buf.length() != 0) {
                    buf.append(',');
                }
                buf.append(sortKey.getColumn() + ":" + sortKey.getSortOrder().equals((Object)SortOrder.ASCENDING));
            }
        }
        if (buf.length() > 0) {
            this.put(prefix + COLUMN_SORTER, buf.toString());
        } else {
            this.properties.remove(prefix + COLUMN_SORTER);
        }
        TableColumnModel model = table.getColumnModel();
        if (model instanceof XTableColumnModel) {
            XTableColumnModel xModel = (XTableColumnModel)model;
            for (int viewIndex = 0; viewIndex < xModel.getColumnCount(false); ++viewIndex) {
                TableColumn column = xModel.getColumn(viewIndex, false);
                int modelIndex = column.getModelIndex();
                this.put(prefix + COLUMN_WIDTH + modelIndex, Integer.toString(column.getWidth()));
                this.put(prefix + COLUMN_INDEX + viewIndex, Integer.toString(modelIndex));
                String key = prefix + COLUMN_HIDDEN + modelIndex;
                this.put(key, Boolean.valueOf(!xModel.isColumnVisible(column)).toString());
            }
        } else {
            for (int viewIndex = 0; viewIndex < model.getColumnCount(); ++viewIndex) {
                int modelIndex = table.convertColumnIndexToModel(viewIndex);
                this.put(prefix + COLUMN_WIDTH + modelIndex, Integer.toString(model.getColumn(viewIndex).getWidth()));
                this.put(prefix + COLUMN_INDEX + viewIndex, Integer.toString(modelIndex));
            }
        }
    }

    public void saveState(TabbedPane tabbedPane, String prefix) {
        this.put(prefix + TAB_ORDER, ArrayUtils.toString(tabbedPane.getIds()));
    }

    public void restoreState(TabbedPane tabbedPane, String prefix) {
        if (Preferences.INSTANCE.getStartStateOptions().isRememberTabsOrder()) {
            String property = this.get(prefix + TAB_ORDER);
            if (property != null) {
                tabbedPane.setOrder(ArrayUtils.parseIntArray(property));
            }
            if (tabbedPane.getTabCount() > 0) {
                tabbedPane.setSelectedIndex(0);
            }
        }
    }

    public boolean contains(String key) {
        return this.properties.containsKey(key);
    }

    public void remove(String key) {
        this.properties.remove(key);
    }

    public String get(String key) {
        return this.properties.getProperty(key);
    }

    public String get(String key, String defaultValue) {
        return this.properties.getProperty(key, defaultValue);
    }

    public void put(String key, String value) {
        PreferencesUtils.verifyPreferencesCompliance(key, value);
        this.properties.put(key, value);
    }

    public Date getDate(String key) {
        String dummy = this.properties.getProperty(key);
        if (dummy == null) {
            return new Date(0L);
        }
        return DateUtils.integerToDate(Integer.parseInt(dummy));
    }

    public Integer getInteger(String key) {
        String dummy = this.properties.getProperty(key, null);
        if (dummy != null) {
            try {
                return Integer.valueOf(dummy);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    public void put(String key, Date date) {
        this.put(key, Integer.toString(DateUtils.dateToInteger(date)));
    }

    public void put(String key, Rectangle value) {
        this.put(key, value.x + "," + value.y + "," + value.width + "," + value.height);
    }

    public Rectangle getRectangle(String key) {
        String value = this.properties.getProperty(key);
        if (value == null) {
            return null;
        }
        StringTokenizer tokens = new StringTokenizer(value, ",");
        return new Rectangle(Integer.parseInt(tokens.nextToken()), Integer.parseInt(tokens.nextToken()), Integer.parseInt(tokens.nextToken()), Integer.parseInt(tokens.nextToken()));
    }

    public void toDisk() throws IOException {
        if (Portable.isPortable()) {
            FileOutputStream stream = FileUtils.getHiddenCompliantStream(this.getFile());
            try {
                this.properties.store(stream, "Yapbam startup state");
            }
            finally {
                stream.close();
            }
        } else {
            PreferencesUtils.toPreferences(this.getPreferences(), this.properties, true);
        }
    }

    public PrintRequestAttributeSet restorePrinterSettings(String prefix) {
        PrintRequestAttributeSet result = (PrintRequestAttributeSet)((Object)this.restore(prefix + PRINTING_ATTRIBUTES));
        return result != null ? result : new HashPrintRequestAttributeSet();
    }

    public void savePrinterSettings(String prefix, PrintRequestAttributeSet attributes) {
        this.save(prefix + PRINTING_ATTRIBUTES, (Serializable)((Object)attributes));
    }

    public void save(String key, Serializable serializable) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new GZIPOutputStream(baos));
            oos.writeObject(serializable);
            oos.close();
            this.put(key, Base64.encodeBase64String(baos.toByteArray()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Serializable restore(String key) {
        if (!this.contains(key)) {
            return null;
        }
        try {
            byte[] decoded = Base64.decodeBase64(this.get(key));
            ByteArrayInputStream bais = new ByteArrayInputStream(decoded);
            ObjectInputStream ois = new ObjectInputStream(new GZIPInputStream(bais));
            Serializable result = (Serializable)ois.readObject();
            ois.close();
            return result;
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).warn(Formatter.format("Exception while restoring {0}", key), e);
            return null;
        }
    }

    public void save(String key, Filter filter, String password) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            FilterSerializer serializer = new FilterSerializer(null);
            serializer.write(filter, stream, password, null);
            stream.flush();
            String xmlContent = Base64.encodeBase64String(stream.toByteArray());
            this.put(key, xmlContent);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Filter restoreFilter(String key, GlobalData data) {
        String property = this.properties.getProperty(key);
        if (property != null) {
            byte[] bytes = property.startsWith("<?xml version=\"1.0\" encoding=\"UTF-8\"?>") ? property.getBytes() : Base64.decodeBase64(property);
            ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
            try {
                return (Filter)new FilterSerializer(data).read(data.getPassword(), stream, null);
            }
            catch (AccessControlException accessControlException) {
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private class FilterSerializer
    extends AbstractSerializer<Filter> {
        private GlobalData data;

        FilterSerializer(GlobalData data) {
            this.data = data;
        }

        @Override
        public void directWrite(Filter filter, OutputStream out, ProgressReport report) throws IOException {
            try {
                XMLSerializer xmlSerializer = new XMLSerializer(out);
                xmlSerializer.serialize(filter);
                xmlSerializer.closeDocument();
            }
            catch (SAXException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public Filter directRead(String password, InputStream in, ProgressReport report) throws IOException {
            FilterHandler handler = new FilterHandler(this.data);
            try {
                SAXParserFactory.newInstance().newSAXParser().parse(in, (DefaultHandler)handler);
            }
            catch (SAXException e) {
                throw new RuntimeException(e);
            }
            catch (ParserConfigurationException e) {
                throw new RuntimeException(e);
            }
            return handler.getFilter();
        }
    }
}

