/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import net.yapbam.data.FilteredData;
import net.yapbam.data.Transaction;
import net.yapbam.gui.TransactionSelector;

public class CompoundTransactionSelector
implements TransactionSelector {
    private List<PropertyChangeListener> listeners;
    private TransactionSelector internalSelector;
    private PropertyChangeListener internalListener;
    private FilteredData data;

    public CompoundTransactionSelector(FilteredData data) {
        this.data = data;
        this.listeners = new ArrayList<PropertyChangeListener>();
        this.internalSelector = null;
        this.internalListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                CompoundTransactionSelector.this.firePropertyChangedEvent(evt);
            }
        };
    }

    @Override
    public Transaction[] getSelectedTransactions() {
        return this.internalSelector == null ? new Transaction[]{} : this.internalSelector.getSelectedTransactions();
    }

    @Override
    public void setSelectedTransactions(Transaction[] transactions) {
        if (this.internalSelector != null) {
            this.internalSelector.setSelectedTransactions(transactions);
        }
    }

    @Override
    public FilteredData getFilteredData() {
        return this.internalSelector == null ? this.data : this.internalSelector.getFilteredData();
    }

    public void setInternalSelector(TransactionSelector selector) {
        if (this.internalSelector != null) {
            this.internalSelector.removePropertyChangeListener("selectedTransaction", this.internalListener);
        }
        Transaction[] old = this.getSelectedTransactions();
        this.internalSelector = selector;
        if (selector != null) {
            selector.addPropertyChangeListener("selectedTransaction", this.internalListener);
        }
        this.firePropertyChangedEvent(new PropertyChangeEvent(this, "selectedTransaction", old, this.getSelectedTransactions()));
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.listeners.remove(listener);
    }

    private void firePropertyChangedEvent(PropertyChangeEvent evt) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).propertyChange(evt);
        }
    }
}

