/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.administration;

import com.fathzer.jlocal.Formatter;
import com.fathzer.soft.ajlib.swing.Utils;
import com.fathzer.soft.ajlib.swing.table.JTable;
import com.fathzer.soft.ajlib.swing.table.RowSorter;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import net.yapbam.data.Account;
import net.yapbam.data.GlobalData;
import net.yapbam.data.event.AccountAddedEvent;
import net.yapbam.data.event.AccountPropertyChangedEvent;
import net.yapbam.data.event.AccountRemovedEvent;
import net.yapbam.data.event.DataEvent;
import net.yapbam.data.event.DataListener;
import net.yapbam.data.event.EverythingChangedEvent;
import net.yapbam.gui.IconManager;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.actions.NewAccountAction;
import net.yapbam.gui.administration.AbstractListAdministrationPanel;
import net.yapbam.gui.dialogs.EditAccountDialog;

public class AccountListPanel
extends AbstractListAdministrationPanel<GlobalData> {
    private static final long serialVersionUID = 1L;

    @Override
    protected javax.swing.JTable instantiateJTable() {
        JTable jTable = new JTable(this.getTableModel());
        jTable.setDefaultRenderer(Double.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(javax.swing.JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (value == null || value.equals(Double.POSITIVE_INFINITY) || value.equals(Double.NEGATIVE_INFINITY)) {
                    this.setText("");
                } else {
                    this.setText(LocalizationData.getCurrencyInstance().format(value));
                }
                this.setHorizontalAlignment(4);
                return this;
            }
        });
        jTable.setRowSorter(new RowSorter<TableModel>(this.getTableModel()));
        return jTable;
    }

    public AccountListPanel() {
        this((GlobalData)null);
    }

    public AccountListPanel(GlobalData data) {
        super(data);
    }

    private TableModel getTableModel() {
        return new AccountTableModel((GlobalData)this.data);
    }

    @Override
    protected Action getNewButtonAction() {
        return new NewAccountAction((GlobalData)this.data);
    }

    @Override
    protected Action getEditButtonAction() {
        return new EditAccountAction();
    }

    @Override
    protected Action getDeleteButtonAction() {
        return new DeleteAccountAction();
    }

    @Override
    protected Action getDuplicateButtonAction() {
        return null;
    }

    private final class AccountTableModel
    extends AbstractTableModel
    implements DataListener {
        public AccountTableModel(GlobalData data) {
            data.addListener(this);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex >= 1 && columnIndex <= 3) {
                return Double.class;
            }
            if (columnIndex >= 4 && columnIndex <= 6) {
                return Integer.class;
            }
            return String.class;
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return LocalizationData.get("Transaction.account");
            }
            if (columnIndex == 1) {
                return LocalizationData.get("AccountManager.balanceColumn.title");
            }
            if (columnIndex == 2) {
                return LocalizationData.get("AccountManager.alertThresholdLess.title");
            }
            if (columnIndex == 3) {
                return LocalizationData.get("AccountManager.alertThresholdMore.title");
            }
            return "?";
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Account account = ((GlobalData)AccountListPanel.this.data).getAccount(rowIndex);
            if (columnIndex == 0) {
                return account.getName();
            }
            if (columnIndex == 1) {
                return account.getInitialBalance();
            }
            if (columnIndex == 2) {
                return account.getAlertThreshold().getLessThreshold();
            }
            if (columnIndex == 3) {
                return account.getAlertThreshold().getMoreThreshold();
            }
            return "?";
        }

        @Override
        public int getRowCount() {
            return ((GlobalData)AccountListPanel.this.data).getAccountsNumber();
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public void processEvent(DataEvent event) {
            int index;
            Account account = null;
            if (event instanceof EverythingChangedEvent) {
                this.fireTableDataChanged();
            } else if (event instanceof AccountAddedEvent) {
                index = ((GlobalData)AccountListPanel.this.data).indexOf(((AccountAddedEvent)event).getAccount());
                this.fireTableRowsInserted(index, index);
            } else if (event instanceof AccountRemovedEvent) {
                index = ((AccountRemovedEvent)event).getIndex();
                this.fireTableRowsDeleted(index, index);
            } else if (event instanceof AccountPropertyChangedEvent) {
                account = ((AccountPropertyChangedEvent)event).getAccount();
            }
            if (account != null) {
                int row = ((GlobalData)AccountListPanel.this.data).indexOf(account);
                this.fireTableRowsUpdated(row, row);
            }
        }
    }

    class EditAccountAction
    extends AbstractAction {
        EditAccountAction() {
            super(LocalizationData.get("GenericButton.edit"), IconManager.get(IconManager.Name.EDIT_ACCOUNT));
            this.putValue("ShortDescription", LocalizationData.get("AccountManager.editAccount.toolTip"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int selectedRow = AccountListPanel.this.getJTable().convertRowIndexToModel(AccountListPanel.this.getJTable().getSelectedRow());
            EditAccountDialog.edit((GlobalData)AccountListPanel.this.data, Utils.getOwnerWindow(AccountListPanel.this.getEditButton()), ((GlobalData)AccountListPanel.this.data).getAccount(selectedRow));
        }
    }

    class DeleteAccountAction
    extends AbstractAction {
        DeleteAccountAction() {
            super(LocalizationData.get("GenericButton.delete"), IconManager.get(IconManager.Name.DELETE_ACCOUNT));
            this.putValue("ShortDescription", LocalizationData.get("AccountManager.deleteAccount.toolTip"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int selectedRow = AccountListPanel.this.getJTable().convertRowIndexToModel(AccountListPanel.this.getJTable().getSelectedRow());
            Account account = ((GlobalData)AccountListPanel.this.data).getAccount(selectedRow);
            boolean confirmed = true;
            int nb = account.getTransactionsNumber();
            if (nb != 0) {
                String mess = nb == 1 ? LocalizationData.get("AccountManager.deleteMessage.one") : Formatter.format("<HTML>" + LocalizationData.get("AccountManager.deleteMessage.more") + "<BR>" + LocalizationData.get("AccountManager.deleteMessage.confirm") + "</HTML>", nb);
                Object[] options = new Object[]{LocalizationData.get("GenericButton.ok"), LocalizationData.get("GenericButton.cancel")};
                int ok = JOptionPane.showOptionDialog(AccountListPanel.this.getJTable(), mess, LocalizationData.get("AccountManager.deleteMessage.title"), 0, 3, null, options, options[1]);
                boolean bl = confirmed = ok == 0;
            }
            if (confirmed) {
                ((GlobalData)AccountListPanel.this.data).remove(account);
            }
        }
    }
}

