/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.administration;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import net.yapbam.data.PeriodicalTransactionSimulationData;
import net.yapbam.gui.LocalizationData;

public class PeriodicalTransactionDetailedStatPanel
extends JPanel {
    private PeriodicalTransactionSimulationData data;
    private JRadioButton nextMonth;
    private JRadioButton next3months;
    private JRadioButton nextYear;
    private final ButtonGroup buttonGroup = new ButtonGroup();

    public PeriodicalTransactionDetailedStatPanel(PeriodicalTransactionSimulationData data) {
        this.data = data;
        this.initialize();
    }

    private void initialize() {
        this.setBorder(new TitledBorder(LocalizationData.get("PeriodicalTransactionManager.settings.title")));
        GridBagLayout gblWestPanel = new GridBagLayout();
        this.setLayout(gblWestPanel);
        GridBagConstraints gbcNextMonth = new GridBagConstraints();
        gbcNextMonth.anchor = 17;
        gbcNextMonth.insets = new Insets(0, 0, 5, 0);
        gbcNextMonth.gridx = 0;
        gbcNextMonth.gridy = 0;
        this.add((Component)this.getNextMonth(), gbcNextMonth);
        GridBagConstraints gbcNext3months = new GridBagConstraints();
        gbcNext3months.insets = new Insets(0, 0, 5, 0);
        gbcNext3months.anchor = 17;
        gbcNext3months.gridx = 0;
        gbcNext3months.gridy = 1;
        this.add((Component)this.getNext3months(), gbcNext3months);
        GridBagConstraints gbcNextYear = new GridBagConstraints();
        gbcNextYear.anchor = 17;
        gbcNextYear.gridx = 0;
        gbcNextYear.gridy = 2;
        this.add((Component)this.getNextYear(), gbcNextYear);
    }

    JRadioButton getNextMonth() {
        if (this.nextMonth == null) {
            this.nextMonth = new JRadioButton(LocalizationData.get("PeriodicalTransactionManager.settings.nextMonth"));
            this.nextMonth.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (PeriodicalTransactionDetailedStatPanel.this.nextMonth.isSelected()) {
                        PeriodicalTransactionDetailedStatPanel.this.setEndDate(PeriodicalTransactionSimulationData.Unit.MONTH, 1);
                    }
                }
            });
            this.nextMonth.setSelected(true);
            this.buttonGroup.add(this.nextMonth);
        }
        return this.nextMonth;
    }

    JRadioButton getNext3months() {
        if (this.next3months == null) {
            this.next3months = new JRadioButton(LocalizationData.get("PeriodicalTransactionManager.settings.nextQuarter"));
            this.buttonGroup.add(this.next3months);
            this.next3months.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (PeriodicalTransactionDetailedStatPanel.this.next3months.isSelected()) {
                        PeriodicalTransactionDetailedStatPanel.this.setEndDate(PeriodicalTransactionSimulationData.Unit.MONTH, 3);
                    }
                }
            });
        }
        return this.next3months;
    }

    JRadioButton getNextYear() {
        if (this.nextYear == null) {
            this.nextYear = new JRadioButton(LocalizationData.get("PeriodicalTransactionManager.settings.nextYear"));
            this.buttonGroup.add(this.nextYear);
            this.nextYear.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (PeriodicalTransactionDetailedStatPanel.this.nextYear.isSelected()) {
                        PeriodicalTransactionDetailedStatPanel.this.setEndDate(PeriodicalTransactionSimulationData.Unit.YEAR, 1);
                    }
                }
            });
        }
        return this.nextYear;
    }

    private void setEndDate(PeriodicalTransactionSimulationData.Unit unit, int amount) {
        this.data.setEndDate(unit, amount);
    }
}

