/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.archive;

import com.fathzer.jlocal.Formatter;
import com.fathzer.soft.ajlib.swing.table.JTable;
import com.fathzer.soft.ajlib.swing.table.NimbusPatchBooleanTableCellRenderer;
import com.fathzer.soft.ajlib.utilities.NullUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import net.yapbam.data.GlobalData;
import net.yapbam.data.Statement;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.archive.AlertCellRenderer;
import net.yapbam.gui.archive.StatementSelectionTableModel;
import net.yapbam.gui.util.JTableUtils;

public class StatementSelectionPanel
extends JPanel {
    static final String INVALIDITY_CAUSE = "invalidityCause";
    static final String ARCHIVE_MODE = "archiveMode";
    private JLabel lblWhatAccountsDo;
    private JTable table;
    private JScrollPane scrollPane;
    private JPanel panel;
    private JButton allButton;
    private JButton noneButton;
    private GlobalData data;
    private GlobalData archiveData;
    private CharSequence[] alerts;
    private String invalidityCause;
    private JPanel top;
    private JPanel rdbtns;
    private JRadioButton toArchive;
    private JRadioButton fromArchive;
    private final ButtonGroup buttonGroup = new ButtonGroup();

    public StatementSelectionPanel(GlobalData data, GlobalData archiveData, CharSequence[] alerts) {
        this.data = data;
        this.archiveData = archiveData;
        this.alerts = (CharSequence[])alerts.clone();
        this.initialize();
        this.onModeChanged();
    }

    private void onModeChanged() {
        boolean isArchiveMode = this.isArchiveMode();
        ((StatementSelectionTableModel)this.getTable().getModel()).setData(this.getSource(), !isArchiveMode);
        String message = LocalizationData.get(isArchiveMode ? "Archive.statementSelection.helpMessage" : "Archive.statementSelection.restoreHelpMessage");
        StatementSelectionTableModel model = (StatementSelectionTableModel)this.getTable().getModel();
        this.lblWhatAccountsDo.setText(Formatter.format(message, this.getTable().getColumnName(model.getStatementColumn())));
        this.firePropertyChange(ARCHIVE_MODE, !isArchiveMode, isArchiveMode);
    }

    private void initialize() {
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)this.getScrollPane(), "Center");
        this.add((Component)this.getPanel(), "South");
        this.add((Component)this.getTop(), "North");
        this.updateIsValid();
    }

    private JLabel getLblWhatAccountsDo() {
        if (this.lblWhatAccountsDo == null) {
            this.lblWhatAccountsDo = new JLabel();
        }
        return this.lblWhatAccountsDo;
    }

    JTable getTable() {
        if (this.table == null) {
            StatementSelectionTableModel model = new StatementSelectionTableModel(this.data, this.alerts);
            this.table = new JTable();
            this.table.setDefaultRenderer(Icon.class, new AlertCellRenderer());
            this.table.setDefaultRenderer(Boolean.class, new NimbusPatchBooleanTableCellRenderer());
            this.table.setModel(model);
            this.table.getTableHeader().setReorderingAllowed(false);
            JTableUtils.initColumnSizes(this.table, Integer.MAX_VALUE);
            this.table.setPreferredScrollableViewportSize(this.table.getPreferredSize());
            JComboBox fieldsCombo = new JComboBox();
            this.table.setDefaultEditor(Statement.class, new DefaultCellEditor(fieldsCombo){

                @Override
                public Component getTableCellEditorComponent(javax.swing.JTable table, Object value, boolean isSelected, int row, int column) {
                    Statement[] statements;
                    JComboBox combo = (JComboBox)super.getTableCellEditorComponent(table, value, isSelected, row, column);
                    combo.removeAllItems();
                    for (Statement statement : statements = ((StatementSelectionTableModel)table.getModel()).getStatements(row)) {
                        if (statement.getId() == null) continue;
                        combo.addItem(statement);
                    }
                    Object current = table.getModel().getValueAt(row, column);
                    combo.setSelectedItem(current);
                    return combo;
                }
            });
            this.table.setFillsViewportHeight(true);
            model.addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent e) {
                    StatementSelectionPanel.this.updateIsValid();
                }
            });
        }
        return this.table;
    }

    private JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane();
            this.scrollPane.setViewportView(this.getTable());
        }
        return this.scrollPane;
    }

    private JPanel getPanel() {
        if (this.panel == null) {
            this.panel = new JPanel();
            GridBagLayout gblPanel = new GridBagLayout();
            this.panel.setLayout(gblPanel);
            GridBagConstraints gbcAllButton = new GridBagConstraints();
            gbcAllButton.weightx = 1.0;
            gbcAllButton.anchor = 13;
            gbcAllButton.insets = new Insets(0, 0, 0, 5);
            gbcAllButton.gridx = 1;
            gbcAllButton.gridy = 0;
            this.panel.add((Component)this.getAllButton(), gbcAllButton);
            GridBagConstraints gbcNoneButton = new GridBagConstraints();
            gbcNoneButton.anchor = 13;
            gbcNoneButton.gridx = 2;
            gbcNoneButton.gridy = 0;
            this.panel.add((Component)this.getNoneButton(), gbcNoneButton);
            this.panel.setVisible(false);
        }
        return this.panel;
    }

    private JButton getAllButton() {
        if (this.allButton == null) {
            this.allButton = new JButton(LocalizationData.get("Generic.selectAll"));
            this.allButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((StatementSelectionTableModel)StatementSelectionPanel.this.getTable().getModel()).setAllExported(true);
                }
            });
        }
        return this.allButton;
    }

    private JButton getNoneButton() {
        if (this.noneButton == null) {
            this.noneButton = new JButton(LocalizationData.get("Generic.unselectAll"));
            this.noneButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((StatementSelectionTableModel)StatementSelectionPanel.this.getTable().getModel()).setAllExported(false);
                }
            });
        }
        return this.noneButton;
    }

    GlobalData getSource() {
        return this.isArchiveMode() ? this.data : this.archiveData;
    }

    private void updateIsValid() {
        String old = this.invalidityCause;
        this.invalidityCause = LocalizationData.get("Archive.statementSelection.noTransactionSelected");
        for (int i = 0; i < this.getSource().getAccountsNumber(); ++i) {
            if (((StatementSelectionTableModel)this.getTable().getModel()).getSelectedStatements(i).isEmpty()) continue;
            this.invalidityCause = null;
            break;
        }
        if (!NullUtils.areEquals(this.invalidityCause, old)) {
            this.firePropertyChange(INVALIDITY_CAUSE, old, this.invalidityCause);
        }
    }

    String getInvalidityCause() {
        return this.invalidityCause;
    }

    private JPanel getTop() {
        if (this.top == null) {
            this.top = new JPanel();
            this.top.setLayout(new BorderLayout(0, 0));
            this.top.add(this.getLblWhatAccountsDo());
            this.top.add((Component)this.getRdbtns(), "North");
        }
        return this.top;
    }

    private JPanel getRdbtns() {
        if (this.rdbtns == null) {
            this.rdbtns = new JPanel();
            this.rdbtns.setLayout(new BorderLayout(0, 0));
            this.rdbtns.add((Component)this.getToArchive(), "North");
            this.rdbtns.add((Component)this.getFromArchive(), "South");
        }
        return this.rdbtns;
    }

    private JRadioButton getToArchive() {
        if (this.toArchive == null) {
            this.toArchive = new JRadioButton(LocalizationData.get("Archive.menu.name"));
            this.buttonGroup.add(this.toArchive);
            this.toArchive.setToolTipText(LocalizationData.get("Archive.archive.tooltip"));
            this.toArchive.setSelected(true);
            this.toArchive.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    StatementSelectionPanel.this.onModeChanged();
                }
            });
        }
        return this.toArchive;
    }

    private JRadioButton getFromArchive() {
        if (this.fromArchive == null) {
            this.fromArchive = new JRadioButton(LocalizationData.get("Archive.restore.title"));
            this.buttonGroup.add(this.fromArchive);
            this.fromArchive.setToolTipText(LocalizationData.get("Archive.restore.tooltip"));
        }
        return this.fromArchive;
    }

    public boolean isArchiveMode() {
        return this.toArchive.isSelected();
    }
}

