/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.dialogs;

import com.fathzer.soft.ajlib.swing.dialog.AbstractDialog;
import com.fathzer.soft.ajlib.swing.widget.ComboBox;
import com.fathzer.soft.ajlib.swing.widget.TextWidget;
import com.fathzer.soft.ajlib.utilities.NullUtils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import net.yapbam.data.AbstractTransaction;
import net.yapbam.data.Account;
import net.yapbam.data.GlobalData;
import net.yapbam.data.Mode;
import net.yapbam.data.Transaction;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.dialogs.AccountWidget;
import net.yapbam.gui.dialogs.CategoryWidget;
import net.yapbam.gui.dialogs.CommentWidget;
import net.yapbam.gui.dialogs.ModeWidget;
import net.yapbam.gui.dialogs.ModeWidgetParams;
import net.yapbam.gui.dialogs.PredefinedDescriptionComputer;
import net.yapbam.gui.dialogs.SubtransactionListPanel;
import net.yapbam.gui.util.AutoUpdateOkButtonPropertyListener;
import net.yapbam.gui.widget.AutoSelectFocusListener;
import net.yapbam.gui.widget.CurrencyWidget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTransactionDialog<V>
extends AbstractDialog<GlobalData, V> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractTransactionDialog.class);
    private AccountWidget accounts;
    protected TextWidget description;
    protected CommentWidget comment;
    protected CurrencyWidget amount;
    protected JCheckBox receipt;
    protected ModeWidget modes;
    protected CategoryWidget categories;
    protected SubtransactionListPanel subtransactionsPanel;
    private Mode originalMode;
    private boolean originalIsExpense;
    private PredefinedDescriptionComputer pdc = null;
    protected boolean ignoreEvents = false;

    protected AbstractTransactionDialog(Window owner, String title, GlobalData data, AbstractTransaction transaction) {
        super(owner, title, data);
        if (transaction != null) {
            this.setContent(transaction);
        }
    }

    protected void setPredefinedDescriptionComputer(PredefinedDescriptionComputer pdc) {
        this.pdc = pdc;
        if (pdc != null) {
            this.description.setPredefined(pdc.getPredefined(), pdc.getUnsortedSize());
        }
    }

    protected void setContent(AbstractTransaction transaction) {
        this.ignoreEvents = true;
        this.accounts.set(transaction.getAccount());
        this.description.setText(transaction.getDescription());
        this.comment.setText(transaction.getComment());
        this.amount.setValue(Math.abs(transaction.getAmount()));
        this.originalIsExpense = transaction.getAmount() <= 0.0;
        this.receipt.setSelected(!this.originalIsExpense);
        this.originalMode = transaction.getMode();
        this.buildModes(this.originalIsExpense);
        this.modes.set(transaction.getMode());
        this.categories.set(transaction.getCategory());
        this.subtransactionsPanel.fill(transaction);
        this.ignoreEvents = false;
    }

    protected void setMode(Mode mode) {
        Account account = this.getAccount();
        int index = account.indexOf(mode);
        if (index >= 0) {
            this.modes.set(mode);
        }
    }

    protected Account getAccount() {
        return (Account)this.accounts.get();
    }

    protected double getAmount() {
        double amount;
        double d = amount = this.amount.getValue() != null ? Math.abs(this.amount.getValue()) : 0.0;
        if (amount == 0.0) {
            amount = Double.MIN_VALUE;
        }
        if (!this.receipt.isSelected()) {
            amount = -amount;
        }
        return amount;
    }

    protected boolean isExpense() {
        return this.getAmount() < 0.0;
    }

    @Override
    protected JPanel createCenterPane() {
        JPanel centerPane = new JPanel(new GridBagLayout());
        Insets insets = new Insets(5, 5, 5, 5);
        GridBagConstraints c = new GridBagConstraints();
        c.insets = insets;
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.gridwidth = 0;
        c.fill = 2;
        c.weightx = 1.0;
        this.accounts = new AccountWidget((GlobalData)this.data);
        AccountsListener accountListener = new AccountsListener();
        this.accounts.addPropertyChangeListener("account", accountListener);
        this.accounts.setToolTipText(LocalizationData.get("TransactionDialog.account.tooltip"));
        centerPane.add((Component)this.accounts, c);
        JPanel panel = new JPanel(new GridBagLayout());
        c.gridy = 1;
        c.insets = new Insets(0, 0, 0, 0);
        centerPane.add((Component)panel, c);
        JLabel titleLibelle = new JLabel(LocalizationData.get("TransactionDialog.description"));
        c = new GridBagConstraints();
        c.insets = insets;
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.weightx = 0.0;
        panel.add((Component)titleLibelle, c);
        this.description = new TextWidget();
        this.description.setToolTipText(LocalizationData.get("TransactionDialog.description.tooltip"));
        this.description.addPropertyChangeListener("PREDEFINED_VALUE", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() != null) {
                    AbstractTransactionDialog.this.predefinedDescriptionSelected((String)evt.getNewValue());
                }
            }
        });
        this.description.addFocusListener(AutoSelectFocusListener.INSTANCE);
        c.gridx = 1;
        c.fill = 2;
        c.weightx = 1.0;
        panel.add((Component)this.description, c);
        this.comment = new CommentWidget();
        c.gridx = 2;
        panel.add((Component)this.comment, c);
        c = new GridBagConstraints();
        c.insets = insets;
        c.gridx = 0;
        c.gridy = 2;
        c.anchor = 17;
        this.buildDateField(centerPane, AutoSelectFocusListener.INSTANCE, c);
        c.fill = 0;
        c.anchor = 17;
        c.weightx = 0.0;
        centerPane.add((Component)new JLabel(LocalizationData.get("TransactionDialog.amount")), c);
        this.amount = new CurrencyWidget(LocalizationData.getLocale());
        this.amount.setColumns(10);
        this.amount.addFocusListener(AutoSelectFocusListener.INSTANCE);
        this.amount.addPropertyChangeListener("value", new AutoUpdateOkButtonPropertyListener(this));
        this.amount.setToolTipText(LocalizationData.get("TransactionDialog.amount.tooltip"));
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        centerPane.add((Component)this.amount, c);
        this.receipt = new JCheckBox(LocalizationData.get("TransactionDialog.receipt"));
        this.receipt.setToolTipText(LocalizationData.get("TransactionDialog.receipt.tooltip"));
        this.receipt.addItemListener(new ReceiptListener());
        ++c.gridx;
        c.weightx = 1.0;
        c.anchor = 17;
        c.gridwidth = 0;
        centerPane.add((Component)this.receipt, c);
        c = new GridBagConstraints();
        c.insets = insets;
        c.gridx = 0;
        c.gridy = 3;
        c.anchor = 17;
        centerPane.add((Component)new JLabel(LocalizationData.get("TransactionDialog.mode")), c);
        this.modes = new ModeWidget(new ModeWidgetParams((GlobalData)this.data, this.getAccount(), true));
        this.modes.getJLabel().setVisible(false);
        this.buildModes(!this.receipt.isSelected());
        ModesListener modeListener = new ModesListener();
        this.modes.addPropertyChangeListener("mode", modeListener);
        this.modes.setToolTipText(LocalizationData.get("TransactionDialog.mode.tooltip"));
        c.gridx = 1;
        c.weightx = 1.0;
        c.fill = 2;
        centerPane.add((Component)this.modes, c);
        c.gridx = 2;
        this.buildNumberField(centerPane, AutoSelectFocusListener.INSTANCE, c);
        this.categories = new CategoryWidget((GlobalData)this.data);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        centerPane.add((Component)this.categories, c);
        c = new GridBagConstraints();
        c.insets = insets;
        c.gridx = 0;
        c.gridy = 5;
        c.anchor = 17;
        this.buildStatementFields(centerPane, AutoSelectFocusListener.INSTANCE, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 0;
        c.fill = 2;
        centerPane.add((Component)new JSeparator(0), c);
        c.insets = insets;
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.subtransactionsPanel = new SubtransactionListPanel((GlobalData)this.data);
        this.subtransactionsPanel.addPropertyChangeListener("sum", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (!AbstractTransactionDialog.this.ignoreEvents && AbstractTransactionDialog.this.amount.getValue() != null && AbstractTransactionDialog.this.subtransactionsPanel.isAddToTransactionSelected()) {
                    double newValue;
                    double diff = (Double)evt.getNewValue() - (Double)evt.getOldValue();
                    if (AbstractTransactionDialog.this.isExpense()) {
                        diff = -diff;
                    }
                    if ((newValue = AbstractTransactionDialog.this.amount.getValue() + diff) < 0.0) {
                        newValue = -newValue;
                        AbstractTransactionDialog.this.receipt.setSelected(!AbstractTransactionDialog.this.receipt.isSelected());
                    }
                    AbstractTransactionDialog.this.amount.setValue(newValue);
                }
            }
        });
        centerPane.add((Component)this.subtransactionsPanel, c);
        this.amount.setValue(0.0);
        return centerPane;
    }

    protected void predefinedDescriptionSelected(String description) {
    }

    protected abstract void buildStatementFields(JPanel var1, FocusListener var2, GridBagConstraints var3);

    protected abstract void buildNumberField(JPanel var1, FocusListener var2, GridBagConstraints var3);

    protected abstract void buildDateField(JPanel var1, FocusListener var2, GridBagConstraints var3);

    private void buildModes(boolean expense) {
        Mode current = (Mode)this.modes.get();
        this.modes.setParameters(new ModeWidgetParams((GlobalData)this.data, this.getAccount(), expense));
        ComboBox combo = this.modes.getCombo();
        combo.setActionEnabled(false);
        if (this.originalMode != null && this.originalIsExpense == expense && !combo.contains(this.originalMode) && this.getAccount().indexOf(this.originalMode) >= 0) {
            combo.addItem(this.originalMode);
        }
        this.modes.set(null);
        combo.setActionEnabled(true);
        if (current != null && combo.contains(current)) {
            this.modes.set(current);
        } else {
            combo.setSelectedIndex(0);
        }
    }

    public AbstractTransaction getTransaction() {
        return (Transaction)super.getResult();
    }

    protected Mode getCurrentMode() {
        return (Mode)this.modes.get();
    }

    protected void optionnalUpdatesOnModeChange() {
    }

    @Override
    protected String getOkDisabledCause() {
        if (this.amount.getValue() == null) {
            return LocalizationData.get("TransactionDialog.bad.amount");
        }
        return null;
    }

    @Override
    public void setVisible(boolean visible) {
        String prefix = this.getClass().getCanonicalName();
        int max = 65;
        if (prefix.length() > max) {
            prefix = prefix.substring(prefix.length() - max);
        }
        if (visible) {
            this.subtransactionsPanel.restoreState(prefix);
        } else {
            this.subtransactionsPanel.saveState(prefix);
        }
        super.setVisible(visible);
    }

    class ModesListener
    implements PropertyChangeListener {
        private Object lastSelected = null;
        private boolean lastWasExpense = true;

        ModesListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Mode selected = (Mode)AbstractTransactionDialog.this.modes.get();
            if (!(AbstractTransactionDialog.this.ignoreEvents || NullUtils.areEquals(this.lastSelected, selected) && AbstractTransactionDialog.this.isExpense() == this.lastWasExpense)) {
                LOGGER.trace("Mode {} is selected", (Object)selected);
                AbstractTransactionDialog.this.optionnalUpdatesOnModeChange();
            }
            this.lastSelected = selected;
            this.lastWasExpense = AbstractTransactionDialog.this.isExpense();
        }
    }

    class ReceiptListener
    implements ItemListener {
        ReceiptListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (!AbstractTransactionDialog.this.ignoreEvents) {
                AbstractTransactionDialog.this.buildModes(e.getStateChange() == 2);
            }
        }
    }

    class AccountsListener
    implements PropertyChangeListener {
        AccountsListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!AbstractTransactionDialog.this.ignoreEvents) {
                LOGGER.trace("Account {} is selected", (Object)AbstractTransactionDialog.this.getAccount());
                AbstractTransactionDialog.this.buildModes(AbstractTransactionDialog.this.isExpense());
                if (AbstractTransactionDialog.this.pdc != null) {
                    AbstractTransactionDialog.this.description.setPredefined(AbstractTransactionDialog.this.pdc.getPredefined(), AbstractTransactionDialog.this.pdc.getUnsortedSize());
                }
            }
        }
    }
}

