/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.dialogs;

import com.fathzer.soft.ajlib.swing.Utils;
import net.yapbam.data.Account;
import net.yapbam.data.GlobalData;
import net.yapbam.data.comparator.AccountComparator;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.dialogs.EditAccountDialog;
import net.yapbam.gui.widget.AbstractSelector;

public class AccountWidget
extends AbstractSelector<Account, GlobalData> {
    private static final long serialVersionUID = 1L;
    public static final String ACCOUNT_PROPERTY = "account";

    public AccountWidget(GlobalData data) {
        super(data);
    }

    @Override
    protected String getLabel() {
        return LocalizationData.get("AccountDialog.account");
    }

    @Override
    protected String getNewButtonTip() {
        return LocalizationData.get("TransactionDialog.account.new.tooltip");
    }

    @Override
    protected String getPropertyName() {
        return ACCOUNT_PROPERTY;
    }

    @Override
    protected void populateCombo() {
        if (this.getParameters() != null) {
            Account[] accounts = AccountComparator.getSortedAccounts((GlobalData)this.getParameters(), this.getLocale());
            for (int i = 0; i < accounts.length; ++i) {
                this.getCombo().addItem(accounts[i]);
            }
        }
    }

    @Override
    protected Object getDefaultRenderedValue(Account account) {
        return account == null ? account : account.getName();
    }

    @Override
    protected Account createNew() {
        if (this.getParameters() != null) {
            return EditAccountDialog.open((GlobalData)this.getParameters(), Utils.getOwnerWindow(this), null);
        }
        return null;
    }
}

