/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.dialogs;

import com.fathzer.soft.ajlib.swing.dialog.AbstractDialog;
import java.awt.Window;
import javax.swing.JPanel;
import net.yapbam.data.Account;
import net.yapbam.data.GlobalData;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.dialogs.EditAccountPanel;
import net.yapbam.gui.util.AutoUpdateOkButtonPropertyListener;

public class EditAccountDialog
extends AbstractDialog<GlobalData, Account> {
    private EditAccountPanel editAccountPanel;

    public EditAccountDialog(Window owner, String title, GlobalData data) {
        super(owner, title, data);
    }

    public void setAccountIndex(int accountIndex) {
        this.editAccountPanel.setAccount(accountIndex);
        this.pack();
    }

    public void setMessage(String message) {
        this.editAccountPanel.setMessage(message);
        this.pack();
    }

    @Override
    protected JPanel createCenterPane() {
        this.editAccountPanel = new EditAccountPanel((GlobalData)this.data);
        this.editAccountPanel.addPropertyChangeListener("okDisabled", new AutoUpdateOkButtonPropertyListener(this));
        return this.editAccountPanel;
    }

    @Override
    protected Account buildResult() {
        return this.editAccountPanel.getAccount();
    }

    @Override
    protected String getOkDisabledCause() {
        return this.editAccountPanel.getOkDisabledCause();
    }

    public static Account open(GlobalData data, Window owner, String message) {
        EditAccountDialog dialog = new EditAccountDialog(owner, LocalizationData.get("AccountDialog.title.new"), data);
        if (message != null) {
            dialog.setMessage(message);
            dialog.setLocationRelativeTo(owner);
        }
        dialog.setVisible(true);
        Account newAccount = (Account)dialog.getResult();
        if (newAccount != null) {
            data.add(newAccount);
        }
        return newAccount;
    }

    public static void edit(GlobalData data, Window owner, Account account) {
        EditAccountDialog dialog = new EditAccountDialog(owner, LocalizationData.get("AccountDialog.title.edit"), data);
        dialog.setAccountIndex(data.indexOf(account));
        dialog.setLocationRelativeTo(dialog.getOwner());
        dialog.setVisible(true);
        Account result = (Account)dialog.getResult();
        if (result != null) {
            if (!result.getName().equals(account.getName())) {
                data.setName(account, result.getName());
            }
            if (result.getInitialBalance() != account.getInitialBalance()) {
                data.setInitialBalance(account, result.getInitialBalance());
            }
            if (!result.getAlertThreshold().equals(account.getAlertThreshold())) {
                data.setAlertThreshold(account, result.getAlertThreshold());
            }
            data.setComment(account, result.getComment());
        }
    }
}

