/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.UIManager;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.widget.BasicDocumentListener;

public class GetPasswordPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final String CONFIRMED_PROPERTY = "Confirmed";
    private JLabel jLabel = null;
    private JPasswordField passwordField = null;
    private JCheckBox showPassword = null;
    private JPanel jPanel = null;
    private JLabel jLabel1 = null;
    private JPanel warningPanel = null;
    private JLabel warningField = null;
    private JLabel jLabel2 = null;
    private JPasswordField confirmPasswordField = null;
    private boolean confirmed = false;

    public GetPasswordPanel() {
        this.initialize();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.insets = new Insets(15, 5, 5, 5);
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.gridy = 4;
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.gridx = 0;
        gridBagConstraints11.fill = 2;
        gridBagConstraints11.gridy = 3;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        gridBagConstraints.gridy = 0;
        this.jLabel = new JLabel();
        this.setSize(447, 198);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.jLabel, gridBagConstraints);
        this.add((Component)this.getJPanel(), gridBagConstraints11);
        this.add((Component)this.getWarningPanel(), gridBagConstraints2);
    }

    private JPasswordField getPasswordField() {
        if (this.passwordField == null) {
            this.passwordField = new JPasswordField();
            this.passwordField.setColumns(10);
            this.passwordField.setColumns(8);
            this.passwordField.getDocument().addDocumentListener(new BasicDocumentListener(){

                @Override
                protected void modified() {
                    GetPasswordPanel.this.updateConfirmed();
                }
            });
        }
        return this.passwordField;
    }

    private JCheckBox getShowPassword() {
        if (this.showPassword == null) {
            this.showPassword = new JCheckBox();
            this.showPassword.setFocusable(false);
            this.showPassword.setText(LocalizationData.get("PreferencesDialog.Network.showPassword"));
            this.showPassword.setToolTipText(LocalizationData.get("PreferencesDialog.Network.showPassword.toolTip"));
            this.showPassword.addItemListener(new ItemListener(){
                char oldEcho;

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 2) {
                        GetPasswordPanel.this.passwordField.setEchoChar(this.oldEcho);
                        GetPasswordPanel.this.confirmPasswordField.setEchoChar(this.oldEcho);
                    } else {
                        this.oldEcho = GetPasswordPanel.this.passwordField.getEchoChar();
                        GetPasswordPanel.this.passwordField.setEchoChar('\u0000');
                        GetPasswordPanel.this.confirmPasswordField.setEchoChar('\u0000');
                    }
                }
            });
        }
        return this.showPassword;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.fill = 2;
            gridBagConstraints7.gridy = 1;
            gridBagConstraints7.weightx = 1.0;
            gridBagConstraints7.insets = new Insets(0, 5, 0, 0);
            gridBagConstraints7.gridx = 1;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.insets = new Insets(0, 5, 0, 0);
            gridBagConstraints6.fill = 2;
            gridBagConstraints6.gridy = 1;
            this.jLabel2 = new JLabel();
            this.jLabel2.setText(LocalizationData.get("FilePasswordDialog.confirm"));
            this.jLabel2.setVisible(false);
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.insets = new Insets(0, 5, 0, 0);
            gridBagConstraints1.fill = 2;
            gridBagConstraints1.gridy = 0;
            this.jLabel1 = new JLabel();
            this.jLabel1.setText(LocalizationData.get("PreferencesDialog.Network.password"));
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 2;
            gridBagConstraints4.insets = new Insets(0, 5, 0, 0);
            gridBagConstraints4.gridheight = 2;
            gridBagConstraints4.gridy = 0;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.gridx = 1;
            gridBagConstraints3.gridy = 0;
            gridBagConstraints3.insets = new Insets(0, 5, 5, 0);
            gridBagConstraints3.weightx = 1.0;
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
            this.jPanel.add((Component)this.getPasswordField(), gridBagConstraints3);
            this.jPanel.add((Component)this.getShowPassword(), gridBagConstraints4);
            this.jPanel.add((Component)this.jLabel1, gridBagConstraints1);
            this.jPanel.add((Component)this.jLabel2, gridBagConstraints6);
            this.jPanel.add((Component)this.getConfirmPasswordField(), gridBagConstraints7);
        }
        return this.jPanel;
    }

    public String getPassword() {
        return new String(this.passwordField.getPassword());
    }

    public void setPassword(String password) {
        this.passwordField.setText(password);
        this.updateConfirmed();
    }

    private JPanel getWarningPanel() {
        if (this.warningPanel == null) {
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.fill = 1;
            gridBagConstraints5.weightx = 0.0;
            gridBagConstraints5.weighty = 1.0;
            gridBagConstraints5.anchor = 18;
            gridBagConstraints5.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints5.gridy = 0;
            this.warningField = new JLabel();
            this.warningField.setIcon(UIManager.getIcon("OptionPane.warningIcon"));
            this.warningField.setVerticalAlignment(1);
            this.warningPanel = new JPanel();
            this.warningPanel.setLayout(new GridBagLayout());
            this.warningPanel.setBorder(BorderFactory.createLineBorder(Color.gray, 1));
            this.warningPanel.setVisible(false);
            this.warningPanel.add((Component)this.warningField, gridBagConstraints5);
        }
        return this.warningPanel;
    }

    public void setConfirmIsVisible(boolean visible) {
        this.jLabel2.setVisible(visible);
        this.confirmPasswordField.setVisible(visible);
        this.updateConfirmed();
    }

    public void setWarningMessage(String message) {
        if (message != null) {
            this.warningField.setText(message);
        }
        this.getWarningPanel().setVisible(message != null);
    }

    public void setQuestion(String question) {
        this.jLabel.setText(question);
    }

    public void setIcon(Icon icon) {
        this.jLabel.setIcon(icon);
    }

    public void setPasswordFieldToolTipText(String tooltip) {
        this.getPasswordField().setToolTipText(tooltip);
    }

    private JPasswordField getConfirmPasswordField() {
        if (this.confirmPasswordField == null) {
            this.confirmPasswordField = new JPasswordField();
            this.confirmPasswordField.setToolTipText(LocalizationData.get("FilePasswordDialog.confirm.tooltip"));
            this.confirmPasswordField.setVisible(false);
            this.confirmPasswordField.getDocument().addDocumentListener(new BasicDocumentListener(){

                @Override
                protected void modified() {
                    GetPasswordPanel.this.updateConfirmed();
                }
            });
        }
        return this.confirmPasswordField;
    }

    private void updateConfirmed() {
        boolean old = this.confirmed;
        this.confirmed = this.getConfirmPasswordField().isVisible() && this.passwordField.getPassword().length != 0 ? new String(this.passwordField.getPassword()).equals(new String(this.confirmPasswordField.getPassword())) : true;
        if (old != this.confirmed) {
            this.firePropertyChange(CONFIRMED_PROPERTY, old, this.confirmed);
        }
    }

    public boolean isPasswordConfirmed() {
        return this.confirmed;
    }
}

