/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.dialogs;

import com.fathzer.soft.ajlib.swing.dialog.FileChooser;
import com.fathzer.soft.ajlib.swing.widget.TextWidget;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.yapbam.gui.HelpManager;
import net.yapbam.gui.LocalizationData;
import net.yapbam.util.HtmlUtils;

class LinkEditPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JLabel textLabel;
    private TextWidget textField;
    private JLabel urlLabel;
    private TextWidget urlField;
    private JButton fileButton;
    private JButton testButton;

    LinkEditPanel(String[] data) {
        this.initialize();
        this.getUrlField().addPropertyChangeListener("text", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                LinkEditPanel.this.updateTestButton();
            }
        });
        if (data != null) {
            this.getTextField().setText(data[0]);
            if (data[1] != null) {
                this.getUrlField().setText(data[1]);
            }
        }
    }

    private void initialize() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gbcTextLabel = new GridBagConstraints();
        gbcTextLabel.anchor = 17;
        gbcTextLabel.insets = new Insets(0, 0, 5, 5);
        gbcTextLabel.gridx = 0;
        gbcTextLabel.gridy = 0;
        this.add((Component)this.getTextLabel(), gbcTextLabel);
        GridBagConstraints gbcTextField = new GridBagConstraints();
        gbcTextField.gridwidth = 0;
        gbcTextField.weightx = 1.0;
        gbcTextField.insets = new Insets(0, 0, 5, 5);
        gbcTextField.fill = 2;
        gbcTextField.gridx = 1;
        gbcTextField.gridy = 0;
        this.add((Component)this.getTextField(), gbcTextField);
        GridBagConstraints gbcTestButton = new GridBagConstraints();
        gbcTestButton.insets = new Insets(0, 0, 5, 0);
        gbcTestButton.gridx = 3;
        gbcTestButton.gridy = 1;
        this.add((Component)this.getTestButton(), gbcTestButton);
        GridBagConstraints gbcUrlLabel = new GridBagConstraints();
        gbcUrlLabel.anchor = 17;
        gbcUrlLabel.insets = new Insets(0, 0, 5, 5);
        gbcUrlLabel.gridx = 0;
        gbcUrlLabel.gridy = 1;
        this.add((Component)this.getUrlLabel(), gbcUrlLabel);
        GridBagConstraints gbcUrlField = new GridBagConstraints();
        gbcUrlField.insets = new Insets(0, 0, 5, 5);
        gbcUrlField.weightx = 1.0;
        gbcUrlField.fill = 2;
        gbcUrlField.gridx = 1;
        gbcUrlField.gridy = 1;
        this.add((Component)this.getUrlField(), gbcUrlField);
        GridBagConstraints gbcFileButton = new GridBagConstraints();
        gbcFileButton.insets = new Insets(0, 0, 5, 5);
        gbcFileButton.gridx = 2;
        gbcFileButton.gridy = 1;
        this.add((Component)this.getFileButton(), gbcFileButton);
    }

    private JLabel getTextLabel() {
        if (this.textLabel == null) {
            this.textLabel = new JLabel(LocalizationData.get("LinkEditor.text"));
        }
        return this.textLabel;
    }

    TextWidget getTextField() {
        if (this.textField == null) {
            this.textField = new TextWidget();
            this.textField.setToolTipText(LocalizationData.get("LinkEditor.text.tooltip"));
            this.textField.setColumns(10);
        }
        return this.textField;
    }

    private JLabel getUrlLabel() {
        if (this.urlLabel == null) {
            this.urlLabel = new JLabel(LocalizationData.get("LinkEditor.url"));
        }
        return this.urlLabel;
    }

    TextWidget getUrlField() {
        if (this.urlField == null) {
            this.urlField = new TextWidget(30);
            this.urlField.setToolTipText(LocalizationData.get("LinkEditor.url.tooltip"));
        }
        return this.urlField;
    }

    private JButton getFileButton() {
        if (this.fileButton == null) {
            this.fileButton = new JButton(LocalizationData.get("LinkEditor.file"));
            this.fileButton.setToolTipText(LocalizationData.get("LinkEditor.file.tooltip"));
            this.fileButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FileChooser chooser = new FileChooser();
                    chooser.setSelectedFile(LinkEditPanel.this.getFileURL());
                    if (chooser.showOpenDialog(LinkEditPanel.this.getFileButton()) == 0) {
                        File file = chooser.getSelectedFile();
                        try {
                            LinkEditPanel.this.getUrlField().setText(file.toURI().toURL().toString());
                        }
                        catch (MalformedURLException e1) {
                            throw new RuntimeException(e1);
                        }
                    }
                }
            });
        }
        return this.fileButton;
    }

    private File getFileURL() {
        if (!this.getUrlField().getText().isEmpty()) {
            try {
                URL url = new URL(this.getUrlField().getText());
                if ("file".equalsIgnoreCase(url.getProtocol())) {
                    return new File(url.getFile());
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    private JButton getTestButton() {
        if (this.testButton == null) {
            this.testButton = new JButton(LocalizationData.get("LinkEditor.test"));
            this.updateTestButton();
            this.testButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        HelpManager.show((Component)LinkEditPanel.this.getTestButton(), new URI(LinkEditPanel.this.getUrlField().getText()));
                    }
                    catch (URISyntaxException e1) {
                        throw new RuntimeException(e1);
                    }
                }
            });
        }
        return this.testButton;
    }

    boolean isURLOk() {
        return this.getUrlField().getText().isEmpty() || HtmlUtils.isValidURL(this.getUrlField().getText());
    }

    public void updateTestButton() {
        boolean ok = !this.getUrlField().getText().isEmpty() && this.isURLOk();
        this.getTestButton().setEnabled(ok);
        this.getTestButton().setToolTipText(ok ? LocalizationData.get("LinkEditor.test.tooltip") : LocalizationData.get("LinkEditor.incorrectURL"));
    }
}

