/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.dialogs;

import com.fathzer.jlocal.Formatter;
import com.fathzer.soft.ajlib.swing.dialog.AbstractDialog;
import com.fathzer.soft.ajlib.swing.widget.TextWidget;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.yapbam.data.Account;
import net.yapbam.data.GlobalData;
import net.yapbam.data.Mode;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.dialogs.ModePanel;
import net.yapbam.gui.util.AutoUpdateOkButtonPropertyListener;
import net.yapbam.gui.widget.AutoSelectFocusListener;

public class ModeDialog
extends AbstractDialog<Account, Mode> {
    private static final long serialVersionUID = 1L;
    private static final boolean DEBUG = false;
    private TextWidget name;
    private ModePanel leftPane;
    private ModePanel rightPane;
    private Mode original = null;

    public ModeDialog(Window owner, Account account) {
        super(owner, LocalizationData.get("ModeDialog.title.new"), account);
    }

    @Override
    protected JPanel createCenterPane() {
        JPanel centerPane = new JPanel(new BorderLayout());
        centerPane.add((Component)new JLabel(Formatter.format(LocalizationData.get("ModeDialog.account"), ((Account)this.data).getName())), "North");
        JPanel main = new JPanel(new GridBagLayout());
        centerPane.add((Component)main, "Center");
        JPanel idPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(10, 5, 5, 5);
        c.anchor = 17;
        idPanel.add((Component)new JLabel(LocalizationData.get("ModeDialog.name")), c);
        c.gridx = 1;
        c.weightx = 1.0;
        c.fill = 2;
        AutoUpdateOkButtonPropertyListener listener = new AutoUpdateOkButtonPropertyListener(this);
        this.name = new TextWidget(10);
        this.name.addPropertyChangeListener("text", listener);
        this.name.addFocusListener(AutoSelectFocusListener.INSTANCE);
        idPanel.add((Component)this.name, c);
        this.leftPane = new ModePanel(LocalizationData.get("ModeDialog.forDebts"), true);
        this.rightPane = new ModePanel(LocalizationData.get("ModeDialog.forReceipts"), false);
        this.leftPane.addPropertyChangeListener("IS_SELECTED", listener);
        this.rightPane.addPropertyChangeListener("IS_SELECTED", listener);
        this.leftPane.addPropertyChangeListener("IS_VALID", listener);
        this.rightPane.addPropertyChangeListener("IS_VALID", listener);
        c = new GridBagConstraints();
        c.fill = 2;
        c.gridwidth = 0;
        main.add((Component)idPanel, c);
        c = new GridBagConstraints();
        c.gridy = 1;
        c.anchor = 11;
        c.insets = new Insets(0, 0, 0, 5);
        main.add((Component)this.leftPane, c);
        c.gridx = 1;
        c.insets = new Insets(0, 5, 0, 0);
        main.add((Component)this.rightPane, c);
        return centerPane;
    }

    @Override
    protected Mode buildResult() {
        return new Mode(this.name.getText(), this.rightPane.getValueDateComputer(), this.leftPane.getValueDateComputer(), this.leftPane.isCheckBookSelected());
    }

    public static Mode open(GlobalData data, Account account, Window owner) {
        ModeDialog dialog = new ModeDialog(owner, account);
        dialog.setVisible(true);
        Mode newMode = (Mode)dialog.getResult();
        if (newMode != null) {
            data.add(account, newMode);
        }
        return newMode;
    }

    @Override
    protected String getOkDisabledCause() {
        String name = this.name.getText().trim();
        Account account = (Account)this.data;
        if (name.length() == 0) {
            return LocalizationData.get("ModeDialog.bad.emptyName");
        }
        if (!(account.getMode(name) == null || this.original != null && name.equals(this.original.getName()))) {
            return Formatter.format(LocalizationData.get("ModeDialog.bad.duplicateMode"), name, account.getName());
        }
        if (!this.leftPane.isSelected() && !this.rightPane.isSelected()) {
            return LocalizationData.get("ModeDialog.bad.neverAvalaible");
        }
        if (this.leftPane.isSelected() && !this.leftPane.hasValidContent()) {
            return LocalizationData.get("ModeDialog.bad.debt");
        }
        if (this.rightPane.isSelected() && !this.rightPane.hasValidContent()) {
            return LocalizationData.get("ModeDialog.bad.receipt");
        }
        return null;
    }

    public void setContent(Mode mode) {
        this.setTitle(LocalizationData.get("ModeDialog.title.edit"));
        this.original = mode;
        this.name.setText(mode.getName());
        this.leftPane.setContent(mode.getExpenseVdc());
        this.leftPane.setCheckBookSelected(mode.isUseCheckBook());
        this.rightPane.setContent(mode.getReceiptVdc());
        this.updateOkButtonEnabled();
    }
}

