/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.dialogs;

import com.fathzer.jlocal.Formatter;
import com.fathzer.soft.ajlib.swing.Utils;
import com.fathzer.soft.ajlib.swing.table.RowSorter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.yapbam.data.AbstractTransaction;
import net.yapbam.data.GlobalData;
import net.yapbam.data.SubTransaction;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.YapbamState;
import net.yapbam.gui.dialogs.PredefinedDescriptionComputer;
import net.yapbam.gui.dialogs.SubTransactionDialog;
import net.yapbam.gui.dialogs.SubTransactionPanel;
import net.yapbam.gui.dialogs.SubTransactionsTable;
import net.yapbam.gui.dialogs.SubTransactionsTableModel;
import net.yapbam.gui.transactiontable.AmountRenderer;
import net.yapbam.gui.transactiontable.ObjectRenderer;

public class SubtransactionListPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final String SUM_PROPERTY = "sum";
    private SubTransactionsTableModel tableModel;
    private JButton delete;
    private JButton edit;
    private JTable table;
    private JCheckBox addToTransaction;
    private double sum;
    private JLabel sumLabel;
    private GlobalData data;
    private PredefinedDescriptionComputer predefinedDescriptionComputer;
    private SubTransactionPanel.PredefinedDescriptionUpdater updater;

    public SubtransactionListPanel(GlobalData data) {
        super(new BorderLayout());
        this.data = data;
        this.sum = 0.0;
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.GRAY), LocalizationData.get("TransactionDialog.SubPanel.title")));
        JPanel pane = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.anchor = 17;
        this.addToTransaction = new JCheckBox(LocalizationData.get("TransactionDialog.SubPanel.add"));
        this.addToTransaction.setSelected(true);
        this.addToTransaction.setToolTipText(LocalizationData.get("TransactionDialog.SubPanel.add.tooltip"));
        pane.add((Component)this.addToTransaction, c);
        GridBagConstraints c2 = new GridBagConstraints();
        c2.gridx = 1;
        c2.weightx = 1.0;
        c2.anchor = 13;
        this.sumLabel = new JLabel();
        pane.add((Component)this.sumLabel, c2);
        this.add((Component)pane, "North");
        this.tableModel = new SubTransactionsTableModel();
        this.table = new SubTransactionsTable(this.tableModel);
        this.table.setRowSorter(new RowSorter<SubTransactionsTableModel>(this.tableModel));
        ListSelectionModel selModel = this.table.getSelectionModel();
        selModel.setSelectionMode(0);
        selModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ListSelectionModel m = (ListSelectionModel)e.getSource();
                if (!e.getValueIsAdjusting()) {
                    boolean ok = m.getMinSelectionIndex() >= 0;
                    SubtransactionListPanel.this.delete.setEnabled(ok);
                    SubtransactionListPanel.this.edit.setEnabled(ok);
                }
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    Point p = e.getPoint();
                    int row = SubtransactionListPanel.this.table.rowAtPoint(p);
                    if (row >= 0) {
                        SubtransactionListPanel.this.editSelected(SubtransactionListPanel.this.data);
                    }
                }
            }
        });
        this.table.setDefaultRenderer(double[].class, new AmountRenderer());
        this.table.setDefaultRenderer(Object.class, new ObjectRenderer());
        this.table.setPreferredScrollableViewportSize(new Dimension(1, this.table.getRowHeight() * 6));
        JScrollPane scrollPane = new JScrollPane(this.table, 22, 31);
        this.add((Component)scrollPane, "Center");
        JPanel buttonsPanel = new JPanel();
        JButton newSubTransactionButton = new JButton(LocalizationData.get("TransactionDialog.SubPanel.new"));
        newSubTransactionButton.setToolTipText(LocalizationData.get("TransactionDialog.SubPanel.new.tooltip"));
        newSubTransactionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SubtransactionListPanel.this.create(SubtransactionListPanel.this.data);
            }
        });
        this.delete = new JButton(LocalizationData.get("TransactionDialog.SubPanel.delete"));
        this.delete.setToolTipText(LocalizationData.get("TransactionDialog.SubPanel.delete.tooltip"));
        this.delete.setEnabled(false);
        this.delete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SubtransactionListPanel.this.deleteSelected();
            }
        });
        this.edit = new JButton(LocalizationData.get("TransactionDialog.SubPanel.modify"));
        this.edit.setToolTipText(LocalizationData.get("TransactionDialog.SubPanel.modify.tooltip"));
        this.edit.setEnabled(false);
        this.edit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SubtransactionListPanel.this.editSelected(SubtransactionListPanel.this.data);
            }
        });
        buttonsPanel.add(newSubTransactionButton);
        buttonsPanel.add(this.edit);
        buttonsPanel.add(this.delete);
        this.add((Component)buttonsPanel, "South");
        this.addPropertyChangeListener(SUM_PROPERTY, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (SubtransactionListPanel.this.getSubtransactionsCount() == 0) {
                    SubtransactionListPanel.this.sumLabel.setText("");
                } else {
                    SubtransactionListPanel.this.sumLabel.setText(Formatter.format(LocalizationData.get("TransactionDialog.SubPanel.total"), evt.getNewValue()));
                }
            }
        });
    }

    public void fill(AbstractTransaction transaction) {
        double oldValue = this.sum;
        this.tableModel.fill(transaction);
        this.sum = 0.0;
        for (int i = 0; i < transaction.getSubTransactionSize(); ++i) {
            this.sum += transaction.getSubTransaction(i).getAmount();
        }
        this.firePropertyChange(SUM_PROPERTY, oldValue, this.sum);
    }

    public int getSubtransactionsCount() {
        return this.tableModel.getRowCount();
    }

    public SubTransaction getSubtransaction(int i) {
        return this.tableModel.get(i);
    }

    public double getSum() {
        return this.sum;
    }

    public void setAddToTransaction(boolean selected) {
        this.addToTransaction.setSelected(selected);
    }

    public boolean isAddToTransactionSelected() {
        return this.addToTransaction.isSelected();
    }

    private void editSelected(GlobalData data) {
        int index = this.table.getSelectedRow();
        if (index >= 0) {
            SubTransaction old = this.tableModel.get(index);
            SubTransactionDialog dialog = new SubTransactionDialog(Utils.getOwnerWindow(this), data, old);
            this.setPredefinedDescriptions(dialog);
            if (this.updater != null) {
                dialog.setPredefinedUpdater(this.updater);
            }
            dialog.setVisible(true);
            SubTransaction sub = dialog.getSubTransaction();
            if (sub != null) {
                this.tableModel.replace(index, sub);
                double oldSum = this.sum;
                this.sum = this.sum - old.getAmount() + sub.getAmount();
                this.firePropertyChange(SUM_PROPERTY, oldSum, this.sum);
            }
        }
    }

    private void deleteSelected() {
        int index = this.table.getSelectedRow();
        if (index >= 0) {
            SubTransaction old = this.tableModel.get(index);
            this.tableModel.remove(index);
            double oldSum = this.sum;
            this.sum -= old.getAmount();
            this.firePropertyChange(SUM_PROPERTY, oldSum, this.sum);
        }
    }

    private void create(GlobalData data) {
        SubTransactionDialog dialog = new SubTransactionDialog(Utils.getOwnerWindow(this), data, null);
        this.setPredefinedDescriptions(dialog);
        if (this.updater != null) {
            dialog.setPredefinedUpdater(this.updater);
        }
        dialog.setVisible(true);
        SubTransaction sub = dialog.getSubTransaction();
        if (sub != null) {
            this.tableModel.add(sub);
            double oldSum = this.sum;
            this.sum += sub.getAmount();
            this.firePropertyChange(SUM_PROPERTY, oldSum, this.sum);
        }
    }

    private void setPredefinedDescriptions(SubTransactionDialog dialog) {
        if (this.predefinedDescriptionComputer != null) {
            dialog.setPredefined(this.predefinedDescriptionComputer.getPredefined(), this.predefinedDescriptionComputer.getUnsortedSize());
        }
    }

    public void setPredefinedDescriptionComputer(PredefinedDescriptionComputer predefinedDescriptionComputer) {
        this.predefinedDescriptionComputer = predefinedDescriptionComputer;
    }

    public void setPredefinedDescriptionUpdater(SubTransactionPanel.PredefinedDescriptionUpdater updater) {
        this.updater = updater;
    }

    void saveState(String prefix) {
        YapbamState.INSTANCE.saveState(this.table, prefix);
    }

    void restoreState(String prefix) {
        YapbamState.INSTANCE.restoreState(this.table, prefix);
    }
}

