/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.dialogs;

import com.fathzer.soft.ajlib.utilities.NullUtils;
import java.awt.CardLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.yapbam.data.Account;
import net.yapbam.data.GlobalData;
import net.yapbam.data.Mode;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.dialogs.CheckNumberWidget;
import net.yapbam.gui.widget.AutoSelectFocusListener;

public class TransactionNumberWidget
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JTextField transactionNumber;
    private CheckNumberWidget checkNumber;
    private boolean checkNumberIsVisible;

    public TransactionNumberWidget() {
        CardLayout layout = new CardLayout(0, 0);
        this.setLayout(layout);
        this.add((Component)this.getCheckNumberWidget(), "1");
        this.add((Component)this.getTransactionNumberField(), "2");
        layout.last(this);
        this.checkNumberIsVisible = false;
    }

    private JTextField getTransactionNumberField() {
        if (this.transactionNumber == null) {
            this.transactionNumber = new JTextField(15);
            this.transactionNumber.setToolTipText(LocalizationData.get("TransactionDialog.number.tooltip"));
            this.transactionNumber.addFocusListener(AutoSelectFocusListener.INSTANCE);
        }
        return this.transactionNumber;
    }

    private CheckNumberWidget getCheckNumberWidget() {
        if (this.checkNumber == null) {
            this.checkNumber = new CheckNumberWidget();
            this.checkNumber.addPropertyChangeListener("Number", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    TransactionNumberWidget.this.transactionNumber.setText(TransactionNumberWidget.this.checkNumber.getNumber());
                }
            });
        }
        return this.checkNumber;
    }

    public void set(GlobalData data, Account account, Mode mode, boolean expense) {
        boolean checkNumberRequired;
        boolean bl = checkNumberRequired = expense && mode.isUseCheckBook();
        if (checkNumberRequired != this.checkNumberIsVisible) {
            if (!checkNumberRequired) {
                this.transactionNumber.setText("");
            } else {
                this.checkNumber.setAccount(data, account);
            }
            CardLayout layout = (CardLayout)this.getLayout();
            if (checkNumberRequired) {
                layout.first(this);
            } else {
                layout.last(this);
            }
            this.checkNumberIsVisible = !this.checkNumberIsVisible;
        } else if (checkNumberRequired && !NullUtils.areEquals(this.checkNumber.getAccount(), account)) {
            this.checkNumber.setAccount(data, account);
        }
    }

    public String getNumber() {
        return this.checkNumberIsVisible ? this.getCheckNumberWidget().getNumber() : this.getTransactionNumberField().getText();
    }
}

