/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.dialogs.checkbook;

import com.fathzer.soft.ajlib.swing.dialog.AbstractDialog;
import java.awt.Window;
import javax.swing.JPanel;
import net.yapbam.data.Account;
import net.yapbam.data.Checkbook;
import net.yapbam.data.GlobalData;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.dialogs.checkbook.CheckbookPane;
import net.yapbam.gui.util.AutoUpdateOkButtonPropertyListener;

public class CheckbookDialog
extends AbstractDialog<Void, Checkbook> {
    private static final long serialVersionUID = 1L;
    private CheckbookPane pane;

    public CheckbookDialog(Window owner) {
        super(owner, LocalizationData.get("checkbookDialog.title.new"), null);
    }

    @Override
    protected JPanel createCenterPane() {
        this.pane = new CheckbookPane();
        this.pane.addPropertyChangeListener("invalidityCause", new AutoUpdateOkButtonPropertyListener(this));
        return this.pane;
    }

    @Override
    protected Checkbook buildResult() {
        return this.pane.getCheckbook();
    }

    public static Checkbook open(GlobalData data, Account account, Window owner) {
        CheckbookDialog dialog = new CheckbookDialog(owner);
        dialog.setVisible(true);
        Checkbook book = (Checkbook)dialog.getResult();
        if (book != null) {
            data.add(account, book);
        }
        return book;
    }

    @Override
    protected String getOkDisabledCause() {
        return this.pane.getInvalidityCause();
    }

    public void setContent(Checkbook book) {
        this.setTitle(LocalizationData.get("checkbookDialog.title.edit"));
        this.pane.setContent(book);
    }
}

