/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.dialogs.checkbook;

import com.fathzer.jlocal.Formatter;
import com.fathzer.soft.ajlib.swing.Utils;
import com.fathzer.soft.ajlib.swing.table.JTable;
import com.fathzer.soft.ajlib.swing.table.RowSorter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import net.yapbam.data.Account;
import net.yapbam.data.Checkbook;
import net.yapbam.data.GlobalData;
import net.yapbam.data.event.CheckbookPropertyChangedEvent;
import net.yapbam.data.event.DataEvent;
import net.yapbam.data.event.DataListener;
import net.yapbam.gui.IconManager;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.administration.AbstractListAdministrationPanel;
import net.yapbam.gui.dialogs.checkbook.AbstractCheckbookListModel;
import net.yapbam.gui.dialogs.checkbook.CheckbookDialog;

public class CheckbookListPanel
extends AbstractListAdministrationPanel<GlobalData> {
    private Account account;

    public CheckbookListPanel(GlobalData data) {
        super(data);
        ((GlobalData)this.data).addListener(new DataListener(){

            @Override
            public void processEvent(DataEvent event) {
                CheckbookPropertyChangedEvent checkbookChangedEvt;
                Checkbook old;
                ((AbstractTableModel)CheckbookListPanel.this.getJTable().getModel()).fireTableDataChanged();
                if (event instanceof CheckbookPropertyChangedEvent && !(old = (checkbookChangedEvt = (CheckbookPropertyChangedEvent)event).getOldCheckbook()).isEmpty() && checkbookChangedEvt.getNewCheckbook().isEmpty()) {
                    String message = Formatter.format(LocalizationData.get("checkbookDialog.finished.message"), old.getFullNumber(old.getFirst()), old.getFullNumber(old.getLast()));
                    Object[] options = new String[]{LocalizationData.get("GenericButton.ignore"), LocalizationData.get("checkbookDialog.finished.delete"), LocalizationData.get("checkbookDialog.finished.createNew"), LocalizationData.get("checkbookDialog.finished.DeleteAndCreateNew")};
                    int choice = JOptionPane.showOptionDialog(Utils.getOwnerWindow(CheckbookListPanel.this), message, LocalizationData.get("checkbookDialog.finished.title"), 1, 1, null, options, options[3]);
                    if (choice == 1 || choice == 3) {
                        ((GlobalData)CheckbookListPanel.this.data).remove(checkbookChangedEvt.getAccount(), checkbookChangedEvt.getNewCheckbook());
                    }
                    if (choice > 1) {
                        CheckbookListPanel.this.createBook(Utils.getOwnerWindow(CheckbookListPanel.this), checkbookChangedEvt.getAccount());
                    }
                }
            }
        });
        this.account = null;
        this.getJTable().setPreferredScrollableViewportSize(new Dimension(1, this.getJTable().getRowHeight() * 6));
        this.getJTable().setRowSorter(new RowSorter<TableModel>(this.getJTable().getModel()));
    }

    public void setContent(Account account) {
        this.account = account;
        this.getNewButton().getAction().setEnabled(account != null);
        ((AbstractTableModel)this.getJTable().getModel()).fireTableDataChanged();
    }

    @Override
    protected Action getDeleteButtonAction() {
        return new DeleteBookAction();
    }

    @Override
    protected Action getEditButtonAction() {
        return new EditBookAction();
    }

    @Override
    protected Action getNewButtonAction() {
        return new NewCheckbookAction();
    }

    @Override
    protected javax.swing.JTable instantiateJTable() {
        return new JTable(this.getTableModel());
    }

    protected TableModel getTableModel() {
        return new AbstractCheckbookListModel(){

            @Override
            public int getRowCount() {
                if (CheckbookListPanel.this.account == null) {
                    return 0;
                }
                return CheckbookListPanel.this.account.getCheckbooksNumber();
            }

            @Override
            protected Checkbook getCheckBook(int rowIndex) {
                return CheckbookListPanel.this.account.getCheckbook(rowIndex);
            }
        };
    }

    @Override
    protected Action getDuplicateButtonAction() {
        return null;
    }

    private void createBook(Window owner, Account account) {
        CheckbookDialog dialog = new CheckbookDialog(owner);
        dialog.setVisible(true);
        Checkbook book = (Checkbook)dialog.getResult();
        if (book != null) {
            ((GlobalData)this.data).add(account, book);
        }
    }

    private final class DeleteBookAction
    extends AbstractAction {
        public DeleteBookAction() {
            super(LocalizationData.get("GenericButton.delete"), IconManager.get(IconManager.Name.DELETE));
            this.putValue("ShortDescription", LocalizationData.get("checkbookDialog.Delete.tooltip"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = CheckbookListPanel.this.getJTable().convertRowIndexToModel(CheckbookListPanel.this.getJTable().getSelectedRow());
            ((GlobalData)CheckbookListPanel.this.data).remove(CheckbookListPanel.this.account, CheckbookListPanel.this.account.getCheckbook(row));
        }
    }

    private final class EditBookAction
    extends AbstractAction {
        public EditBookAction() {
            super(LocalizationData.get("GenericButton.edit"), IconManager.get(IconManager.Name.EDIT));
            this.putValue("ShortDescription", LocalizationData.get("checkbookDialog.Edit.tooltip"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = CheckbookListPanel.this.getJTable().convertRowIndexToModel(CheckbookListPanel.this.getJTable().getSelectedRow());
            Checkbook old = CheckbookListPanel.this.account.getCheckbook(row);
            CheckbookDialog dialog = new CheckbookDialog(Utils.getOwnerWindow((Component)e.getSource()));
            dialog.setContent(old);
            dialog.setVisible(true);
            Checkbook checkbook = (Checkbook)dialog.getResult();
            if (checkbook != null) {
                ((GlobalData)CheckbookListPanel.this.data).setCheckbook(CheckbookListPanel.this.account, old, checkbook);
            }
        }
    }

    private final class NewCheckbookAction
    extends AbstractAction {
        public NewCheckbookAction() {
            super(LocalizationData.get("GenericButton.new"), IconManager.get(IconManager.Name.NEW));
            this.putValue("ShortDescription", LocalizationData.get("checkbookDialog.New.tooltip"));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CheckbookListPanel.this.createBook(Utils.getOwnerWindow((Component)e.getSource()), CheckbookListPanel.this.account);
        }
    }
}

