/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.dialogs.checkbook;

import com.fathzer.soft.ajlib.swing.widget.IntegerWidget;
import com.fathzer.soft.ajlib.utilities.NullUtils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigInteger;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.yapbam.data.Checkbook;
import net.yapbam.gui.LocalizationData;

public class CheckbookPane
extends JPanel {
    private static final long serialVersionUID = 1L;
    static final String INVALIDITY_CAUSE = "invalidityCause";
    private IntegerWidget first = null;
    private IntegerWidget number = null;
    private String invalidityCause;
    private Checkbook currentBook;
    private JTextField prefix = null;
    private IntegerWidget next = null;
    private PropertyChangeListener changeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            CheckbookPane.this.parse();
        }
    };

    public CheckbookPane() {
        this.initialize();
        this.parse();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.gridy = 3;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.anchor = 13;
        gridBagConstraints4.insets = new Insets(5, 0, 0, 0);
        gridBagConstraints4.gridx = 1;
        GridBagConstraints gridBagConstraints31 = new GridBagConstraints();
        gridBagConstraints31.anchor = 17;
        gridBagConstraints31.gridx = 0;
        gridBagConstraints31.gridy = 3;
        JLabel jLabel3 = new JLabel();
        jLabel3.setText(LocalizationData.get("checkbookDialog.next"));
        GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
        gridBagConstraints21.fill = 2;
        gridBagConstraints21.gridy = 0;
        gridBagConstraints21.weightx = 1.0;
        gridBagConstraints21.anchor = 13;
        gridBagConstraints21.gridx = 1;
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.gridx = 0;
        gridBagConstraints11.anchor = 17;
        gridBagConstraints11.gridy = 0;
        JLabel jLabel2 = new JLabel();
        jLabel2.setText(LocalizationData.get("checkbookDialog.prefix"));
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.gridy = 2;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.anchor = 13;
        gridBagConstraints3.insets = new Insets(5, 0, 0, 0);
        gridBagConstraints3.gridx = 1;
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.gridy = 2;
        JLabel jLabel1 = new JLabel();
        jLabel1.setText(LocalizationData.get("checkbookDialog.number"));
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.anchor = 13;
        gridBagConstraints2.insets = new Insets(5, 0, 0, 0);
        gridBagConstraints2.gridx = 1;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridy = 1;
        JLabel jLabel = new JLabel();
        jLabel.setText(LocalizationData.get("checkbookDialog.first"));
        this.setSize(300, 200);
        this.setLayout(new GridBagLayout());
        this.add((Component)jLabel, gridBagConstraints);
        this.add((Component)this.getFirst(), gridBagConstraints2);
        this.add((Component)jLabel1, gridBagConstraints1);
        this.add((Component)this.getNumber(), gridBagConstraints3);
        this.add((Component)jLabel2, gridBagConstraints11);
        this.add((Component)this.getPrefix(), gridBagConstraints21);
        this.add((Component)jLabel3, gridBagConstraints31);
        this.add((Component)this.getNext(), gridBagConstraints4);
    }

    public String getInvalidityCause() {
        return this.invalidityCause;
    }

    public Checkbook getCheckbook() {
        return this.currentBook;
    }

    private IntegerWidget getFirst() {
        if (this.first == null) {
            this.first = new IntegerWidget(BigInteger.ZERO, null);
            this.first.setColumns(10);
            this.first.setToolTipText(LocalizationData.get("checkbookDialog.first.tooltip"));
            this.first.addPropertyChangeListener("VALUE_PROPERTY", this.changeListener);
        }
        return this.first;
    }

    private IntegerWidget getNumber() {
        if (this.number == null) {
            this.number = new IntegerWidget(BigInteger.ZERO, IntegerWidget.INTEGER_MAX_VALUE);
            this.number.setColumns(2);
            this.number.setToolTipText(LocalizationData.get("checkbookDialog.number.tooltip"));
            this.number.addPropertyChangeListener("VALUE_PROPERTY", this.changeListener);
        }
        return this.number;
    }

    private void parse() {
        String old = this.invalidityCause;
        this.invalidityCause = null;
        this.currentBook = null;
        if (this.first.getValue() == null) {
            this.invalidityCause = LocalizationData.get("checkbookDialog.error.firstIsBlank");
        } else if (this.number.getValue() == null) {
            this.invalidityCause = this.number.getText().isEmpty() ? LocalizationData.get("checkbookDialog.error.numberIsBlank") : LocalizationData.get("checkbookDialog.error.numberOutOfRange");
        } else if (this.next.getValue() == null) {
            this.invalidityCause = LocalizationData.get("checkbookDialog.error.nextIsBlank");
        } else {
            BigInteger diff = this.next.getValue().subtract(this.first.getValue());
            if (diff.signum() < 0 || diff.compareTo(this.number.getValue()) >= 0) {
                this.invalidityCause = LocalizationData.get("checkbookDialog.error.nextOutsideOfCheckbook");
            } else {
                this.currentBook = new Checkbook(this.prefix.getText(), this.first.getValue(), this.number.getValue().intValue(), this.next.getValue());
            }
        }
        if (!NullUtils.areEquals(old, this.invalidityCause)) {
            this.firePropertyChange(INVALIDITY_CAUSE, old, this.invalidityCause);
        }
    }

    public void setContent(Checkbook book) {
        this.prefix.setText(book.getPrefix());
        this.first.setValue(book.getFirst());
        this.number.setValue(book.size());
        this.next.setValue(book.getFirst().add(BigInteger.valueOf(book.getUsed())));
        this.parse();
    }

    private JTextField getPrefix() {
        if (this.prefix == null) {
            this.prefix = new JTextField();
            this.prefix.setColumns(10);
            this.prefix.setToolTipText(LocalizationData.get("checkbookDialog.prefix.tooltip"));
        }
        return this.prefix;
    }

    private IntegerWidget getNext() {
        if (this.next == null) {
            this.next = new IntegerWidget(BigInteger.ZERO, null);
            this.next.setToolTipText(LocalizationData.get("checkbookDialog.next.tooltip"));
            this.next.setColumns(10);
            this.next.addPropertyChangeListener("VALUE_PROPERTY", this.changeListener);
        }
        return this.next;
    }
}

