/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.dialogs.export;

import au.com.bytecode.opencsv.CSVReader;
import com.fathzer.jlocal.Formatter;
import com.fathzer.soft.ajlib.swing.table.JTable;
import com.fathzer.soft.ajlib.swing.table.NimbusPatchBooleanTableCellRenderer;
import com.fathzer.soft.ajlib.utilities.FileUtils;
import com.fathzer.soft.ajlib.utilities.NullUtils;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import net.yapbam.data.Account;
import net.yapbam.data.GlobalData;
import net.yapbam.gui.IconManager;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.dialogs.export.EmptyImportFileException;
import net.yapbam.gui.dialogs.export.ImportDialog;
import net.yapbam.gui.dialogs.export.ImportTableModel;
import net.yapbam.gui.dialogs.export.Importer;
import net.yapbam.gui.dialogs.export.ImporterParameters;
import net.yapbam.gui.dialogs.export.SeparatorPanel;
import net.yapbam.gui.util.JTableUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    static final String INVALIDITY_CAUSE = "invalidityCause";
    private JScrollPane jScrollPane;
    private javax.swing.JTable jTable;
    private JCheckBox ignoreFirstLine;
    private JPanel ignoreHeaderPanel;
    private JSpinner numberOfHeaderLines;
    private JButton first;
    private JButton last;
    private JCheckBox addToCurrentFile;
    private JComboBox accounts;
    private JPanel addToAccountPanel;
    private JLabel jLabel1;
    private SeparatorPanel columnSeparatorPanel;
    private SeparatorPanel decimalSeparatorPanel;
    private JPanel jPanel2;
    GlobalData data;
    private File file;
    private int numberOfLines;
    private int currentLine;
    private JComboBox fieldsCombo;
    private String invalidityCause;
    private File canonicalFile;
    private Logger logger;
    private JSpinner lineNumber;

    public ImportPanel() {
        this.initialize();
    }

    private void initialize() {
        GridBagConstraints gbcColumnSeparatorPanel = new GridBagConstraints();
        gbcColumnSeparatorPanel.gridx = 0;
        gbcColumnSeparatorPanel.gridy = 0;
        gbcColumnSeparatorPanel.fill = 2;
        gbcColumnSeparatorPanel.weightx = 1.0;
        gbcColumnSeparatorPanel.gridwidth = 0;
        GridBagConstraints gbcScrollPane = new GridBagConstraints();
        gbcScrollPane.gridx = 0;
        gbcScrollPane.gridy = 1;
        gbcScrollPane.fill = 1;
        gbcScrollPane.weightx = 1.0;
        gbcScrollPane.weighty = 1.0;
        gbcScrollPane.gridwidth = 0;
        GridBagConstraints gbcPanel2 = new GridBagConstraints();
        gbcPanel2.gridwidth = 0;
        gbcPanel2.gridx = 0;
        gbcPanel2.gridy = 2;
        gbcPanel2.fill = 2;
        GridBagConstraints gbcDecimalSeparatorPanel = (GridBagConstraints)gbcColumnSeparatorPanel.clone();
        gbcDecimalSeparatorPanel.gridy = 3;
        GridBagConstraints gbcAddToCurrentFile = new GridBagConstraints();
        gbcAddToCurrentFile.gridx = 0;
        gbcAddToCurrentFile.gridy = 4;
        gbcAddToCurrentFile.gridwidth = 0;
        gbcAddToCurrentFile.anchor = 17;
        GridBagConstraints gbcAddToAccountPanel = new GridBagConstraints();
        gbcAddToAccountPanel.gridx = 0;
        gbcAddToAccountPanel.gridy = 5;
        gbcAddToAccountPanel.fill = 2;
        gbcAddToAccountPanel.gridwidth = 0;
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getColumnSeparatorPanel(), gbcColumnSeparatorPanel);
        this.add((Component)this.getDecimalSeparatorPanel(), gbcDecimalSeparatorPanel);
        this.add((Component)this.getJScrollPane(), gbcScrollPane);
        this.add((Component)this.getAddToCurrentFile(), gbcAddToCurrentFile);
        this.add((Component)this.getAddToAccountPanel(), gbcAddToAccountPanel);
        this.add((Component)this.getJPanel2(), gbcPanel2);
        this.updateAddToAccountPanel();
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getJTable());
        }
        return this.jScrollPane;
    }

    private javax.swing.JTable getJTable() {
        if (this.jTable == null) {
            ImportTableModel model = new ImportTableModel();
            this.jTable = new JTable(model){

                @Override
                protected JTableHeader createDefaultTableHeader() {
                    return new JTableHeader(this.columnModel){

                        @Override
                        public String getToolTipText(MouseEvent e) {
                            Point p = e.getPoint();
                            int index = this.columnModel.getColumnIndexAtX(p.x);
                            int realIndex = this.columnModel.getColumn(index).getModelIndex();
                            String tip = realIndex == 1 ? LocalizationData.get("ImportDialog.linkedTo.toolTip") : (realIndex == 2 ? LocalizationData.get("ImportDialog.importedFields.toolTip") : ImportPanel.this.jTable.getColumnName(0));
                            return tip;
                        }
                    };
                }
            };
            this.jTable.getTableHeader().setReorderingAllowed(false);
            JTableUtils.initColumnSizes(this.jTable, Integer.MAX_VALUE);
            this.jTable.setPreferredScrollableViewportSize(this.getJTable().getPreferredSize());
            this.fieldsCombo = new JComboBox();
            TableColumn importedColumns = this.jTable.getColumnModel().getColumn(2);
            importedColumns.setCellEditor(new DefaultCellEditor(this.fieldsCombo));
            this.jTable.setDefaultRenderer(Boolean.class, new NimbusPatchBooleanTableCellRenderer());
            this.jTable.setFillsViewportHeight(true);
            model.addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent e) {
                    ImportPanel.this.updateAddToAccountPanel();
                    ImportPanel.this.updateIsValid();
                }
            });
        }
        return this.jTable;
    }

    private JPanel getIgnoreHeaderPanel() {
        if (this.ignoreHeaderPanel == null) {
            this.ignoreHeaderPanel = new JPanel(new FlowLayout());
            this.ignoreHeaderPanel.add(this.getIgnoreFirstLine());
            this.ignoreHeaderPanel.add(this.getNumberOfHeaderLinesSpinner());
        }
        return this.ignoreHeaderPanel;
    }

    private JCheckBox getIgnoreFirstLine() {
        if (this.ignoreFirstLine == null) {
            this.ignoreFirstLine = new JCheckBox();
            this.ignoreFirstLine.setText(LocalizationData.get("ImportDialog.ignoreFirstLine"));
            this.ignoreFirstLine.setSelected(true);
            this.ignoreFirstLine.setToolTipText(LocalizationData.get("ImportDialog.ignoreFirstLine.toolTip"));
            this.ignoreFirstLine.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    ImportPanel.this.getNumberOfHeaderLinesSpinner().setEnabled(ImportPanel.this.ignoreFirstLine.isSelected());
                    ImportPanel.this.doSetLine(ImportPanel.this.getNumberOfHeaderLines());
                }
            });
        }
        return this.ignoreFirstLine;
    }

    private JButton getFirst() {
        if (this.first == null) {
            this.first = new JButton(IconManager.get(IconManager.Name.BOTTOM));
            this.first.setToolTipText(LocalizationData.get("ImportDialog.first.toolTip"));
            this.first.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImportPanel.this.doSetLine(0);
                }
            });
            this.first.setFocusable(false);
        }
        return this.first;
    }

    private JButton getLast() {
        if (this.last == null) {
            this.last = new JButton(IconManager.get(IconManager.Name.TOP));
            this.last.setToolTipText(LocalizationData.get("ImportDialog.last.toolTip"));
            this.last.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImportPanel.this.doSetLine(ImportPanel.this.numberOfLines - 1);
                }
            });
            this.last.setFocusable(false);
        }
        return this.last;
    }

    private JCheckBox getAddToCurrentFile() {
        if (this.addToCurrentFile == null) {
            this.addToCurrentFile = new JCheckBox();
            this.addToCurrentFile.setText(LocalizationData.get("ImportDialog.addToCurrentFile"));
            this.addToCurrentFile.setToolTipText(LocalizationData.get("ImportDialog.addToCurrentFile.toolTip"));
            this.addToCurrentFile.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    ImportPanel.this.updateAddToAccountPanel();
                }
            });
        }
        return this.addToCurrentFile;
    }

    private void updateAddToAccountPanel() {
        boolean ok = this.addToCurrentFile.isSelected() && (Boolean)this.getJTable().getValueAt(0, 1) == false && this.data.getAccountsNumber() != 0;
        this.jLabel1.setEnabled(ok);
        this.accounts.setEnabled(ok);
        if (!ok) {
            this.accounts.setSelectedIndex(-1);
        } else if (this.accounts.getSelectedIndex() < 1) {
            this.accounts.setSelectedIndex(0);
        }
    }

    private JComboBox getAccounts() {
        if (this.accounts == null) {
            this.accounts = new JComboBox();
            this.accounts.setToolTipText(LocalizationData.get("ImportDialog.addToAccount.toolTip"));
        }
        return this.accounts;
    }

    private JPanel getAddToAccountPanel() {
        if (this.addToAccountPanel == null) {
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.gridy = 0;
            this.jLabel1 = new JLabel();
            this.jLabel1.setText(LocalizationData.get("ImportDialog.addToAccount"));
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.fill = 1;
            gridBagConstraints9.gridy = -1;
            gridBagConstraints9.weightx = 1.0;
            gridBagConstraints9.gridx = 1;
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.gridx = 0;
            gridBagConstraints8.gridy = 0;
            this.addToAccountPanel = new JPanel();
            this.addToAccountPanel.setLayout(new GridBagLayout());
            this.addToAccountPanel.add((Component)this.getAccounts(), gridBagConstraints9);
            this.addToAccountPanel.add((Component)this.jLabel1, gridBagConstraints6);
        }
        return this.addToAccountPanel;
    }

    private SeparatorPanel getColumnSeparatorPanel() {
        if (this.columnSeparatorPanel == null) {
            this.columnSeparatorPanel = SeparatorPanel.createColumnSeparatorPanel();
            this.columnSeparatorPanel.addPropertyChangeListener("separator", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    ImportPanel.this.setSeparator(ImportPanel.this.columnSeparatorPanel.getSeparator());
                }
            });
        }
        return this.columnSeparatorPanel;
    }

    private SeparatorPanel getDecimalSeparatorPanel() {
        if (this.decimalSeparatorPanel == null) {
            this.decimalSeparatorPanel = SeparatorPanel.createDecimalSeparatorPanel();
        }
        return this.decimalSeparatorPanel;
    }

    private void setSeparator(char separator) {
        if (separator == '\"' || separator == '\\') {
            this.getColumnSeparatorPanel().setError(LocalizationData.get("ImportDialog.badSeparator"));
            this.getFirst().setEnabled(false);
            this.getLast().setEnabled(false);
            String[] fields = new String[]{};
            this.setFieldsCombo(fields);
            ImportTableModel model = (ImportTableModel)this.getJTable().getModel();
            model.setFields(fields);
        } else {
            this.getColumnSeparatorPanel().setError(null);
            this.doSetLine(this.currentLine);
        }
        this.updateIsValid();
    }

    private void doSetLine(int line) {
        try {
            this.setLine(line);
        }
        catch (IOException e) {
            ImportDialog.doError(this, e);
        }
    }

    private JPanel getJPanel2() {
        if (this.jPanel2 == null) {
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.insets = new Insets(0, 0, 5, 0);
            gridBagConstraints1.anchor = 17;
            gridBagConstraints1.gridwidth = 0;
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridy = 1;
            gridBagConstraints1.weightx = 0.0;
            gridBagConstraints1.fill = 0;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.insets = new Insets(0, 0, 5, 5);
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.fill = 0;
            gridBagConstraints2.anchor = 13;
            gridBagConstraints2.gridy = 0;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.insets = new Insets(0, 0, 5, 0);
            gridBagConstraints5.anchor = 13;
            gridBagConstraints5.gridx = 2;
            gridBagConstraints5.gridy = 0;
            gridBagConstraints5.fill = 0;
            this.jPanel2 = new JPanel();
            this.jPanel2.setLayout(new GridBagLayout());
            this.jPanel2.add((Component)this.getLast(), gridBagConstraints5);
            this.jPanel2.add((Component)this.getFirst(), gridBagConstraints2);
            this.jPanel2.add((Component)this.getIgnoreHeaderPanel(), gridBagConstraints1);
            GridBagConstraints gbcLineNumber = new GridBagConstraints();
            gbcLineNumber.anchor = 13;
            gbcLineNumber.insets = new Insets(0, 0, 0, 5);
            gbcLineNumber.gridx = 1;
            gbcLineNumber.gridy = 0;
            this.jPanel2.add((Component)this.getLineNumber(), gbcLineNumber);
        }
        return this.jPanel2;
    }

    public void setFile(File file) throws IOException {
        this.file = file;
        this.canonicalFile = FileUtils.getCanonical(file);
        this.numberOfLines = 0;
        this.countFileLines();
        if (this.numberOfLines < 2) {
            this.getIgnoreFirstLine().setSelected(false);
            this.getIgnoreFirstLine().setEnabled(false);
        }
        int max = Math.max(this.numberOfLines - 1, 1);
        int current = Math.max(Math.min(this.getNumberOfHeaderLines(), max), 1);
        SpinnerNumberModel model = new SpinnerNumberModel(current, 1, max, 1);
        model.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ImportPanel.this.doSetLine(ImportPanel.this.getNumberOfHeaderLines());
            }
        });
        this.getNumberOfHeaderLinesSpinner().setModel(model);
        max = Math.max(this.numberOfLines, 1);
        model = new SpinnerNumberModel(1, 1, max, 1);
        model.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int futureLine = ((Number)ImportPanel.this.getLineNumber().getValue()).intValue() - 1;
                if (futureLine != ImportPanel.this.currentLine) {
                    ImportPanel.this.doSetLine(futureLine);
                }
            }
        });
        this.getLineNumber().setModel(model);
    }

    private void countFileLines() throws FileNotFoundException, IOException, EmptyImportFileException {
        CSVReader reader = new CSVReader(new FileReader(this.canonicalFile), this.columnSeparatorPanel.getSeparator(), '\"');
        try {
            String[] fields = reader.readNext();
            while (fields != null) {
                ++this.numberOfLines;
                fields = reader.readNext();
            }
            if (this.numberOfLines == 0) {
                throw new EmptyImportFileException();
            }
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                this.getLogger().warn("Error closing file " + this.canonicalFile, e);
            }
        }
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = LoggerFactory.getLogger(this.getClass());
        }
        return this.logger;
    }

    public void setLine(int lineNumber) throws IOException {
        if (lineNumber >= this.numberOfLines) {
            throw new IllegalArgumentException(Formatter.format("line ({0}) must be less than {1}", lineNumber, this.numberOfLines));
        }
        String[] fields = this.getFields(lineNumber);
        while (fields == null) {
            this.countFileLines();
            lineNumber = this.numberOfLines - 1;
            fields = this.getFields(lineNumber);
        }
        this.currentLine = lineNumber;
        boolean first = this.currentLine == 0;
        this.getFirst().setSelected(first);
        this.getFirst().setEnabled(!first);
        boolean last = this.currentLine == this.numberOfLines - 1;
        this.getLast().setSelected(last);
        this.getLast().setEnabled(!last);
        this.getLineNumber().setValue(lineNumber + 1);
        this.setFieldsCombo(fields);
        ImportTableModel model = (ImportTableModel)this.getJTable().getModel();
        model.setFields(fields);
    }

    private void setFieldsCombo(String[] fields) {
        this.fieldsCombo.removeAllItems();
        for (int i = 0; i < fields.length; ++i) {
            this.fieldsCombo.addItem(fields[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getFields(int lineNumber) throws IOException {
        CSVReader reader = new CSVReader((Reader)new FileReader(this.canonicalFile), this.columnSeparatorPanel.getSeparator(), '\"', lineNumber);
        try {
            String[] stringArray = reader.readNext();
            return stringArray;
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                this.getLogger().warn("Error while closing file " + this.canonicalFile, e);
            }
        }
    }

    public void setData(GlobalData data) {
        this.data = data;
        this.accounts.removeAllItems();
        for (int i = 0; i < data.getAccountsNumber(); ++i) {
            this.accounts.addItem(data.getAccount(i).getName());
        }
        boolean empty = data.getAccountsNumber() == 0;
        this.addToCurrentFile.setSelected(empty);
        this.addToCurrentFile.setEnabled(!empty);
        this.updateAddToAccountPanel();
    }

    public Importer getImporter() {
        boolean addToCurrentData = this.addToCurrentFile.isSelected();
        int index = this.accounts.getSelectedIndex();
        Account defaultAccount = index >= 0 ? this.data.getAccount(index) : null;
        return new Importer(this.file, new ImporterParameters(this.columnSeparatorPanel.getSeparator(), this.decimalSeparatorPanel.getSeparator(), this.getNumberOfHeaderLines(), ((ImportTableModel)this.getJTable().getModel()).getRelations()), addToCurrentData ? this.data : null, defaultAccount);
    }

    public boolean getAddToCurrentData() {
        return this.addToCurrentFile.isSelected();
    }

    public String getInvalidityCause() {
        return this.invalidityCause;
    }

    private void updateIsValid() {
        String old = this.invalidityCause;
        this.invalidityCause = this.getColumnSeparatorPanel().getError();
        if (this.invalidityCause == null) {
            int[] relations = ((ImportTableModel)this.getJTable().getModel()).getRelations();
            if (relations[4] < 0) {
                this.invalidityCause = LocalizationData.get("ImportDialog.noAmountSelected");
            } else if (relations[1] < 0) {
                this.invalidityCause = LocalizationData.get("ImportDialog.noDateSelected");
            }
        }
        if (!NullUtils.areEquals(this.invalidityCause, old)) {
            this.firePropertyChange(INVALIDITY_CAUSE, old, this.invalidityCause);
        }
    }

    public void setParameters(ImporterParameters parameters) {
        this.columnSeparatorPanel.setSeparator(parameters.getColumnSeparator());
        this.decimalSeparatorPanel.setSeparator(parameters.getDecimalSeparator());
        this.getIgnoreFirstLine().setSelected(this.numberOfLines > 1 && parameters.getIgnoredLeadingLines() != 0);
        if (this.getIgnoreFirstLine().isSelected()) {
            int max = Math.max(this.numberOfLines - 1, 1);
            int current = Math.max(Math.min(parameters.getIgnoredLeadingLines(), max), 1);
            this.getNumberOfHeaderLinesSpinner().setValue(current);
        }
        ((ImportTableModel)this.getJTable().getModel()).setRelations(parameters.getImportedFileColumns());
    }

    private JSpinner getLineNumber() {
        if (this.lineNumber == null) {
            this.lineNumber = new JSpinner();
            String columnName = LocalizationData.get("ImportDialog.importedFields");
            this.lineNumber.setToolTipText(Formatter.format(LocalizationData.get("ImportDialog.lineNumber.toolTip"), columnName));
            ((JSpinner.DefaultEditor)this.lineNumber.getEditor()).getTextField().setColumns(4);
        }
        return this.lineNumber;
    }

    private JSpinner getNumberOfHeaderLinesSpinner() {
        if (this.numberOfHeaderLines == null) {
            this.numberOfHeaderLines = new JSpinner();
            ((JSpinner.DefaultEditor)this.numberOfHeaderLines.getEditor()).getTextField().setColumns(4);
        }
        return this.numberOfHeaderLines;
    }

    private int getNumberOfHeaderLines() {
        return this.getIgnoreFirstLine().isSelected() ? ((Number)this.getNumberOfHeaderLinesSpinner().getValue()).intValue() : 0;
    }
}

