/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.dialogs.periodicaltransaction;

import com.fathzer.jlocal.Formatter;
import com.fathzer.soft.ajlib.swing.Utils;
import com.fathzer.soft.ajlib.swing.table.JTableListener;
import com.fathzer.soft.ajlib.swing.table.RowSorter;
import com.fathzer.soft.ajlib.swing.widget.date.DateWidget;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import net.yapbam.data.AbstractTransaction;
import net.yapbam.data.GlobalData;
import net.yapbam.data.Transaction;
import net.yapbam.gui.IconManager;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.YapbamState;
import net.yapbam.gui.dialogs.TransactionDialog;
import net.yapbam.gui.dialogs.periodicaltransaction.GenerateTableModel;
import net.yapbam.gui.dialogs.periodicaltransaction.GeneratedTransactionsTable;
import net.yapbam.gui.transactiontable.AmountRenderer;
import net.yapbam.gui.transactiontable.BooleanRenderer;
import net.yapbam.gui.transactiontable.DateRenderer;
import net.yapbam.gui.transactiontable.ObjectRenderer;
import net.yapbam.util.DateUtils;

public class PeriodicalTransactionGeneratorPanel
extends JPanel {
    static final String HAS_IMPACT_PROPERTY = "hasImpact";
    private static final String STATE_PROPERTIES_PREFIX = "net.yapbam.ihm.dialogs.PeriodicalGeneratorPanel.table.";
    private static final long serialVersionUID = 1L;
    private JPanel jPanel = null;
    private JLabel jLabel = null;
    private DateWidget dateField = null;
    private JLabel summary = null;
    private JScrollPane jScrollPane = null;
    private JTable jTable = null;
    private GenerateTableModel tableModel;
    private GlobalData data;
    private boolean hasImpact;
    private EditTransactionAction editAction;
    private JPanel panel;
    private JButton editButton;
    private JPanel panel1;

    public PeriodicalTransactionGeneratorPanel(GlobalData data) {
        this.data = data;
        this.hasImpact = false;
        this.initialize();
        this.getDateField().setDate(DateUtils.getMidnight(new Date()));
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getJPanel(), "North");
        this.add((Component)this.getJScrollPane(), "Center");
        this.add((Component)this.getPanel(), "South");
        this.updateTransactions();
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new BorderLayout(0, 0));
            this.jPanel.add((Component)this.getPanel1(), "North");
            this.summary = new JLabel();
            this.jPanel.add(this.summary);
        }
        return this.jPanel;
    }

    private DateWidget getDateField() {
        if (this.dateField == null) {
            this.dateField = new DateWidget();
            this.dateField.setDate(null);
            this.dateField.setToolTipText(LocalizationData.get("GeneratePeriodicalTransactionsDialog.lastDate.toolTip"));
            this.dateField.addPropertyChangeListener("date", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    PeriodicalTransactionGeneratorPanel.this.tableModel.setDate(PeriodicalTransactionGeneratorPanel.this.dateField.getDate());
                }
            });
        }
        return this.dateField;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getJTable());
        }
        return this.jScrollPane;
    }

    private JTable getJTable() {
        if (this.jTable == null) {
            this.tableModel = new GenerateTableModel(this.data);
            this.jTable = new GeneratedTransactionsTable(this.tableModel);
            this.jTable.setDefaultRenderer(Date.class, new DateRenderer());
            this.jTable.setDefaultRenderer(double[].class, new AmountRenderer());
            this.jTable.setDefaultRenderer(Boolean.class, new BooleanRenderer());
            this.jTable.setDefaultRenderer(Object.class, new ObjectRenderer());
            this.jTable.getSelectionModel().setSelectionMode(0);
            this.jTable.setRowSorter(new RowSorter<GenerateTableModel>(this.tableModel));
            this.restoreState();
            this.getEditAction().setEnabled(false);
            this.jTable.addMouseListener(new JTableListener(new Action[]{this.getEditAction()}, this.getEditAction()));
            this.jTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        PeriodicalTransactionGeneratorPanel.this.editAction.setEnabled(PeriodicalTransactionGeneratorPanel.this.jTable.getSelectedRowCount() > 0);
                    }
                }
            });
            this.tableModel.addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent e) {
                    PeriodicalTransactionGeneratorPanel.this.updateTransactions();
                }
            });
        }
        return this.jTable;
    }

    private Action getEditAction() {
        if (this.editAction == null) {
            this.editAction = new EditTransactionAction();
        }
        return this.editAction;
    }

    void saveState() {
        YapbamState.INSTANCE.saveState(this.getJTable(), STATE_PROPERTIES_PREFIX);
    }

    void restoreState() {
        YapbamState.INSTANCE.restoreState(this.getJTable(), STATE_PROPERTIES_PREFIX);
    }

    private void updateTransactions() {
        String message;
        if (this.getDateField().getDate() == null) {
            message = " ";
        } else {
            double debts = 0.0;
            double receipts = 0.0;
            for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
                AbstractTransaction transaction = this.tableModel.getTransaction(i);
                if (transaction.getAmount() > 0.0) {
                    receipts += transaction.getAmount();
                    continue;
                }
                debts += transaction.getAmount();
            }
            message = Formatter.format(LocalizationData.get("GeneratePeriodicalTransactionsDialog.summary"), this.tableModel.getRowCount(), LocalizationData.getCurrencyInstance().format(receipts), LocalizationData.getCurrencyInstance().format(-debts), LocalizationData.getCurrencyInstance().format(receipts + debts));
        }
        this.summary.setText(message);
        this.updateHasImpact();
    }

    private void updateHasImpact() {
        if (this.tableModel.hasImpact() != this.hasImpact) {
            this.hasImpact = !this.hasImpact;
            this.firePropertyChange(HAS_IMPACT_PROPERTY, !this.hasImpact, this.hasImpact);
        }
    }

    boolean hasImpact() {
        return this.hasImpact;
    }

    public boolean isValid(int i) {
        return this.tableModel.isValid(i);
    }

    Date getDate() {
        return this.getDateField().getDate();
    }

    public Transaction[] getValidTransactions() {
        ArrayList<Transaction> result = new ArrayList<Transaction>(this.tableModel.getRowCount());
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            if (!this.isValid(i)) continue;
            result.add((Transaction)this.tableModel.getTransaction(i));
        }
        return result.toArray(new Transaction[result.size()]);
    }

    public Date getPostponedDate(int indexPeriodical) {
        return this.tableModel.getPostponedDate(indexPeriodical);
    }

    private JPanel getPanel() {
        if (this.panel == null) {
            this.panel = new JPanel();
            this.panel.setLayout(new BorderLayout(0, 0));
            this.panel.add((Component)this.getEditButton(), "West");
        }
        return this.panel;
    }

    private JButton getEditButton() {
        if (this.editButton == null) {
            this.editButton = new JButton(this.getEditAction());
        }
        return this.editButton;
    }

    private JPanel getPanel1() {
        if (this.panel1 == null) {
            this.panel1 = new JPanel();
            GridBagLayout gblPanel1 = new GridBagLayout();
            gblPanel1.columnWidths = new int[]{0, 0, 0};
            gblPanel1.rowHeights = new int[]{0, 0};
            gblPanel1.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
            gblPanel1.rowWeights = new double[]{0.0, Double.MIN_VALUE};
            this.panel1.setLayout(gblPanel1);
            this.jLabel = new JLabel();
            GridBagConstraints gbcJLabel = new GridBagConstraints();
            gbcJLabel.anchor = 17;
            gbcJLabel.insets = new Insets(0, 0, 0, 5);
            gbcJLabel.gridx = 0;
            gbcJLabel.gridy = 0;
            this.panel1.add((Component)this.jLabel, gbcJLabel);
            this.jLabel.setText(LocalizationData.get("GeneratePeriodicalTransactionsDialog.lastDate"));
            GridBagConstraints gbcDateField = new GridBagConstraints();
            gbcDateField.anchor = 17;
            gbcDateField.gridx = 1;
            gbcDateField.gridy = 0;
            this.panel1.add((Component)this.getDateField(), gbcDateField);
        }
        return this.panel1;
    }

    private final class EditTransactionAction
    extends AbstractAction {
        public EditTransactionAction() {
            super(LocalizationData.get("MainMenu.Transactions.Edit"), IconManager.get(IconManager.Name.EDIT_TRANSACTION));
            this.putValue("ShortDescription", LocalizationData.get("MainMenu.Transactions.Edit.ToolTip"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (PeriodicalTransactionGeneratorPanel.this.jTable.getSelectedRowCount() == 0) {
                return;
            }
            int row = PeriodicalTransactionGeneratorPanel.this.jTable.convertRowIndexToModel(PeriodicalTransactionGeneratorPanel.this.jTable.getSelectedRow());
            Transaction transaction = (Transaction)PeriodicalTransactionGeneratorPanel.this.tableModel.getTransaction(row);
            transaction = TransactionDialog.open(PeriodicalTransactionGeneratorPanel.this.data, Utils.getOwnerWindow(PeriodicalTransactionGeneratorPanel.this.jTable), transaction, true, false, false);
            if (transaction != null) {
                PeriodicalTransactionGeneratorPanel.this.tableModel.setTransaction(row, transaction);
            }
        }
    }
}

