/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.dialogs.transaction;

import java.util.HashSet;
import java.util.Set;
import net.yapbam.data.Account;
import net.yapbam.data.GlobalData;
import net.yapbam.data.Mode;
import net.yapbam.data.Transaction;
import net.yapbam.gui.dialogs.transaction.EditionWizard;

public class ModeWizard
extends EditionWizard<Mode> {
    private Set<String> allowedModes = new HashSet<String>();

    public ModeWizard(GlobalData data, String description, Account account, boolean receipt) {
        super(data, description);
        for (int i = 0; i < account.getModesNumber(); ++i) {
            boolean ok;
            Mode mode = account.getMode(i);
            boolean bl = ok = receipt ? mode.isUsableForReceipt() : mode.isUsableForExpense();
            if (!ok) continue;
            this.allowedModes.add(mode.getName());
        }
    }

    @Override
    protected Mode getValue(Transaction transaction) {
        return this.allowedModes.contains(transaction.getMode().getName()) ? transaction.getMode() : null;
    }
}

