/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.dialogs.update;

import com.fathzer.jlocal.Formatter;
import com.fathzer.soft.ajlib.utilities.FileUtils;
import java.awt.Component;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.concurrent.ExecutionException;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import net.yapbam.gui.ErrorManager;
import net.yapbam.gui.HelpManager;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.Preferences;
import net.yapbam.gui.YapbamState;
import net.yapbam.gui.dialogs.update.InstallUpdateDialog;
import net.yapbam.gui.dialogs.update.LongTaskDialog;
import net.yapbam.gui.dialogs.update.WaitPanel;
import net.yapbam.gui.util.MessageWithLink;
import net.yapbam.update.UpdateInformation;
import net.yapbam.update.VersionManager;
import net.yapbam.util.ApplicationContext;
import net.yapbam.util.Portable;

public class CheckUpdateDialog
extends LongTaskDialog<Void, Void> {
    private static final boolean SLOW_UPDATE_CHECKING = Boolean.getBoolean("SlowUpdateChecking");
    private static final String YABAM_HOME_URL = "https://www.yapbam.net";
    private boolean auto;

    CheckUpdateDialog(Window owner, boolean auto, boolean forced) {
        super(owner, LocalizationData.get("MainMenu.CheckUpdate.Dialog.title"), null);
        this.auto = auto;
        if (auto) {
            this.setDelay(Long.MAX_VALUE);
        }
        this.getCancelButton().setToolTipText(LocalizationData.get("MainMenu.CheckUpdate.Dialog.cancel.tooltip"));
    }

    @Override
    protected Void buildResult() {
        return null;
    }

    @Override
    protected JPanel createCenterPane() {
        return new WaitPanel();
    }

    @Override
    protected String getOkDisabledCause() {
        return null;
    }

    @Override
    protected SwingWorker<?, ?> getWorker() {
        return new UpdateSwingWorker(this.getOwner());
    }

    public static void check(Window owner, boolean auto, boolean forced) {
        CheckUpdateDialog dialog = new CheckUpdateDialog(owner, auto, forced);
        dialog.setVisible(true);
        dialog.dispose();
    }

    class UpdateSwingWorker
    extends SwingWorker<UpdateInformation, Void> {
        private Window owner;

        UpdateSwingWorker(Window owner) {
            this.owner = owner;
        }

        @Override
        protected UpdateInformation doInBackground() throws Exception {
            if (SLOW_UPDATE_CHECKING) {
                Thread.sleep(2000L);
            }
            return VersionManager.getUpdateInformation();
        }

        @Override
        public void done() {
            block14: {
                try {
                    if (!this.isCancelled()) {
                        UpdateInformation update = (UpdateInformation)this.get();
                        CheckUpdateDialog.this.setVisible(false);
                        int code = update.getHttpErrorCode();
                        if (code != 200) {
                            if (!CheckUpdateDialog.this.auto) {
                                String message;
                                if (code == 407) {
                                    message = LocalizationData.get("MainMenu.CheckUpdate.ProxyAuthError");
                                } else {
                                    String pattern = LocalizationData.get("MainMenu.CheckUpdate.HttpError");
                                    message = Formatter.format(pattern, code, CheckUpdateDialog.YABAM_HOME_URL);
                                }
                                JOptionPane.showMessageDialog(this.owner, message, LocalizationData.get("MainMenu.CheckUpdate.Error.title"), 0);
                            }
                        } else {
                            YapbamState.INSTANCE.put("net.yapbam.lastUpdateCheck", new Date());
                            if (update.getLastestRelease().compareTo(ApplicationContext.getVersion()) > 0) {
                                if (this.isUpdateInstallable(update)) {
                                    CheckUpdateDialog.this.setVisible(false);
                                    InstallUpdateDialog dialog = new InstallUpdateDialog(this.owner, CheckUpdateDialog.this.auto && Preferences.INSTANCE.getAutoUpdateInstall(), update);
                                    dialog.setVisible(true);
                                }
                            } else if (!CheckUpdateDialog.this.auto) {
                                JOptionPane.showMessageDialog(this.owner, LocalizationData.get("MainMenu.CheckUpdate.NoUpdate"), LocalizationData.get("MainMenu.CheckUpdate.NoUpdate.title"), 1);
                            }
                        }
                    }
                }
                catch (InterruptedException update) {
                }
                catch (ExecutionException e) {
                    if (this.isCancelled() || CheckUpdateDialog.this.auto) break block14;
                    CheckUpdateDialog.this.setVisible(false);
                    Throwable cause = e.getCause();
                    if (cause instanceof IOException || cause instanceof UnknownHostException) {
                        String pattern = LocalizationData.get("MainMenu.CheckUpdate.IOError");
                        String message = Formatter.format(pattern, cause, CheckUpdateDialog.YABAM_HOME_URL);
                        JOptionPane.showMessageDialog(this.owner, message, LocalizationData.get("MainMenu.CheckUpdate.Error.title"), 0);
                    }
                    ErrorManager.INSTANCE.log(this.owner, cause);
                }
            }
        }

        private boolean isUpdateInstallable(UpdateInformation update) {
            File launchDirectory = Portable.getApplicationDirectory();
            boolean canWrite = FileUtils.isWritable(launchDirectory);
            if (CheckUpdateDialog.this.auto && Preferences.INSTANCE.getAutoUpdateInstall() && canWrite) {
                return true;
            }
            String title = LocalizationData.get("MainMenu.CheckUpdate.Success.title");
            if (!canWrite) {
                String open = LocalizationData.get("MainMenu.CheckUpdate.Success.openSite");
                String cancel = LocalizationData.get("GenericButton.cancel");
                String message = launchDirectory.canWrite() ? LocalizationData.get("MainMenu.CheckUpdate.Success.systemProtected") : LocalizationData.get("MainMenu.CheckUpdate.Success.writeProtected");
                int choice = JOptionPane.showOptionDialog(this.owner, new MessageWithLink(message = Formatter.format(message, ApplicationContext.getVersion(), update.getLastestRelease())), title, 2, 1, null, new String[]{cancel, open}, open);
                if (choice == 1) {
                    try {
                        HelpManager.show((Component)this.owner, new URI(CheckUpdateDialog.YABAM_HOME_URL));
                    }
                    catch (Exception e) {
                        ErrorManager.INSTANCE.log(this.owner, e);
                    }
                }
                return false;
            }
            String pattern = LocalizationData.get("MainMenu.CheckUpdate.Success.Detail");
            String download = LocalizationData.get("MainMenu.CheckUpdate.installNow");
            int choice = JOptionPane.showOptionDialog(this.owner, Formatter.format(pattern, ApplicationContext.getVersion(), update.getLastestRelease()), title, 2, 1, null, new String[]{LocalizationData.get("MainMenu.CheckUpdate.cancel"), download}, download);
            return choice == 1;
        }
    }
}

