/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.dialogs.update;

import com.fathzer.soft.ajlib.swing.dialog.AbstractDialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.SwingWorker;
import net.yapbam.gui.LocalizationData;

public abstract class LongTaskDialog<T, V>
extends AbstractDialog<T, V> {
    private static final long DEFAULT_DELAY = 500L;
    private static final int MINIMUM_TIME_VISIBLE = 1000;
    private long setVisibleTime;
    private long delay = 500L;
    private SwingWorker<?, ?> worker;
    private SwingWorker<Object, Void> showWorker;

    public LongTaskDialog(Window owner, String title, T data) {
        super(owner, title, data);
        this.getOkButton().setVisible(false);
        this.getCancelButton().setText(LocalizationData.get("GenericButton.cancel"));
        this.getCancelButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LongTaskDialog.this.worker.cancel(true);
            }
        });
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.worker = this.getWorker();
            this.worker.execute();
            this.showWorker = new SwingWorker<Object, Void>(){

                @Override
                protected Object doInBackground() throws Exception {
                    Thread.sleep(LongTaskDialog.this.delay);
                    return null;
                }

                @Override
                protected void done() {
                    if (!LongTaskDialog.this.worker.isDone()) {
                        LongTaskDialog.this.doShow();
                    }
                }
            };
            this.showWorker.execute();
        } else {
            if (this.showWorker != null) {
                this.showWorker.cancel(true);
            }
            long delay = 1000L - (System.currentTimeMillis() - this.setVisibleTime);
            try {
                if (delay > 0L) {
                    Thread.sleep(delay);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            super.setVisible(visible);
        }
    }

    protected abstract SwingWorker<?, ?> getWorker();

    private void doShow() {
        this.setVisibleTime = System.currentTimeMillis();
        super.setVisible(true);
    }
}

