/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.filter;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.filter.ConsistencyCheckedPanel;
import net.yapbam.gui.widget.AutoSelectFocusListener;
import net.yapbam.gui.widget.CurrencyWidget;

public class AmountPanel
extends ConsistencyCheckedPanel {
    private static final long serialVersionUID = 1L;
    private JPanel panel2;
    private JPanel panel1;
    private JRadioButton amountAll;
    private CurrencyWidget maxAmountWidget;
    private CurrencyWidget minAmountWidget;
    private JRadioButton amountBetween;
    private JRadioButton amountEquals;

    public AmountPanel() {
        GridBagLayout gblAmountPanel = new GridBagLayout();
        this.setLayout(gblAmountPanel);
        this.setBorder(BorderFactory.createTitledBorder(null, LocalizationData.get("Transaction.amount"), 0, 0));
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 5;
        gridBagConstraints4.gridy = 0;
        GridBagConstraints gbcPanel2 = new GridBagConstraints();
        gbcPanel2.anchor = 17;
        gbcPanel2.fill = 2;
        gbcPanel2.insets = new Insets(0, 0, 5, 5);
        gbcPanel2.gridx = 0;
        gbcPanel2.gridy = 0;
        this.add((Component)this.getPanel2(), gbcPanel2);
        GridBagConstraints gbcPanel1 = new GridBagConstraints();
        gbcPanel1.weightx = 1.0;
        gbcPanel1.fill = 1;
        gbcPanel1.anchor = 17;
        gbcPanel1.gridwidth = 3;
        gbcPanel1.gridx = 1;
        gbcPanel1.gridy = 0;
        this.add((Component)this.getPanel1(), gbcPanel1);
    }

    private JPanel getPanel2() {
        if (this.panel2 == null) {
            this.panel2 = new JPanel();
            GridBagLayout gblPanel2 = new GridBagLayout();
            this.panel2.setLayout(gblPanel2);
            GridBagConstraints gbcAmountAll = new GridBagConstraints();
            gbcAmountAll.anchor = 17;
            gbcAmountAll.insets = new Insets(0, 0, 0, 5);
            gbcAmountAll.gridx = 0;
            gbcAmountAll.gridy = 0;
            this.panel2.add((Component)this.getAmountAll(), gbcAmountAll);
            GridBagConstraints gbcamountEquals = new GridBagConstraints();
            gbcamountEquals.anchor = 17;
            gbcamountEquals.insets = new Insets(0, 0, 0, 5);
            gbcamountEquals.gridx = 0;
            gbcamountEquals.gridy = 1;
            this.panel2.add((Component)this.getAmountEquals(), gbcamountEquals);
            GridBagConstraints gbcamountBetween = new GridBagConstraints();
            gbcamountBetween.anchor = 17;
            gbcamountBetween.gridx = 0;
            gbcamountBetween.gridy = 2;
            this.panel2.add((Component)this.getAmountBetween(), gbcamountBetween);
            ButtonGroup group = new ButtonGroup();
            group.add(this.getAmountAll());
            group.add(this.getAmountEquals());
            group.add(this.getAmountBetween());
        }
        return this.panel2;
    }

    private JPanel getPanel1() {
        if (this.panel1 == null) {
            this.panel1 = new JPanel();
            GridBagLayout gblPanel1 = new GridBagLayout();
            this.panel1.setLayout(gblPanel1);
            GridBagConstraints gbcMaxAmount = new GridBagConstraints();
            gbcMaxAmount.insets = new Insets(0, 5, 0, 0);
            gbcMaxAmount.weightx = 1.0;
            gbcMaxAmount.fill = 2;
            gbcMaxAmount.gridx = 2;
            gbcMaxAmount.gridy = 0;
            this.panel1.add((Component)this.getMaxAmountWidget(), gbcMaxAmount);
            GridBagConstraints gbcMinAmount = new GridBagConstraints();
            gbcMinAmount.fill = 2;
            gbcMinAmount.insets = new Insets(0, 0, 0, 5);
            gbcMinAmount.weightx = 1.0;
            gbcMinAmount.gridx = 0;
            gbcMinAmount.gridy = 0;
            this.panel1.add((Component)this.getMinAmountWidget(), gbcMinAmount);
            JLabel jLabel = new JLabel();
            GridBagConstraints gbcJLabel = new GridBagConstraints();
            gbcJLabel.gridx = 1;
            gbcJLabel.gridy = 0;
            this.panel1.add((Component)jLabel, gbcJLabel);
            jLabel.setText(LocalizationData.get("CustomFilterPanel.amount.to"));
        }
        return this.panel1;
    }

    private JRadioButton getAmountEquals() {
        if (this.amountEquals == null) {
            this.amountEquals = new JRadioButton();
            this.amountEquals.setText(LocalizationData.get("CustomFilterPanel.amount.equals"));
            this.amountEquals.setToolTipText(LocalizationData.get("CustomFilterPanel.amount.equals.toolTip"));
            this.amountEquals.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (AmountPanel.this.amountEquals.isSelected()) {
                        AmountPanel.this.getMinAmountWidget().setEnabled(true);
                        AmountPanel.this.getMaxAmountWidget().setEnabled(false);
                        AmountPanel.this.getMaxAmountWidget().setValue(AmountPanel.this.getMinAmountWidget().getValue());
                    }
                }
            });
        }
        return this.amountEquals;
    }

    private JRadioButton getAmountBetween() {
        if (this.amountBetween == null) {
            this.amountBetween = new JRadioButton();
            this.amountBetween.setText(LocalizationData.get("CustomFilterPanel.amout.between"));
            this.amountBetween.setToolTipText(LocalizationData.get("CustomFilterPanel.amout.between.toolTip"));
            this.amountBetween.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (AmountPanel.this.amountBetween.isSelected()) {
                        AmountPanel.this.getMinAmountWidget().setEnabled(true);
                        AmountPanel.this.getMaxAmountWidget().setEnabled(true);
                    }
                }
            });
        }
        return this.amountBetween;
    }

    private CurrencyWidget getMinAmountWidget() {
        if (this.minAmountWidget == null) {
            this.minAmountWidget = new CurrencyWidget(LocalizationData.getLocale());
            this.minAmountWidget.setColumns(6);
            this.minAmountWidget.setEmptyAllowed(true);
            this.minAmountWidget.setMinValue(0.0);
            this.minAmountWidget.setToolTipText(LocalizationData.get("CustomFilterPanel.amout.minimum"));
            this.minAmountWidget.addPropertyChangeListener("value", this.consistencyChecker);
            this.minAmountWidget.addPropertyChangeListener("contentValid", this.consistencyChecker);
            this.minAmountWidget.addFocusListener(AutoSelectFocusListener.INSTANCE);
        }
        return this.minAmountWidget;
    }

    private CurrencyWidget getMaxAmountWidget() {
        if (this.maxAmountWidget == null) {
            this.maxAmountWidget = new CurrencyWidget(LocalizationData.getLocale());
            this.maxAmountWidget.setColumns(6);
            this.maxAmountWidget.setEmptyAllowed(true);
            this.maxAmountWidget.setMinValue(0.0);
            this.maxAmountWidget.setToolTipText(LocalizationData.get("CustomFilterPanel.amount.maximum"));
            this.maxAmountWidget.addPropertyChangeListener("value", this.consistencyChecker);
            this.maxAmountWidget.addPropertyChangeListener("contentValid", this.consistencyChecker);
            this.maxAmountWidget.addFocusListener(AutoSelectFocusListener.INSTANCE);
        }
        return this.maxAmountWidget;
    }

    private JRadioButton getAmountAll() {
        if (this.amountAll == null) {
            this.amountAll = new JRadioButton();
            this.amountAll.setText(LocalizationData.get("CustomFilterPanel.amount.all"));
            this.amountAll.setToolTipText(LocalizationData.get("CustomFilterPanel.amount.all.toolTip"));
            this.amountAll.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (AmountPanel.this.amountAll.isSelected()) {
                        AmountPanel.this.getMinAmountWidget().setValue(null);
                        AmountPanel.this.getMaxAmountWidget().setValue(null);
                        AmountPanel.this.getMinAmountWidget().setEnabled(false);
                        AmountPanel.this.getMaxAmountWidget().setEnabled(false);
                    }
                }
            });
        }
        return this.amountAll;
    }

    @Override
    protected String computeInconsistencyCause() {
        if (!this.getMinAmountWidget().isContentValid()) {
            return LocalizationData.get("CustomFilterPanel.error.amountMimimum");
        }
        if (!this.getMaxAmountWidget().isContentValid()) {
            return LocalizationData.get("CustomFilterPanel.error.amountMaximum");
        }
        if (this.getMinAmountWidget().getValue() != null && this.getMaxAmountWidget().getValue() != null && this.getMinAmountWidget().getValue() > this.getMaxAmountWidget().getValue()) {
            return LocalizationData.get("CustomFilterPanel.error.amountFromHigherThanTo");
        }
        return null;
    }

    public double getMinAmount() {
        return this.getMinAmountWidget().getValue() == null ? 0.0 : this.getMinAmountWidget().getValue();
    }

    public double getMaxAmount() {
        return this.getAmountEquals().isSelected() ? this.getMinAmount() : (this.getMaxAmountWidget().getValue() == null ? Double.POSITIVE_INFINITY : this.getMaxAmountWidget().getValue());
    }

    public void clear() {
        this.getAmountAll().setSelected(true);
    }

    public void setAmounts(double min, double max) {
        this.amountEquals.setSelected(min == max);
        this.amountBetween.setSelected((min != 0.0 || max != Double.POSITIVE_INFINITY) && max != min);
        this.minAmountWidget.setValue(min == 0.0 ? null : Double.valueOf(min));
        this.maxAmountWidget.setValue(max == Double.POSITIVE_INFINITY ? null : Double.valueOf(max));
        this.amountAll.setSelected(min == 0.0 && max == Double.POSITIVE_INFINITY);
    }
}

