/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.graphics.balancehistory;

import java.awt.Component;
import java.awt.Font;
import javax.swing.JTable;
import net.yapbam.gui.graphics.balancehistory.BalanceHistoryModel;
import net.yapbam.gui.graphics.balancehistory.TableSettings;
import net.yapbam.gui.util.CellRenderer;
import net.yapbam.gui.util.PaintedTable;

final class BalanceHistoryCellRenderer
extends CellRenderer {
    private Font defaultFont;
    private Font boldFont;

    BalanceHistoryCellRenderer() {
    }

    @Override
    protected Object getValue(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowModel, int columnModel) {
        BalanceHistoryModel model = (BalanceHistoryModel)table.getModel();
        return columnModel == model.getSettings().getRemainingColumn() && model.getHideIntermediateBalances() && !model.isDayBalance(rowModel) ? "" : super.getValue(table, value, isSelected, hasFocus, rowModel, columnModel);
    }

    @Override
    protected int getAlignment(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowModel, int columnModel) {
        TableSettings settings = ((BalanceHistoryModel)table.getModel()).getSettings();
        if (columnModel == settings.getAmountColumn() || columnModel == settings.getReceiptColumn() || columnModel == settings.getExpenseColumn() || columnModel == settings.getRemainingColumn()) {
            return 4;
        }
        if (columnModel == settings.getAccountColumn() || columnModel == settings.getDescriptionColumn()) {
            return 2;
        }
        return 0;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component result = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        row = table.convertRowIndexToModel(row);
        column = table.convertColumnIndexToModel(column);
        ((PaintedTable)((Object)table)).getPainter().setRowLook(result, table, row, isSelected);
        BalanceHistoryModel model = (BalanceHistoryModel)table.getModel();
        TableSettings settings = model.getSettings();
        Font font = !model.getHideIntermediateBalances() && column == settings.getRemainingColumn() && model.isDayBalance(row) ? this.getBoldFont(result) : this.getStdFont(result);
        result.setFont(font);
        return result;
    }

    private Font getBoldFont(Component component) {
        this.initFonts(component);
        return this.boldFont;
    }

    private Font getStdFont(Component component) {
        this.initFonts(component);
        return this.defaultFont;
    }

    private void initFonts(Component component) {
        if (this.boldFont == null) {
            this.defaultFont = component.getFont();
            this.boldFont = this.defaultFont.deriveFont(1);
        }
    }
}

