/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.graphics.balancehistory;

import com.fathzer.soft.ajlib.swing.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.Preferences;
import net.yapbam.gui.YapbamState;

class BalanceHistoryControlPane
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JLabel report = null;
    private JButton today = null;
    private JCheckBox isGridVisible = null;
    private JPanel center = null;
    private JSlider slider;
    private JPanel panel;

    public BalanceHistoryControlPane() {
        this.initialize();
    }

    private void initialize() {
        this.report = new JLabel();
        this.report.setToolTipText(LocalizationData.get("BalanceHistory.report.toolTip"));
        this.setLayout(new BorderLayout());
        this.add((Component)this.getCenter(), "Center");
        this.add((Component)this.getIsGridVisible(), "East");
        this.add((Component)this.getPanel(), "West");
    }

    JButton getToday() {
        if (this.today == null) {
            this.today = new JButton();
            URL url = this.getClass().getResource("/com/fathzer/soft/ajlib/swing/widget/date/stop.png");
            this.today.setIcon(Utils.createIcon(url, (int)(16.0f * Preferences.INSTANCE.getFontSizeRatio())));
            this.today.setToolTipText(LocalizationData.get("BalanceHistory.toDay.toolTip"));
            int size = this.today.getPreferredSize().height;
            this.today.setPreferredSize(new Dimension(size, size));
        }
        return this.today;
    }

    JCheckBox getIsGridVisible() {
        if (this.isGridVisible == null) {
            this.isGridVisible = new JCheckBox();
            this.isGridVisible.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
            this.isGridVisible.setText(LocalizationData.get("BalanceHistory.showGrid"));
            this.isGridVisible.setToolTipText(LocalizationData.get("BalanceHistory.showGrid.toolTip"));
        }
        return this.isGridVisible;
    }

    void setReportText(String report) {
        this.report.setText(report);
    }

    private JPanel getCenter() {
        if (this.center == null) {
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 2;
            gridBagConstraints2.insets = new Insets(0, 5, 0, 0);
            gridBagConstraints2.gridy = 0;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.insets = new Insets(0, 0, 0, 5);
            gridBagConstraints4.gridx = 1;
            gridBagConstraints4.gridy = 0;
            this.center = new JPanel();
            this.center.setLayout(new GridBagLayout());
            this.center.add((Component)this.report, gridBagConstraints4);
            this.center.add((Component)this.getToday(), gridBagConstraints2);
        }
        return this.center;
    }

    JSlider getSlider() {
        if (this.slider == null) {
            this.slider = new JSlider(0, 1, 20, 3);
            this.slider.setMinorTickSpacing(1);
            this.slider.setPaintTicks(true);
            this.slider.setSnapToTicks(true);
        }
        return this.slider;
    }

    private JPanel getPanel() {
        if (this.panel == null) {
            this.panel = new JPanel();
            this.panel.add(new JLabel(LocalizationData.get("BalanceHistory.zoom")));
            this.panel.add(this.getSlider());
        }
        return this.panel;
    }

    public void saveState() {
        YapbamState.INSTANCE.put(this.getHorizontalZoomStateKey(), Integer.toString(this.getSlider().getValue()));
        YapbamState.INSTANCE.put(this.getShowGridKey(), Boolean.toString(this.getIsGridVisible().isSelected()));
    }

    public void restoreState() {
        Integer value = YapbamState.INSTANCE.getInteger(this.getHorizontalZoomStateKey());
        if (value != null) {
            this.getSlider().setValue(value);
        }
        boolean showGrid = Boolean.parseBoolean(YapbamState.INSTANCE.get(this.getShowGridKey()));
        this.getIsGridVisible().setSelected(showGrid);
    }

    private String getHorizontalZoomStateKey() {
        return this.getClass().getCanonicalName() + ".horizontalZoom";
    }

    private String getShowGridKey() {
        return this.getClass().getCanonicalName() + ".showGrid";
    }
}

