/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.graphics.balancehistory;

import com.fathzer.jlocal.Formatter;
import java.awt.print.Printable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.JPanel;
import net.yapbam.data.FilteredData;
import net.yapbam.gui.AbstractPlugIn;
import net.yapbam.gui.IconManager;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.TransactionSelector;
import net.yapbam.gui.dialogs.preferences.PreferencePanel;
import net.yapbam.gui.graphics.balancehistory.BalanceHistoryPane;
import net.yapbam.gui.graphics.balancehistory.TablePreferencePanel;

public class BalanceHistoryPlugIn
extends AbstractPlugIn {
    private BalanceHistoryPane panel;
    private FilteredData data;

    public BalanceHistoryPlugIn(FilteredData filteredData, Object restartData) {
        this.data = filteredData;
        this.setPanelTitle(LocalizationData.get("BalanceHistory.title"));
        this.panel = new BalanceHistoryPane(this.data);
        this.setPanelToolTip(LocalizationData.get("BalanceHistory.toolTip"));
        PropertyChangeListener listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Date first = (Date)evt.getNewValue();
                BalanceHistoryPlugIn.this.setPanelIcon(first != null ? IconManager.get(IconManager.Name.ALERT) : null);
                String tooltip = LocalizationData.get("BalanceHistory.toolTip");
                if (first != null) {
                    String dateStr = DateFormat.getDateInstance(3, LocalizationData.getLocale()).format(first);
                    tooltip = tooltip.replace("'", "''");
                    String pattern = "<html>" + tooltip + "<br>" + LocalizationData.get("BalanceHistory.alertTooltipAdd") + "</html>";
                    tooltip = Formatter.format(pattern, "<b>" + dateStr + "</b>");
                }
                BalanceHistoryPlugIn.this.setPanelToolTip(tooltip);
            }
        };
        this.panel.addPropertyChangeListener("FIRST_ALERT", listener);
        if (this.panel.getFirstAlert() != null) {
            listener.propertyChange(new PropertyChangeEvent(this.panel, "FIRST_ALERT", null, this.panel.getFirstAlert()));
        }
        this.panel.addPropertyChangeListener("SELECTED_PANEL", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                BalanceHistoryPlugIn.this.setPrintingSupported((Integer)evt.getNewValue() == 1);
            }
        });
    }

    @Override
    public void setDisplayed(boolean displayed) {
        super.setDisplayed(displayed);
        this.panel.changeDisplayed();
    }

    @Override
    public JPanel getPanel() {
        return this.panel;
    }

    @Override
    public void saveState() {
        this.panel.saveState();
    }

    @Override
    public void restoreState() {
        this.panel.restoreState();
    }

    @Override
    protected Printable getPrintable() {
        return this.panel.getPrintable();
    }

    @Override
    public TransactionSelector getTransactionSelector() {
        return this.panel.getTransactionSelector();
    }

    @Override
    public PreferencePanel getLFPreferencePanel() {
        return new TablePreferencePanel();
    }
}

