/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.graphics.balancehistory;

import com.fathzer.soft.ajlib.swing.table.JTableSelector;
import java.util.Arrays;
import java.util.Date;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import net.yapbam.data.FilteredData;
import net.yapbam.data.Transaction;
import net.yapbam.gui.TransactionSelector;
import net.yapbam.gui.graphics.balancehistory.BalanceHistoryCellRenderer;
import net.yapbam.gui.graphics.balancehistory.BalanceHistoryModel;
import net.yapbam.gui.graphics.balancehistory.BalanceHistoryTablePainter;
import net.yapbam.gui.util.FriendlyTable;
import net.yapbam.gui.util.LinkEnabler;
import net.yapbam.gui.util.PaintedTable;
import net.yapbam.gui.util.TablePainter;

public class BalanceHistoryTable
extends FriendlyTable
implements TransactionSelector,
PaintedTable {
    private static final long serialVersionUID = 1L;
    private Transaction[] lastSelected;
    private FilteredData data;
    private TablePainter painter;

    public BalanceHistoryTable(FilteredData data) {
        this.data = data;
        this.painter = new BalanceHistoryTablePainter(data);
        BalanceHistoryModel model = new BalanceHistoryModel(data == null ? null : data.getBalanceData());
        this.setModel(model);
        if (data != null) {
            BalanceHistoryCellRenderer cellRenderer = new BalanceHistoryCellRenderer();
            this.setDefaultRenderer(Date.class, cellRenderer);
            this.setDefaultRenderer(Object.class, cellRenderer);
            LinkEnabler.enable(this, model.getSettings().getDescriptionColumn(), model.getSettings().getCommentColumn());
        }
        this.getSelectionModel().setSelectionMode(0);
        this.lastSelected = new Transaction[0];
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Object[] selectedTransaction;
                if (!e.getValueIsAdjusting() && !Arrays.equals(selectedTransaction = BalanceHistoryTable.this.getSelectedTransactions(), BalanceHistoryTable.this.lastSelected)) {
                    BalanceHistoryTable.this.firePropertyChange("selectedTransaction", BalanceHistoryTable.this.lastSelected, selectedTransaction);
                    BalanceHistoryTable.access$002(BalanceHistoryTable.this, (Transaction[])selectedTransaction);
                }
            }
        });
        TableRowSorter<BalanceHistoryModel> sorter = new TableRowSorter<BalanceHistoryModel>(model){

            @Override
            public int convertRowIndexToModel(int index) {
                if (this.isReverse()) {
                    return ((BalanceHistoryModel)this.getModel()).getRowCount() - 1 - index;
                }
                return index;
            }

            @Override
            public int convertRowIndexToView(int index) {
                if (this.isReverse()) {
                    return ((BalanceHistoryModel)this.getModel()).getRowCount() - 1 - index;
                }
                return index;
            }

            private boolean isReverse() {
                return this.getSortKeys().isEmpty() || this.getSortKeys().get(0).getSortOrder().equals((Object)SortOrder.DESCENDING);
            }

            @Override
            public void sort() {
            }
        };
        for (int i = 0; i < model.getColumnCount(); ++i) {
            sorter.setSortable(i, i == model.getSettings().getValueDateColumn());
        }
        this.setRowSorter((RowSorter<? extends TableModel>)sorter);
    }

    @Override
    public Transaction[] getSelectedTransactions() {
        int[] indexes = this.getSelectedRows();
        Transaction[] result = new Transaction[indexes.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = ((BalanceHistoryModel)this.getModel()).getTransaction(this.convertRowIndexToModel(indexes[i]));
        }
        return result;
    }

    @Override
    public void setSelectedTransactions(Transaction[] transactions) {
        JTableSelector<Transaction> selector = new JTableSelector<Transaction>((JTable)this){

            @Override
            public int getModelIndex(Transaction transaction) {
                return ((BalanceHistoryModel)BalanceHistoryTable.this.getModel()).find(transaction);
            }
        };
        selector.setSelected(transactions);
    }

    @Override
    public FilteredData getFilteredData() {
        return this.data;
    }

    @Override
    public TablePainter getPainter() {
        return this.painter;
    }

    static /* synthetic */ Transaction[] access$002(BalanceHistoryTable x0, Transaction[] x1) {
        x0.lastSelected = x1;
        return x1;
    }
}

