/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.graphics.balancehistory;

import com.fathzer.soft.ajlib.swing.Utils;
import com.fathzer.soft.ajlib.swing.dialog.FileChooser;
import com.fathzer.soft.ajlib.swing.table.JTableListener;
import com.fathzer.soft.ajlib.utilities.CSVWriter;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.print.Printable;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import net.yapbam.data.FilteredData;
import net.yapbam.gui.ErrorManager;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.YapbamState;
import net.yapbam.gui.actions.ConvertToPeriodicalTransactionAction;
import net.yapbam.gui.actions.DeleteTransactionAction;
import net.yapbam.gui.actions.DuplicateTransactionAction;
import net.yapbam.gui.actions.EditTransactionAction;
import net.yapbam.gui.graphics.balancehistory.BalanceHistoryModel;
import net.yapbam.gui.graphics.balancehistory.BalanceHistoryTable;
import net.yapbam.gui.util.FriendlyTable;

public class BalanceHistoryTablePane
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String HIDE_INTERMEDIATE_BALANCE_KEY = BalanceHistoryTablePane.class.getPackage().getName() + ".hideIntermediateBalance";
    private JLabel columnMenu;
    BalanceHistoryTable table;
    private FilteredData data;
    private JCheckBox hideIntermediateChkBx;

    public BalanceHistoryTablePane(FilteredData data) {
        this.data = data;
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gbcLabel = new GridBagConstraints();
        gbcLabel.insets = new Insets(0, 5, 5, 0);
        gbcLabel.anchor = 13;
        gbcLabel.gridx = 1;
        gbcLabel.gridy = 0;
        this.add((Component)this.getColumnMenu(), gbcLabel);
        JScrollPane scrollPane = new JScrollPane();
        GridBagConstraints gbcScrollPane = new GridBagConstraints();
        gbcScrollPane.insets = new Insets(0, 0, 5, 0);
        gbcScrollPane.weighty = 1.0;
        gbcScrollPane.gridwidth = 0;
        gbcScrollPane.fill = 1;
        gbcScrollPane.gridx = 0;
        gbcScrollPane.gridy = 1;
        this.add((Component)scrollPane, gbcScrollPane);
        scrollPane.setViewportView(this.getTable());
        final JButton btnExport = new JButton(LocalizationData.get("BudgetPanel.export"));
        btnExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File file;
                FileChooser chooser = new FileChooser();
                chooser.setLocale(new Locale(LocalizationData.getLocale().getLanguage()));
                File file2 = file = chooser.showSaveDialog(Utils.getOwnerWindow(btnExport)) == 0 ? ((JFileChooser)chooser).getSelectedFile() : null;
                if (file != null) {
                    try {
                        BalanceHistoryTablePane.this.getTable().export(file, new DefaultExporter(LocalizationData.getLocale()));
                    }
                    catch (IOException e1) {
                        ErrorManager.INSTANCE.display(btnExport, e1);
                    }
                }
            }
        });
        GridBagConstraints gbcChckbxHide = new GridBagConstraints();
        gbcChckbxHide.insets = new Insets(0, 0, 0, 5);
        gbcChckbxHide.gridx = 0;
        gbcChckbxHide.gridy = 2;
        this.add((Component)this.getHideIntermediateChkBx(), gbcChckbxHide);
        btnExport.setToolTipText("BudgetPanel.export.toolTip");
        btnExport.setHorizontalAlignment(4);
        GridBagConstraints gbcBtnExport = new GridBagConstraints();
        gbcBtnExport.anchor = 13;
        gbcBtnExport.weightx = 1.0;
        gbcBtnExport.gridx = 1;
        gbcBtnExport.gridy = 2;
        this.add((Component)btnExport, gbcBtnExport);
    }

    private JCheckBox getHideIntermediateChkBx() {
        if (this.hideIntermediateChkBx == null) {
            this.hideIntermediateChkBx = new JCheckBox(LocalizationData.get("BalanceHistory.transaction.hideIntermediate"));
            this.hideIntermediateChkBx.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    ((BalanceHistoryModel)BalanceHistoryTablePane.this.getTable().getModel()).setHideIntermediateBalances(e.getStateChange() == 1);
                }
            });
        }
        return this.hideIntermediateChkBx;
    }

    private JLabel getColumnMenu() {
        if (this.columnMenu == null) {
            this.columnMenu = new FriendlyTable.ShowHideColumsMenu(this.getTable(), LocalizationData.get("MainFrame.showColumns"));
            this.columnMenu.setToolTipText(LocalizationData.get("MainFrame.showColumns.ToolTip"));
            this.columnMenu.setHorizontalAlignment(4);
        }
        return this.columnMenu;
    }

    private BalanceHistoryTable getTable() {
        if (this.table == null) {
            this.table = new BalanceHistoryTable(this.data);
            if (this.data != null) {
                EditTransactionAction edit = new EditTransactionAction(this.table);
                DeleteTransactionAction delete = new DeleteTransactionAction(this.table);
                DuplicateTransactionAction duplicate = new DuplicateTransactionAction(this.table);
                this.table.addMouseListener(new JTableListener(new Action[]{edit, duplicate, delete, null, new ConvertToPeriodicalTransactionAction(this.table)}, edit));
            }
        }
        return this.table;
    }

    public void saveState() {
        YapbamState.INSTANCE.saveState(this.getTable(), this.getClass().getCanonicalName());
        YapbamState.INSTANCE.put(HIDE_INTERMEDIATE_BALANCE_KEY, Boolean.toString(this.getHideIntermediateChkBx().isSelected()));
    }

    public void restoreState() {
        YapbamState.INSTANCE.restoreState(this.getTable(), this.getClass().getCanonicalName());
        this.getHideIntermediateChkBx().setSelected(Boolean.parseBoolean(YapbamState.INSTANCE.get(HIDE_INTERMEDIATE_BALANCE_KEY, "true")));
    }

    public Printable getPrintable() {
        return this.getTable().getPrintable(JTable.PrintMode.FIT_WIDTH, null, null);
    }

    private final class DefaultExporter
    implements FriendlyTable.ExportFormat {
        private DateFormat dateFormater;
        private NumberFormat currencyFormat;

        private DefaultExporter(Locale locale) {
            this.dateFormater = SimpleDateFormat.getDateInstance(3, locale);
            this.currencyFormat = CSVWriter.getDecimalFormater(locale);
        }

        @Override
        public boolean hasHeader() {
            return true;
        }

        @Override
        public char getSeparator() {
            return '\t';
        }

        @Override
        public String format(Object obj) {
            if (obj == null) {
                return "";
            }
            if (obj instanceof Date) {
                return this.dateFormater.format(obj);
            }
            if (obj instanceof Double) {
                return this.currencyFormat.format(obj);
            }
            return obj.toString();
        }
    }
}

