/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.info;

import com.fathzer.soft.ajlib.swing.worker.Worker;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingUtilities;
import net.yapbam.gui.ErrorManager;
import net.yapbam.gui.Preferences;
import net.yapbam.gui.info.Message;
import net.yapbam.gui.info.MessagesPanel;
import net.yapbam.util.ApplicationContext;
import net.yapbam.util.CoolHttpConnection;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MessagesBuilder {
    private MessagesBuilder() {
    }

    public static void build(MessagesPanel infoPanel) {
        new UpdateSwingWorker(infoPanel).execute();
    }

    static class UpdateSwingWorker
    extends Worker<JSONArray, Void> {
        private static final Logger LOGGER = LoggerFactory.getLogger(MessagesBuilder.class);
        private static final boolean SLOW_UPDATE_CHECKING = false;
        private static final String BASE_URL_PROPERTY = "newsURL";
        private static final String BASE_URL = System.getProperty("newsURL", "https://www.yapbam.net/messages");
        private MessagesPanel infoPanel;

        UpdateSwingWorker(MessagesPanel infoPanel) {
            this.infoPanel = infoPanel;
        }

        @Override
        public void done() {
            try {
                if (!this.isCancelled()) {
                    JSONArray json = (JSONArray)this.get();
                    ArrayList<Message> news = new ArrayList<Message>();
                    if (json != null) {
                        for (int i = 0; i < json.size(); ++i) {
                            JSONObject obj = (JSONObject)json.get(i);
                            Message info = Message.build(obj);
                            if (info == null) continue;
                            news.add(info);
                        }
                        this.infoPanel.setMessages(news);
                    }
                }
            }
            catch (InterruptedException e) {
                LOGGER.trace("Worker was interrupted", e);
            }
            catch (ExecutionException e) {
                if (!(e.getCause() instanceof IOException)) {
                    ErrorManager.INSTANCE.log(SwingUtilities.getWindowAncestor(this.infoPanel), e);
                }
                LOGGER.warn("Error while communicating with server", e.getCause());
            }
        }

        @Override
        protected JSONArray doProcessing() throws Exception {
            URL url = ApplicationContext.toURL(BASE_URL);
            LOGGER.debug("Getting news from {}", (Object)url.toString());
            CoolHttpConnection ct = new CoolHttpConnection(url, Preferences.INSTANCE.getHttpProxy(), new URL[0]);
            int errorCode = ct.getResponseCode();
            if (errorCode == 200) {
                String encoding = ct.getContentEncoding();
                if (encoding == null) {
                    throw new IOException("Encoding is null");
                }
                InputStreamReader reader = new InputStreamReader(ct.getInputStream(), encoding);
                try {
                    BufferedReader r = new BufferedReader(reader);
                    try {
                        String line = r.readLine();
                        while (line != null) {
                            if (!line.startsWith("#")) {
                                LOGGER.debug("info: {}", (Object)line);
                                JSONArray jSONArray = (JSONArray)JSONValue.parse(line);
                                return jSONArray;
                            }
                            LOGGER.trace(line);
                            line = r.readLine();
                        }
                        throw new IOException("Not result found");
                    }
                    finally {
                        r.close();
                    }
                }
                finally {
                    reader.close();
                }
            }
            if (errorCode == 301 || errorCode == 302) {
                LOGGER.error("Redirection to {} was not followed.", (Object)ct.getHeaderField("Location"));
            }
            throw new IOException("Unexpected error code " + errorCode);
        }
    }
}

