/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.persistence;

import com.fathzer.jlocal.Formatter;
import com.fathzer.soft.ajlib.utilities.StringUtils;
import java.io.IOException;
import net.yapbam.gui.ErrorManager;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.persistence.PersistenceAdapter;
import net.yapbam.gui.persistence.PersistenceManager;
import net.yapbam.gui.persistence.classpath.ClasspathPersistenceAdapter;
import net.yapbam.gui.persistence.dropbox.YapbamDropboxPersistenceAdapter;
import net.yapbam.gui.persistence.file.FilePersistenceAdapter;

public class YapbamPersistenceManager
extends PersistenceManager {
    public static PersistenceManager MANAGER = new YapbamPersistenceManager();

    private YapbamPersistenceManager() {
        this.add(new FilePersistenceAdapter());
        try {
            this.add(new YapbamDropboxPersistenceAdapter());
            this.add(new ClasspathPersistenceAdapter());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String testedAdapter = System.getProperty("testedPersistenceAdapter.className");
        if (testedAdapter != null) {
            String[] testedAdapters;
            for (String className : testedAdapters = StringUtils.split(testedAdapter, ',')) {
                if (className.length() == 0) continue;
                try {
                    Class<?> pClass = Class.forName(className);
                    this.add((PersistenceAdapter)pClass.newInstance());
                }
                catch (Exception e) {
                    ErrorManager.INSTANCE.display(null, e, Formatter.format(LocalizationData.get("persitencePlugin.load.error"), className));
                }
            }
        }
    }
}

